/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.gl;

import android.opengl.GLES20;
import com.banuba.sdk.internal.gl.GlUtils;

public final class RenderBuffer {
    private final int mTextureId;
    private final int mRenderBufferId;
    private final int mFrameBufferId;
    private int mWidth;
    private int mHeight;
    private volatile int mFrame;

    private RenderBuffer(int n, int n2, int n3, int n4, int n5) {
        this.mWidth = n;
        this.mHeight = n2;
        this.mTextureId = n3;
        this.mRenderBufferId = n4;
        this.mFrameBufferId = n5;
    }

    public static RenderBuffer prepareFrameBuffer(int n, int n2) {
        return RenderBuffer.prepareFrameBuffer(n, n2, false);
    }

    public static RenderBuffer prepareFrameBuffer(int n, int n2, boolean bl) {
        GlUtils.checkGlErrorNoException("prepareFrameBuffer start");
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        GlUtils.checkGlErrorNoException("glGenTextures");
        int n3 = nArray[0];
        GLES20.glBindTexture((int)3553, (int)n3);
        GlUtils.checkGlErrorNoException("glBindTexture " + n3);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)n, (int)n2, (int)0, (int)6408, (int)5121, null);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        GlUtils.checkGlErrorNoException("glTexParameter");
        GLES20.glGenFramebuffers((int)1, (int[])nArray, (int)0);
        GlUtils.checkGlErrorNoException("glGenFramebuffers");
        int n4 = nArray[0];
        GLES20.glBindFramebuffer((int)36160, (int)n4);
        GlUtils.checkGlErrorNoException("glBindFramebuffer " + n4);
        int n5 = 0;
        if (bl) {
            GLES20.glGenRenderbuffers((int)1, (int[])nArray, (int)0);
            GlUtils.checkGlErrorNoException("glGenRenderbuffers");
            n5 = nArray[0];
            GLES20.glBindRenderbuffer((int)36161, (int)n5);
            GlUtils.checkGlErrorNoException("glBindRenderbuffer " + n5);
            GLES20.glRenderbufferStorage((int)36161, (int)33189, (int)n, (int)n2);
            GlUtils.checkGlErrorNoException("glRenderbufferStorage");
            GLES20.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)n5);
        }
        GlUtils.checkGlErrorNoException("glFramebufferRenderbuffer");
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)n3, (int)0);
        GlUtils.checkGlErrorNoException("glFramebufferTexture2D");
        int n6 = GLES20.glCheckFramebufferStatus((int)36160);
        if (n6 == 36053) {
            GLES20.glBindTexture((int)3553, (int)0);
            GLES20.glBindRenderbuffer((int)36161, (int)0);
            GLES20.glBindFramebuffer((int)36160, (int)0);
            GlUtils.checkGlErrorNoException("prepareFrameBuffer done");
            return new RenderBuffer(n, n2, n3, n5, n4);
        }
        throw new RuntimeException("Framebuffer not complete, status=" + n6);
    }

    public int getTextureId() {
        return this.mTextureId;
    }

    public int getFrameBufferId() {
        return this.mFrameBufferId;
    }

    public int getFrame() {
        return this.mFrame;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public void setFrame(int n) {
        this.mFrame = n;
    }

    public void resize(int n, int n2) {
        this.mWidth = n;
        this.mHeight = n2;
        GLES20.glBindTexture((int)3553, (int)this.mTextureId);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)n, (int)n2, (int)0, (int)6408, (int)5121, null);
        GLES20.glBindTexture((int)3553, (int)0);
    }

    public void clear() {
        int n;
        int[] nArray = new int[1];
        int n2 = this.mTextureId;
        if (n2 > 0) {
            nArray[0] = n2;
            GLES20.glDeleteTextures((int)1, (int[])nArray, (int)0);
        }
        if ((n2 = this.mFrameBufferId) > 0) {
            nArray[0] = n2;
            GLES20.glDeleteFramebuffers((int)1, (int[])nArray, (int)0);
        }
        if ((n = this.mRenderBufferId) > 0) {
            nArray[0] = n;
            GLES20.glDeleteRenderbuffers((int)1, (int[])nArray, (int)0);
        }
    }
}

