/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.gl;

import android.opengl.GLES20;
import com.banuba.sdk.internal.gl.GlUtils;
import com.banuba.sdk.internal.gl.TextureVBODrawable;

public class TextureVBO
implements TextureVBODrawable {
    private static final String SHADER_VEC = "   uniform mat4 u_MVPMatrix;                     \n  uniform mat4 uTexMatrix;                      \n  attribute vec4 a_position;                    \n  attribute vec2 a_texCoord;                    \n  varying vec2 v_texCoord;                      \n  void main()                                   \n  {                                             \n     gl_Position = u_MVPMatrix * a_position;    \n     vec4 texCoord = vec4(a_texCoord, 0.0, 1.0);\n     v_texCoord = (uTexMatrix * texCoord).xy;   \n  }                                             \n";
    private static final String SHADER_FRAG = "   precision mediump float;                             \n  varying vec2 v_texCoord;                             \n  uniform sampler2D s_baseMap;                         \n  uniform float u_alpha;                               \n  void main()                                          \n  {                                                    \n     vec4 color = texture2D(s_baseMap, v_texCoord);    \n     gl_FragColor = vec4(color.rgb, color.a * u_alpha);\n  }                                                    \n";
    private final int mProgramHandle;
    private final int mAttributePosition;
    private final int mAttributeTextureCoord;
    private final int mUniformMVPMatrix;
    private final int mUniformSampler;
    private final int mUniformTextureMatrix;
    private final int mUniformAlpha;
    private final boolean mExternalTexture;

    public TextureVBO(boolean bl) {
        int n;
        String string = bl ? "#extension GL_OES_EGL_image_external : require\n" + SHADER_FRAG.replace("sampler2D", "samplerExternalOES") : SHADER_FRAG;
        TextureVBO textureVBO = this;
        textureVBO.mExternalTexture = bl;
        this.mProgramHandle = n = GlUtils.loadProgram(SHADER_VEC, string);
        this.mAttributePosition = GLES20.glGetAttribLocation((int)n, (String)"a_position");
        this.mAttributeTextureCoord = GLES20.glGetAttribLocation((int)n, (String)"a_texCoord");
        this.mUniformMVPMatrix = GLES20.glGetUniformLocation((int)n, (String)"u_MVPMatrix");
        this.mUniformTextureMatrix = GLES20.glGetUniformLocation((int)n, (String)"uTexMatrix");
        this.mUniformSampler = GLES20.glGetUniformLocation((int)n, (String)"s_baseMap");
        textureVBO.mUniformAlpha = GLES20.glGetUniformLocation((int)n, (String)"u_alpha");
    }

    @Override
    public void draw(int n, float[] fArray, float[] fArray2, int n2, int n3, int n4, float f) {
        TextureVBO textureVBO = this;
        GLES20.glUseProgram((int)textureVBO.mProgramHandle);
        GLES20.glBindBuffer((int)34962, (int)n3);
        GLES20.glVertexAttribPointer((int)textureVBO.mAttributePosition, (int)3, (int)5126, (boolean)false, (int)12, (int)0);
        GLES20.glEnableVertexAttribArray((int)textureVBO.mAttributePosition);
        GLES20.glBindBuffer((int)34962, (int)n4);
        GLES20.glVertexAttribPointer((int)textureVBO.mAttributeTextureCoord, (int)2, (int)5126, (boolean)false, (int)8, (int)0);
        GLES20.glEnableVertexAttribArray((int)textureVBO.mAttributeTextureCoord);
        GLES20.glUniformMatrix4fv((int)textureVBO.mUniformMVPMatrix, (int)1, (boolean)false, (float[])fArray, (int)0);
        GLES20.glUniformMatrix4fv((int)textureVBO.mUniformTextureMatrix, (int)1, (boolean)false, (float[])fArray2, (int)0);
        int n5 = textureVBO.mUniformSampler;
        boolean bl = textureVBO.mExternalTexture;
        GlUtils.setupSampler(0, n5, n2, bl);
        GLES20.glUniform1f((int)textureVBO.mUniformAlpha, (float)f);
        GLES20.glDrawArrays((int)5, (int)0, (int)n);
        GLES20.glDisableVertexAttribArray((int)textureVBO.mAttributePosition);
        GLES20.glDisableVertexAttribArray((int)textureVBO.mAttributeTextureCoord);
        GLES20.glBindBuffer((int)34962, (int)0);
        GLES20.glUseProgram((int)0);
    }

    @Override
    public void close() {
        GLES20.glDeleteProgram((int)this.mProgramHandle);
    }
}

