/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.photo;

import android.os.Message;
import androidx.annotation.NonNull;
import com.banuba.sdk.entity.ContentRatioParams;
import com.banuba.sdk.internal.BaseWorkThread;
import com.banuba.sdk.internal.WeakHandler;
import com.banuba.sdk.internal.gl.RenderBuffer;
import com.banuba.sdk.internal.photo.PhotoThread;

public final class PhotoHandler
extends WeakHandler<PhotoThread> {
    private static final int MSG_SHUTDOWN = 0;
    private static final int MSG_FRAME_CAPTURED = 1;

    public PhotoHandler(@NonNull PhotoThread photoThread) {
        super(photoThread);
    }

    public final void sendShutDown() {
        PhotoHandler photoHandler = this;
        photoHandler.removeCallbacksAndMessages(null);
        photoHandler.sendMessage(photoHandler.obtainMessage(0));
    }

    public final void sendFrameCaptured(@NonNull RenderBuffer renderBuffer, ContentRatioParams contentRatioParams) {
        FrameCapturedArg frameCapturedArg;
        PhotoHandler photoHandler = object;
        Object object = frameCapturedArg;
        frameCapturedArg = new FrameCapturedArg(renderBuffer, contentRatioParams);
        photoHandler.sendMessage(photoHandler.obtainMessage(1, object));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleMessage(@NonNull Message message) {
        if ((object2 = (PhotoThread)((WeakHandler)((Object)object2)).getThread()) == null) return;
        int n = message.what;
        if (n != 0) {
            if (n != 1) throw new RuntimeException("unknown message " + message.what);
            Object object = object2;
            FrameCapturedArg frameCapturedArg = (FrameCapturedArg)message.obj;
            Object object2 = frameCapturedArg.buffer;
            ((PhotoThread)object).handleFrameCaptured((RenderBuffer)object2, frameCapturedArg.params);
            return;
        } else {
            ((BaseWorkThread)object2).shutdown();
        }
    }

    private static class FrameCapturedArg {
        @NonNull
        RenderBuffer buffer;
        ContentRatioParams params;

        FrameCapturedArg(@NonNull RenderBuffer renderBuffer, @NonNull ContentRatioParams contentRatioParams) {
            this.buffer = renderBuffer;
            this.params = contentRatioParams;
        }
    }
}

