/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.photo;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import androidx.annotation.NonNull;
import com.banuba.sdk.entity.ContentRatioParams;
import com.banuba.sdk.internal.BaseWorkThread;
import com.banuba.sdk.internal.encoding.RecordingListenerHandler;
import com.banuba.sdk.internal.gl.EglCore;
import com.banuba.sdk.internal.gl.GLFullRectTexture;
import com.banuba.sdk.internal.gl.GlUtils;
import com.banuba.sdk.internal.gl.OffscreenSurface;
import com.banuba.sdk.internal.gl.RenderBuffer;
import com.banuba.sdk.internal.photo.PhotoHandler;
import com.banuba.sdk.internal.renderer.RenderMsgSender;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public final class PhotoThread
extends BaseWorkThread<PhotoHandler> {
    private final float[] matrix;
    private EglCore eglCore;
    private GLFullRectTexture fullScreen;
    private final EglCore shared;
    private final RenderMsgSender renderMsgSender;
    private final RecordingListenerHandler recordingListenerHandler;

    public PhotoThread(@NonNull EglCore eglCore, @NonNull RenderMsgSender renderMsgSender, @NonNull RecordingListenerHandler recordingListenerHandler) {
        super("PhotoThread");
        this.shared = eglCore;
        this.renderMsgSender = renderMsgSender;
        this.recordingListenerHandler = recordingListenerHandler;
        this.matrix = new float[16];
        GlUtils.calculateCameraMatrix(this.matrix, 0.0f, 1);
    }

    @Override
    @NonNull
    protected PhotoHandler constructHandler() {
        return new PhotoHandler(this);
    }

    @Override
    protected void preRunInit() {
        this.eglCore = new EglCore(this.shared.getEGLContext(), 2);
    }

    @Override
    protected void postRunClear() {
        EglCore eglCore = ((PhotoThread)((Object)eglCore)).eglCore;
        if (eglCore != null) {
            eglCore.release();
        }
    }

    public final void handleFrameCaptured(@NonNull RenderBuffer renderBuffer, ContentRatioParams contentRatioParams) {
        ContentRatioParams contentRatioParams2 = contentRatioParams;
        int n = contentRatioParams2.getWidth();
        int n2 = contentRatioParams2.getHeight();
        new OffscreenSurface(((PhotoThread)object).eglCore, n, n2).makeCurrent();
        ((PhotoThread)object).fullScreen = new GLFullRectTexture(false);
        GlUtils.checkGlErrorNoException("Context Create and Photo Thread Init");
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GlUtils.checkGlErrorNoException("glBindFramebuffer Screen Shot");
        GLES20.glViewport((int)0, (int)0, (int)n, (int)n2);
        GLFullRectTexture gLFullRectTexture = ((PhotoThread)object).fullScreen;
        if (gLFullRectTexture != null) {
            int n3 = renderBuffer.getTextureId();
            gLFullRectTexture.draw(n3, ((PhotoThread)object).matrix);
        }
        PhotoThread photoThread = object;
        Object object = ByteBuffer.wrap(new byte[n * n2 * 4]);
        GLES20.glReadPixels((int)0, (int)0, (int)n, (int)n2, (int)6408, (int)5121, (Buffer)object);
        Bitmap bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.copyPixelsFromBuffer((Buffer)object);
        photoThread.renderMsgSender.sendFreeBuffer(renderBuffer);
        photoThread.renderMsgSender.sendResumeDoFrame();
        photoThread.recordingListenerHandler.sendPhotoReady(bitmap);
        object = (PhotoHandler)((Object)photoThread.getHandler());
        if (object != null) {
            ((PhotoHandler)((Object)object)).sendShutDown();
        }
    }
}

