/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.renderer;

import android.os.Message;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.entity.ContentRatioParams;
import com.banuba.sdk.entity.WatermarkInfo;
import com.banuba.sdk.internal.WeakHandler;
import com.banuba.sdk.internal.gl.RenderBuffer;
import com.banuba.sdk.internal.renderer.RenderMsgSender;
import com.banuba.sdk.internal.renderer.RenderThread;
import com.banuba.sdk.internal.utils.Logger;
import com.banuba.sdk.internal.utils.TypeUtils;
import com.banuba.sdk.types.FullImageData;
import java.io.File;

public class RenderHandler
extends WeakHandler<RenderThread>
implements RenderMsgSender {
    private static final int MSG_SHUTDOWN = 0;
    private static final int MSG_SURFACE_CREATED = 1;
    private static final int MSG_SURFACE_CHANGED = 2;
    private static final int MSG_SURFACE_DESTROYED = 3;
    private static final int MSG_DO_FRAME = 4;
    private static final int MSG_TAKE_PHOTO = 5;
    private static final int MSG_START_RECORDING = 7;
    private static final int MSG_STOP_RECORDING = 8;
    private static final int MSG_RECORDING_COMPLETED = 9;
    private static final int MSG_FREE_BUFFER = 10;
    private static final int MSG_STOP_DO_FRAME = 11;
    private static final int MSG_RESUME_DO_FRAME = 12;
    private static final int MSG_WATERMARK_INFO = 13;
    private static final int MSG_PROCESS_PHOTO = 14;
    private static final int MSG_PROCESS_IMAGE = 15;
    private static final int MSG_START_EDITING_IMAGE = 16;
    private static final int MSG_STOP_EDITING_IMAGE = 17;
    private static final int MSG_TAKE_EDITED_IMAGE = 18;
    private static final int MSG_START_FRAME_FORWARDING = 20;
    private static final int MSG_STOP_FRAME_FORWARDING = 21;
    private static final int MSG_EFFECT_PLAYER_PLAY = 22;
    private static final int MSG_EFFECT_PLAYER_PAUSE = 23;
    private static final int MSG_CLEAR_SURFACE = 24;
    private static final int MSG_RUNNABLE = 25;
    private static final int MSG_START_TEXTURE_FORWARDING = 26;
    private static final int MSG_STOP_TEXTURE_FORWARDING = 27;
    private static final int MSG_PAUSE_RECORDING = 28;
    private static final int MSG_UNPAUSE_RECORDING = 29;

    RenderHandler(RenderThread renderThread) {
        super(renderThread);
    }

    @Override
    public void sendSurfaceCreated(Surface surface) {
        RenderHandler renderHandler = this;
        renderHandler.sendMessage(renderHandler.obtainMessage(1, surface));
    }

    @Override
    public void sendSurfaceChanged(int n, int n2) {
        RenderHandler renderHandler = this;
        renderHandler.sendMessage(renderHandler.obtainMessage(2, n, n2));
    }

    @Override
    public void sendSurfaceDestroyed() {
        RenderHandler renderHandler = this;
        renderHandler.sendMessage(renderHandler.obtainMessage(3));
    }

    @Override
    public void sendDoFrame(long l) {
        RenderHandler renderHandler = this;
        long l2 = l;
        int n = TypeUtils.getLongHighBits(l2);
        int n2 = TypeUtils.getLongLowBits(l2);
        renderHandler.sendMessage(renderHandler.obtainMessage(4, n, n2));
    }

    @Override
    public void sendShutdown() {
        RenderHandler renderHandler = this;
        renderHandler.sendMessage(renderHandler.obtainMessage(0));
    }

    @Override
    public boolean isRealRenderer() {
        return true;
    }

    @Override
    public void sendTakePhoto(ContentRatioParams contentRatioParams) {
        RenderHandler renderHandler = this;
        renderHandler.sendMessage(renderHandler.obtainMessage(5, contentRatioParams));
    }

    @Override
    public void sendStartRecording(@Nullable String string, boolean bl, @Nullable ContentRatioParams contentRatioParams, float f) {
        StartRecordingArg startRecordingArg;
        RenderHandler renderHandler = startRecordingArg2;
        StartRecordingArg startRecordingArg2 = startRecordingArg;
        startRecordingArg = new StartRecordingArg(string, bl, contentRatioParams, f);
        renderHandler.sendMessage(renderHandler.obtainMessage(7, startRecordingArg2));
    }

    @Override
    public void sendStopRecording() {
        RenderHandler renderHandler = this;
        renderHandler.sendMessage(renderHandler.obtainMessage(8));
    }

    @Override
    public void sendPauseRecording() {
        RenderHandler renderHandler = this;
        renderHandler.sendMessage(renderHandler.obtainMessage(28));
    }

    @Override
    public void sendUnpauseRecording() {
        RenderHandler renderHandler = this;
        renderHandler.sendMessage(renderHandler.obtainMessage(29));
    }

    @Override
    public void sendRecordingCompleted(@NonNull File file) {
        RenderHandler renderHandler = this;
        renderHandler.sendMessage(renderHandler.obtainMessage(9, file));
    }

    @Override
    public void sendFreeBuffer(@NonNull RenderBuffer renderBuffer) {
        RenderHandler renderHandler = this;
        renderHandler.sendMessage(renderHandler.obtainMessage(10, renderBuffer));
    }

    @Override
    public void sendStopDoFrame() {
        RenderHandler renderHandler = this;
        renderHandler.sendMessage(renderHandler.obtainMessage(11));
        renderHandler.removeMessages(4);
    }

    @Override
    public void sendClearSurface() {
        RenderHandler renderHandler = this;
        renderHandler.sendMessage(renderHandler.obtainMessage(24));
    }

    @Override
    public void sendRunnable(Runnable runnable) {
        RenderHandler renderHandler = this;
        renderHandler.sendMessage(renderHandler.obtainMessage(25, runnable));
    }

    @Override
    public void sendResumeDoFrame() {
        RenderHandler renderHandler = this;
        renderHandler.sendMessage(renderHandler.obtainMessage(12));
    }

    @Override
    public void sendWatermarkInfo(WatermarkInfo watermarkInfo) {
        RenderHandler renderHandler = this;
        renderHandler.sendMessage(renderHandler.obtainMessage(13, watermarkInfo));
    }

    @Override
    public void sendProcessPhoto(@NonNull FullImageData fullImageData) {
        ProcessImageArg processImageArg;
        RenderHandler renderHandler = processImageArg2;
        ProcessImageArg processImageArg2 = processImageArg;
        processImageArg = new ProcessImageArg(fullImageData);
        renderHandler.sendMessage(renderHandler.obtainMessage(14, processImageArg2));
    }

    @Override
    public void sendProcessImage(@NonNull FullImageData fullImageData) {
        ProcessImageArg processImageArg;
        RenderHandler renderHandler = processImageArg2;
        ProcessImageArg processImageArg2 = processImageArg;
        processImageArg = new ProcessImageArg(fullImageData);
        renderHandler.sendMessage(renderHandler.obtainMessage(15, processImageArg2));
    }

    @Override
    public void sendStartEditingImage(@NonNull FullImageData fullImageData) {
        ProcessImageArg processImageArg;
        RenderHandler renderHandler = processImageArg2;
        renderHandler.removeMessages(4);
        ProcessImageArg processImageArg2 = processImageArg;
        processImageArg = new ProcessImageArg(fullImageData);
        renderHandler.sendMessage(renderHandler.obtainMessage(16, processImageArg2));
    }

    @Override
    public void sendStopEditingImage() {
        RenderHandler renderHandler = this;
        renderHandler.removeMessages(4);
        renderHandler.sendMessage(renderHandler.obtainMessage(17));
    }

    @Override
    public void sendTakeEditedImage() {
        RenderHandler renderHandler = this;
        renderHandler.removeMessages(4);
        renderHandler.sendMessage(renderHandler.obtainMessage(18));
    }

    @Override
    public void sendStartForwardingFrames() {
        RenderHandler renderHandler = this;
        renderHandler.sendMessage(renderHandler.obtainMessage(20));
    }

    @Override
    public void sendStopForwardingFrames() {
        RenderHandler renderHandler = this;
        renderHandler.sendMessage(renderHandler.obtainMessage(21));
    }

    @Override
    public void sendEffectPlayerPlay() {
        RenderHandler renderHandler = this;
        renderHandler.sendMessage(renderHandler.obtainMessage(22));
    }

    @Override
    public void sendEffectPlayerPause() {
        RenderHandler renderHandler = this;
        renderHandler.sendMessage(renderHandler.obtainMessage(23));
    }

    @Override
    public void sendStartForwardingTextures() {
        RenderHandler renderHandler = this;
        renderHandler.sendMessage(renderHandler.obtainMessage(26));
    }

    @Override
    public void sendStopForwardingTextures() {
        RenderHandler renderHandler = this;
        renderHandler.sendMessage(renderHandler.obtainMessage(27));
    }

    public void handleMessage(Message message) {
        RenderThread renderThread = (RenderThread)((WeakHandler)((Object)string)).getThread();
        if (renderThread != null) {
            switch (message.what) {
                default: {
                    throw new RuntimeException("unknown message " + message.what);
                }
                case 29: {
                    renderThread.setPauseRecording(false);
                    break;
                }
                case 28: {
                    renderThread.setPauseRecording(true);
                    break;
                }
                case 27: {
                    renderThread.handleStopForwardingTextures();
                    break;
                }
                case 26: {
                    renderThread.handleStartForwardingTextures();
                    break;
                }
                case 25: {
                    renderThread.handleRunnable((Runnable)message.obj);
                    break;
                }
                case 24: {
                    renderThread.handleClearSurface();
                    break;
                }
                case 23: {
                    renderThread.handleEffectPlayerPause();
                    break;
                }
                case 22: {
                    renderThread.handleEffectPlayerPlay();
                    break;
                }
                case 21: {
                    renderThread.handleStopForwardingFrames();
                    break;
                }
                case 20: {
                    renderThread.handleStartForwardingFrames();
                    break;
                }
                case 18: {
                    renderThread.handleTakeEditedImage();
                    break;
                }
                case 17: {
                    renderThread.handleStopEditingImage();
                    break;
                }
                case 16: {
                    renderThread.handleStartEditingImage(((ProcessImageArg)message.obj).image);
                    break;
                }
                case 15: {
                    renderThread.handleProcessImage(((ProcessImageArg)message.obj).image);
                    break;
                }
                case 14: {
                    renderThread.handleProcessPhoto(((ProcessImageArg)message.obj).image);
                    break;
                }
                case 13: {
                    renderThread.handleWatermarkInfo((WatermarkInfo)message.obj);
                    break;
                }
                case 12: {
                    renderThread.resumeDoFrame();
                    break;
                }
                case 11: {
                    renderThread.stopDoFrame();
                    break;
                }
                case 10: {
                    renderThread.freeBuffer((RenderBuffer)message.obj);
                    break;
                }
                case 9: {
                    renderThread.onRecordingCompleted();
                    break;
                }
                case 8: {
                    renderThread.stopRecording();
                    break;
                }
                case 7: {
                    StartRecordingArg startRecordingArg = (StartRecordingArg)message.obj;
                    String string = startRecordingArg.fileName;
                    boolean bl = startRecordingArg.mic;
                    ContentRatioParams contentRatioParams = startRecordingArg.params;
                    float f = startRecordingArg.speed;
                    renderThread.startRecording(string, bl, contentRatioParams, f);
                    break;
                }
                case 5: {
                    renderThread.takePhoto((ContentRatioParams)message.obj);
                    break;
                }
                case 4: {
                    string.removeMessages(4);
                    long l = TypeUtils.getLongFromInts(message.arg1, message.arg2);
                    renderThread.doFrame(l);
                    break;
                }
                case 3: {
                    renderThread.surfaceDestroyed();
                    break;
                }
                case 2: {
                    Message message2 = message;
                    int n = message2.arg1;
                    int n2 = message2.arg2;
                    renderThread.surfaceChanged(n, n2);
                    break;
                }
                case 1: {
                    renderThread.surfaceCreated((Surface)message.obj);
                    break;
                }
                case 0: {
                    renderThread.shutdown();
                    break;
                }
            }
        } else {
            Logger.w("No render thread", new Object[0]);
        }
    }

    private static class StartRecordingArg {
        @Nullable
        String fileName;
        boolean mic;
        @Nullable
        ContentRatioParams params;
        float speed;

        StartRecordingArg(@Nullable String string, boolean bl, @Nullable ContentRatioParams contentRatioParams, float f) {
            if (string != null) {
                StartRecordingArg startRecordingArg = this;
                startRecordingArg.fileName = string;
                startRecordingArg.mic = bl;
                startRecordingArg.params = contentRatioParams;
                startRecordingArg.speed = f;
                return;
            }
            throw new IllegalStateException("At least 1 param (fileName, videoWithWatermarkFileName) should be provided!");
        }
    }

    private static class ProcessImageArg {
        @NonNull
        FullImageData image;

        ProcessImageArg(@NonNull FullImageData fullImageData) {
            this.image = fullImageData;
        }
    }
}

