/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.renderer;

import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLES30;
import android.opengl.Matrix;
import android.os.Process;
import android.util.Log;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.renderer.VideoTextureProvider;
import com.banuba.sdk.Recycler;
import com.banuba.sdk.effect_player.CameraOrientation;
import com.banuba.sdk.effect_player.EffectManager;
import com.banuba.sdk.effect_player.EffectPlayer;
import com.banuba.sdk.encoding.sync.IEncoderSync;
import com.banuba.sdk.entity.ContentRatioParams;
import com.banuba.sdk.entity.WatermarkInfo;
import com.banuba.sdk.internal.BaseWorkThread;
import com.banuba.sdk.internal.camera.Camera2;
import com.banuba.sdk.internal.encoding.EmptyRecordingListener;
import com.banuba.sdk.internal.encoding.MediaMuxerWrapper;
import com.banuba.sdk.internal.encoding.MultipleMediaMuxerWrapper;
import com.banuba.sdk.internal.encoding.MultipleRecordingListener;
import com.banuba.sdk.internal.encoding.RecordingListener;
import com.banuba.sdk.internal.encoding.RecordingListenerHandler;
import com.banuba.sdk.internal.gl.EglCore;
import com.banuba.sdk.internal.gl.EglSurfaceBase;
import com.banuba.sdk.internal.gl.GLScalableRectTexture;
import com.banuba.sdk.internal.gl.GlUtils;
import com.banuba.sdk.internal.gl.OffscreenSurface;
import com.banuba.sdk.internal.gl.RenderBuffer;
import com.banuba.sdk.internal.gl.WindowSurface;
import com.banuba.sdk.internal.photo.PhotoHandler;
import com.banuba.sdk.internal.photo.PhotoThread;
import com.banuba.sdk.internal.renderer.RenderHandler;
import com.banuba.sdk.internal.renderer.RenderMsgSender;
import com.banuba.sdk.internal.utils.Logger;
import com.banuba.sdk.types.Data;
import com.banuba.sdk.types.FaceData;
import com.banuba.sdk.types.FrameData;
import com.banuba.sdk.types.FullImageData;
import com.banuba.sdk.types.PixelFormat;
import com.banuba.sdk.utils.ATrace;
import java.nio.Buffer;
import java.util.Map;
import java.util.Objects;

public class RenderThread
extends BaseWorkThread<RenderHandler> {
    private Surface mSurface;
    private final EffectPlayer mEffectPlayer;
    private final EffectManager mEffectManager;
    private final RecordingListener mRecordingListener;
    private EglCore mEglCore;
    private OffscreenSurface mOffscreenSurface;
    private WindowSurface mWindowSurface;
    private WatermarkInfo mWatermarkInfo;
    private GLScalableRectTexture mWaterMark;
    private final float[] mScreenMatrix;
    @NonNull
    private Size mDrawSize;
    private final MultipleRecordingListener multipleListener;
    private RecordingListenerHandler mRecordingListenerHandler;
    private WindowSurface mInputWindowSurface;
    private WindowSurface mTextureWidowSurface;
    private SurfaceTexture mSurfaceTexture;
    private MultipleMediaMuxerWrapper mMultipleWrappers;
    private boolean mRecordingInProgress;
    private boolean waitForRecording;
    private boolean mDrawToTexture;
    private int mOutTexture;
    private PhotoHandler mPhotoHandler;
    private RenderBuffer mPhotoBuffer;
    private boolean mShouldTakePhoto;
    private ContentRatioParams mContentRatioParams;
    private boolean mShouldDoFrame;
    private FullImageData editingImage;
    private FrameData editingImageFrameData;
    private FullImageData mImageData;
    private boolean mShouldProcessImage;
    private boolean mForwardFrames;
    private long mRecordBaseFrame;
    private long mRecordPauseTimeStamp;
    private long mRecordSkipTime;
    private double mRecordSpeedK;
    private Integer surfaceWidth;
    private Integer surfaceHeight;

    public RenderThread(EffectPlayer object, @NonNull Size object2, RecordingListener recordingListener) {
        RenderThreadRecordingListener renderThreadRecordingListener;
        MultipleRecordingListener multipleRecordingListener;
        RenderThread renderThread = renderThread5;
        RenderThread renderThread2 = renderThread5;
        Size size = object2;
        super("RenderThread");
        renderThread5.mSurface = null;
        renderThread5.mScreenMatrix = new float[16];
        object2 = multipleRecordingListener;
        RenderThread renderThread3 = renderThread5;
        RenderThread renderThread4 = renderThread5;
        Object object3 = object2;
        super();
        renderThread4.multipleListener = object3;
        renderThread4.mMultipleWrappers = new MultipleMediaMuxerWrapper();
        renderThread4.waitForRecording = false;
        renderThread4.mDrawToTexture = false;
        renderThread4.mShouldDoFrame = true;
        renderThread4.editingImage = null;
        renderThread4.editingImageFrameData = null;
        renderThread4.mImageData = null;
        renderThread4.mShouldProcessImage = false;
        renderThread4.mRecordSpeedK = 1.0;
        renderThread4.surfaceWidth = null;
        renderThread4.surfaceHeight = null;
        renderThread5.mEffectPlayer = object;
        RenderThread renderThread5 = object.effectManager();
        renderThread3.mEffectManager = renderThread5;
        object = renderThreadRecordingListener;
        renderThreadRecordingListener = new RenderThreadRecordingListener((EffectManager)renderThread5);
        multipleRecordingListener.addRecordingListener(recordingListener);
        multipleRecordingListener.addRecordingListener((RecordingListener)object);
        renderThread2.mDrawSize = size;
        renderThread.mRecordingListener = recordingListener;
    }

    private void prepareGl(Surface surface) {
        this.mWindowSurface = new WindowSurface(this.mEglCore, surface, false);
        this.mWindowSurface.makeCurrent();
        GLES20.glDisable((int)2884);
        GLES20.glDepthFunc((int)515);
        GlUtils.checkGlErrorNoException("prepareGl");
    }

    private void releaseGl() {
        Logger.d("releaseGL", new Object[0]);
        WindowSurface windowSurface = this.mWindowSurface;
        if (windowSurface != null) {
            windowSurface.release();
            this.mWindowSurface = null;
        }
        RenderThread renderThread = this;
        renderThread.releaseWatermark();
        renderThread.releaseRenderTexture();
        renderThread.mOffscreenSurface.makeCurrent();
    }

    private void releaseRenderTexture() {
        Object object = this.mTextureWidowSurface;
        if (object != null) {
            ((WindowSurface)object).release();
            this.mTextureWidowSurface = null;
        }
        if ((object = this.mSurfaceTexture) != null) {
            object.release();
            this.mSurfaceTexture = null;
        }
        int[] nArray = new int[1];
        object = nArray;
        nArray[0] = this.mOutTexture;
        GLES20.glDeleteTextures((int)1, (int[])object, (int)0);
    }

    private void forwardFrame() {
        RenderThread renderThread = this;
        Data data = renderThread.mEffectPlayer.readPixels().getData();
        RenderThread renderThread2 = this;
        int n = renderThread2.mDrawSize.getWidth();
        renderThread.mRecordingListenerHandler.sendOnFrame(data, n, renderThread2.mDrawSize.getHeight());
    }

    private void dumpFramesDelay(long l) {
        Object object = Camera2.sPushedFrames.get(l);
        long l2 = System.currentTimeMillis();
        long l3 = object == null ? 0L : (Long)object;
        Object[] objectArray = new Object[2];
        object = objectArray;
        object[0] = l;
        objectArray[1] = l2 -= l3;
        Logger.d("FramesDump. Frame %d: %d ms", (Object[])object);
        object = Camera2.sPushedFrames.entrySet().iterator();
        while (object.hasNext() && (Long)((Map.Entry)object.next()).getKey() < l) {
            object.remove();
        }
    }

    private void startEncoder(@Nullable String string, boolean bl, float f) {
        block11: {
            WindowSurface windowSurface;
            MediaMuxerWrapper mediaMuxerWrapper;
            String string2 = string;
            RenderThread renderThread = eglCore;
            Logger.d("Init Encoding started", new Object[0]);
            double d = f;
            renderThread.mRecordSpeedK = 1.0 / d;
            if (string2 == null) break block11;
            boolean bl2 = bl;
            RenderThread renderThread2 = eglCore;
            RenderThread renderThread3 = renderThread2;
            RenderThread renderThread4 = renderThread2;
            renderThread2.mRecordSkipTime = 0L;
            renderThread2.mRecordPauseTimeStamp = 0L;
            renderThread2.mRecordBaseFrame = System.nanoTime();
            RenderHandler renderHandler = (RenderHandler)renderThread4.getHandler();
            RecordingListenerHandler recordingListenerHandler = renderThread3.mRecordingListenerHandler;
            int n = bl2 ? 1 : 0;
            RenderThread renderThread5 = eglCore;
            RenderThread renderThread6 = eglCore;
            MediaMuxerWrapper mediaMuxerWrapper2 = mediaMuxerWrapper;
            RenderHandler renderHandler2 = renderHandler;
            RenderThread renderThread7 = eglCore;
            renderHandler = null;
            long l = renderThread7.mRecordBaseFrame;
            int n2 = renderThread7.mContentRatioParams.getWidth();
            int n3 = renderThread7.mContentRatioParams.getHeight();
            mediaMuxerWrapper2(renderHandler2, recordingListenerHandler, string, n, (IEncoderSync)((Object)renderHandler), l, f, n2, n3);
            mediaMuxerWrapper2.prepare();
            WindowSurface windowSurface2 = windowSurface;
            WindowSurface windowSurface3 = windowSurface;
            MediaMuxerWrapper mediaMuxerWrapper3 = mediaMuxerWrapper;
            EglCore eglCore = ((RenderThread)((Object)eglCore)).mEglCore;
            try {
                windowSurface2(eglCore, mediaMuxerWrapper3.getInputSurface(), true);
                renderThread6.mInputWindowSurface = windowSurface3;
                mediaMuxerWrapper.startRecording();
                renderThread5.mMultipleWrappers.addWrapper("default", mediaMuxerWrapper);
            }
            catch (Exception exception) {
                Log.e((String)"RenderThread", (String)"Failed to create video encoder", (Throwable)exception);
            }
        }
    }

    private void stopEncoder() {
        MediaMuxerWrapper mediaMuxerWrapper = ((RenderThread)((Object)mediaMuxerWrapper)).mMultipleWrappers.getWrapper("default");
        if (mediaMuxerWrapper != null) {
            mediaMuxerWrapper.stopRecording();
        }
    }

    private void drawToEncoder(long l) {
        if (this.mMultipleWrappers.hasWrappers()) {
            MediaMuxerWrapper mediaMuxerWrapper = this.mMultipleWrappers.getWrapper("default");
            RenderThread renderThread = this;
            int n = renderThread.mContentRatioParams.getWidth();
            int n2 = renderThread.mContentRatioParams.getHeight();
            WindowSurface windowSurface = renderThread.mInputWindowSurface;
            if (mediaMuxerWrapper != null && windowSurface != null) {
                mediaMuxerWrapper.frameAvailableSoon();
                if (this.mWatermarkInfo != null) {
                    RenderThread renderThread2 = this;
                    renderThread2.scaleWatermarkToSurviveDownsampling(n, n2);
                    renderThread2.drawWatermarkFrameOnSurface(windowSurface, n, n2, l);
                } else {
                    this.drawDefaultFrameOnSurface(windowSurface, n, n2, l);
                }
            }
            if (this.waitForRecording) {
                this.mRecordingListenerHandler.sendRecordingStatusChange(true);
                this.waitForRecording = false;
            }
        }
    }

    private void drawToTexture(long l) {
        WindowSurface windowSurface = this.mTextureWidowSurface;
        if (windowSurface != null) {
            RenderThread renderThread = this;
            int n = renderThread.mDrawSize.getWidth();
            this.drawDefaultFrameOnSurface(windowSurface, n, renderThread.mDrawSize.getHeight(), l);
        }
    }

    private void drawDefaultFrameOnSurface(WindowSurface object, int n, int n2, long l) {
        WindowSurface windowSurface = object;
        RenderThread renderThread = this;
        ((EglSurfaceBase)object).makeCurrent();
        GLES20.glViewport((int)0, (int)0, (int)n, (int)n2);
        renderThread.mEffectPlayer.captureBlit(n, n2);
        long l2 = renderThread.mRecordBaseFrame;
        windowSurface.setPresentationTime(l2 + (long)(this.mRecordSpeedK * (double)(l -= l2)) - this.mRecordSkipTime);
        windowSurface.swapBuffers();
        object = this.mSurfaceTexture;
        if (object != null) {
            RenderThread renderThread2 = this;
            object.updateTexImage();
            object = new float[16];
            renderThread2.mSurfaceTexture.getTransformMatrix((float[])object);
            l = this.mSurfaceTexture.getTimestamp();
            renderThread2.mRecordingListenerHandler.sendOnTextureFrame(this.mOutTexture, n, n2, l, (float[])object);
        }
    }

    private void drawWatermarkFrameOnSurface(WindowSurface windowSurface, int n, int n2, long l) {
        WindowSurface windowSurface2 = windowSurface;
        RenderThread renderThread = this;
        windowSurface.makeCurrent();
        GLES20.glViewport((int)0, (int)0, (int)n, (int)n2);
        renderThread.mEffectPlayer.captureBlit(n, n2);
        renderThread.drawWatermark();
        long l2 = renderThread.mRecordBaseFrame;
        long l3 = l2;
        l3 = l - l3;
        windowSurface2.setPresentationTime(l2 + (long)(this.mRecordSpeedK * (double)l3) - this.mRecordSkipTime);
        windowSurface2.swapBuffers();
    }

    private void drawToPhoto() {
        PhotoHandler photoHandler = this.mPhotoHandler;
        if (this.mPhotoBuffer != null && photoHandler != null) {
            RenderThread renderThread = this;
            renderThread.mShouldTakePhoto = false;
            int n = renderThread.mContentRatioParams.getWidth();
            int n2 = this.mContentRatioParams.getHeight();
            RenderBuffer renderBuffer = RenderBuffer.prepareFrameBuffer(n, n2, false);
            GLES20.glBindFramebuffer((int)36160, (int)renderBuffer.getFrameBufferId());
            GLES20.glViewport((int)0, (int)0, (int)n, (int)n2);
            this.mEffectPlayer.captureBlit(n, n2);
            renderThread.scaleWatermarkToSurviveDownsampling(n, n2);
            renderThread.drawWatermark();
            GLES20.glFinish();
            photoHandler.sendFrameCaptured(renderBuffer, renderThread.mContentRatioParams);
            this.mPhotoHandler = null;
            this.mPhotoBuffer = null;
            this.stopDoFrame();
        }
    }

    private void drawWatermark() {
        if (this.mWaterMark != null) {
            GLES30.glBindVertexArray((int)0);
            GlUtils.setupBlend();
            GLES20.glEnable((int)3042);
            this.mWaterMark.draw(this.mScreenMatrix);
            GLES20.glDisable((int)3042);
        }
    }

    private void drawToImage() {
        RenderThread renderThread = renderThread2;
        RenderThread renderThread2 = renderThread.processImage(renderThread.mImageData);
        renderThread.mRecordingListenerHandler.sendImageProcessed((Bitmap)renderThread2);
        renderThread.mShouldProcessImage = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Bitmap processImage(FullImageData fullImageData) {
        Bitmap bitmap;
        FullImageData fullImageData2 = fullImageData;
        RenderThread renderThread = renderThread.mEffectPlayer.processImage(Objects.requireNonNull(fullImageData), PixelFormat.RGBA);
        try {
            int n;
            int n2;
            fullImageData = fullImageData2.getOrientation();
            Size size = fullImageData2.getSize();
            if (fullImageData.getCameraOrientation() != CameraOrientation.DEG_90 && fullImageData.getCameraOrientation() != CameraOrientation.DEG_270) {
                Size size2 = size;
                n2 = size2.getWidth();
                n = size2.getHeight();
            } else {
                Size size3 = size;
                n2 = size3.getHeight();
                n = size3.getWidth();
            }
            int n3 = n;
            bitmap = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        catch (Throwable throwable) {
            if (renderThread == null) throw throwable;
            try {
                renderThread.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        bitmap.copyPixelsFromBuffer((Buffer)renderThread.getData());
        renderThread.close();
        return bitmap;
    }

    private void scaleWatermarkToSurviveDownsampling(int n, int n2) {
        if (this.mWaterMark != null) {
            RenderThread renderThread = this;
            double d = (double)n2 / (double)n / ((double)this.surfaceHeight.intValue() / (double)this.surfaceWidth.intValue());
            float f = (float)Math.ceil((double)renderThread.mWaterMark.getHeight() / d) - (float)this.mWaterMark.getHeight();
            renderThread.mWaterMark.setOffset(0.0f, f / 2.0f);
            GLScalableRectTexture gLScalableRectTexture = renderThread.mWaterMark;
            gLScalableRectTexture.setScale(gLScalableRectTexture.getWidth(), (float)this.mWaterMark.getHeight() + f);
        }
    }

    @Override
    @NonNull
    protected RenderHandler constructHandler() {
        return new RenderHandler(this);
    }

    @Override
    protected void preRunInit() {
        EglCore eglCore;
        this.mRecordingListenerHandler = new RecordingListenerHandler(this.mRecordingListener);
        Process.setThreadPriority((int)-8);
        EglCore eglCore2 = eglCore;
        this.mEglCore = new EglCore(null, 3);
        this.mOffscreenSurface = new OffscreenSurface(eglCore2, 1, 1);
        this.mOffscreenSurface.makeCurrent();
        this.mEffectPlayer.surfaceCreated(1, 1);
    }

    @Override
    protected void postRunClear() {
        RenderThread renderThread = this;
        renderThread.surfaceDestroyed();
        renderThread.mEffectPlayer.surfaceDestroyed();
        renderThread.mEglCore.release();
    }

    @Override
    public void shutdown() {
        RenderThread renderThread = this;
        Logger.d("RenderThread shutdown", new Object[0]);
        ((RenderHandler)renderThread.getHandler()).removeCallbacksAndMessages(null);
        Object object = renderThread.mPhotoHandler;
        if (object != null) {
            ((PhotoHandler)((Object)object)).sendShutDown();
        }
        this.mPhotoHandler = null;
        object = this.mPhotoBuffer;
        if (object != null) {
            ((RenderBuffer)object).clear();
        }
        RenderThread renderThread2 = this;
        renderThread2.mPhotoBuffer = null;
        renderThread2.stopDoFrame();
        renderThread2.handleStopEditingImage();
        super.shutdown();
    }

    void surfaceCreated(Surface surface) {
        Log.i((String)"RenderThread", (String)"surfaceCreated");
        this.mSurface = surface;
        this.prepareGl(surface);
    }

    void surfaceChanged(int n, int n2) {
        RenderThread renderThread = this;
        RenderThread renderThread2 = this;
        Log.i((String)"RenderThread", (String)"surfaceChanged");
        renderThread2.stopDoFrame();
        float f = n;
        float f2 = n2;
        Matrix.orthoM((float[])renderThread2.mScreenMatrix, (int)0, (float)0.0f, (float)f, (float)0.0f, (float)f2, (float)-100.0f, (float)100.0f);
        this.surfaceWidth = n;
        renderThread.surfaceHeight = n2;
        renderThread.initWatermarkIfNeeded(renderThread.mWatermarkInfo);
        Integer n3 = renderThread.surfaceWidth;
        renderThread.updateWatermark(n3, renderThread.surfaceHeight);
        n3 = renderThread.editingImage;
        if (n3 != null) {
            this.mEffectManager.setEffectSize(n3.getSize().getWidth(), this.editingImage.getSize().getHeight());
        }
        this.resumeDoFrame();
    }

    void surfaceDestroyed() {
        RenderThread renderThread = this;
        renderThread.stopDoFrame();
        try {
            renderThread.releaseGl();
        }
        catch (Exception exception) {
            Logger.wtf(exception);
        }
        RenderThread renderThread2 = this;
        Log.i((String)"RenderThread", (String)"surfaceDestroyed");
        renderThread2.surfaceWidth = null;
        renderThread2.surfaceHeight = null;
        renderThread2.mSurface = null;
    }

    /*
     * Unable to fully structure code
     */
    void doFrame(long var1_2) {
        block28: {
            block26: {
                block25: {
                    block24: {
                        var3_3 = v0;
                        v0 = new ATrace("RenderThreadIteration");
                        if (this.mShouldDoFrame) break block24;
                        var3_3.close();
                        return;
                    }
                    var4_4 = this.mWindowSurface;
                    if (var4_4 != null) break block25;
                    var3_3.close();
                    return;
                }
                var4_4.makeCurrent();
                var4_4 = this.editingImageFrameData;
                if (var4_4 == null) break block26;
                v1 = this.mEffectPlayer.drawWithExternalFrameData((FrameData)var4_4);
lbl20:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
            }
            v1 = this.mEffectPlayer.draw();
            ** continue;
            var4_5 = v1;
            if (var4_5 != -1L) {
                block27: {
                    if (VideoTextureProvider.checkValidAll()) break block27;
                    if (!this.mShouldProcessImage) break block27;
                    var3_3.close();
                    return;
                }
                v2 = this;
                v3 = v2;
                v2.mWindowSurface.swapBuffers();
                if (v3.mRecordingInProgress) {
                    this.drawToEncoder(var1_2);
                }
                if (this.mDrawToTexture) {
                    this.drawToTexture(var1_2);
                }
                if (this.mShouldTakePhoto) {
                    this.drawToPhoto();
                }
                if (this.mShouldProcessImage) {
                    this.drawToImage();
                }
                if (!this.mForwardFrames) break block28;
                this.forwardFrame();
            }
        }
        return;
        finally {
            try {
                var3_3.close();
            }
            catch (Throwable v4) {
                var0_1.addSuppressed(v4);
            }
        }
    }

    void startRecording(@Nullable String string, boolean bl, @Nullable ContentRatioParams contentRatioParams, float f) {
        this.mContentRatioParams = contentRatioParams == null ? new ContentRatioParams(this.mDrawSize.getWidth(), this.mDrawSize.getHeight(), false) : contentRatioParams;
        if (!this.mRecordingInProgress) {
            this.mRecordingInProgress = true;
            this.waitForRecording = true;
            this.startEncoder(string, bl, f);
        }
    }

    void stopRecording() {
        RenderThread renderThread = this;
        renderThread.mRecordingListenerHandler.sendRecordingStatusChange(false);
        renderThread.waitForRecording = false;
        renderThread.stopEncoder();
        renderThread.mEffectPlayer.onVideoRecordEnd();
        renderThread.mRecordingInProgress = false;
    }

    void setPauseRecording(boolean bl) {
        MediaMuxerWrapper mediaMuxerWrapper = this.mMultipleWrappers.getWrapper("default");
        this.mRecordingInProgress = bl ^ true;
        if (bl) {
            this.mRecordPauseTimeStamp = System.nanoTime();
        } else {
            this.mRecordSkipTime += System.nanoTime() - this.mRecordPauseTimeStamp;
        }
        if (mediaMuxerWrapper != null) {
            mediaMuxerWrapper.setPause(bl);
        }
    }

    void onRecordingCompleted() {
        WindowSurface windowSurface = this.mInputWindowSurface;
        if (windowSurface != null) {
            windowSurface.release();
            this.mInputWindowSurface = null;
        }
        this.mMultipleWrappers.removeAllWrappers();
    }

    void takePhoto(@Nullable ContentRatioParams object) {
        objectArray2.mContentRatioParams = object == null ? new ContentRatioParams(objectArray2.mDrawSize.getWidth(), objectArray2.mDrawSize.getHeight(), false) : object;
        objectArray2.mShouldTakePhoto = true;
        if (objectArray2.mEffectManager.current() == null) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = "There is no active (empty or not empty) effect.";
            Logger.e("RenderThread", objectArray2);
            return;
        }
        if (objectArray2.mPhotoHandler == null) {
            object = objectArray2.mEglCore;
            RenderMsgSender renderMsgSender = (RenderMsgSender)objectArray2.getHandler();
            RecordingListenerHandler recordingListenerHandler = objectArray2.mRecordingListenerHandler;
            objectArray2.mPhotoHandler = (PhotoHandler)((Object)new PhotoThread((EglCore)object, renderMsgSender, recordingListenerHandler).startAndGetHandler());
        }
        objectArray2.mPhotoBuffer = RenderBuffer.prepareFrameBuffer(objectArray2.mContentRatioParams.getWidth(), objectArray2.mContentRatioParams.getHeight(), false);
    }

    void freeBuffer(@NonNull RenderBuffer renderBuffer) {
        renderBuffer.clear();
    }

    void stopDoFrame() {
        this.mShouldDoFrame = false;
    }

    void resumeDoFrame() {
        this.mShouldDoFrame = true;
    }

    void handleWatermarkInfo(WatermarkInfo watermarkInfo) {
        RenderThread renderThread = n;
        renderThread.mWatermarkInfo = watermarkInfo;
        renderThread.releaseWatermark();
        renderThread.initWatermarkIfNeeded(watermarkInfo);
        Integer n = renderThread.surfaceWidth;
        renderThread.updateWatermark(n, renderThread.surfaceHeight);
    }

    public void handleProcessPhoto(FullImageData fullImageData) {
        RenderThread renderThread = renderThread2;
        RenderThread renderThread2 = renderThread.processImage(fullImageData);
        renderThread.mRecordingListenerHandler.sendPhotoProcessed((Bitmap)renderThread2);
    }

    protected void initWatermarkIfNeeded(WatermarkInfo watermarkInfo) {
        if (((RenderThread)((Object)gLScalableRectTexture2)).mWaterMark == null && watermarkInfo != null) {
            GLScalableRectTexture gLScalableRectTexture;
            RenderThread renderThread = gLScalableRectTexture2;
            GLScalableRectTexture gLScalableRectTexture2 = gLScalableRectTexture;
            gLScalableRectTexture = new GLScalableRectTexture(watermarkInfo);
            renderThread.mWaterMark = gLScalableRectTexture2;
        }
    }

    protected void updateWatermark(Integer n, Integer n2) {
        GLScalableRectTexture gLScalableRectTexture = this.mWaterMark;
        if (gLScalableRectTexture != null && n != null && n2 != null) {
            RenderThread renderThread = this;
            int n3 = n;
            gLScalableRectTexture.setScreenSize(n3, n2);
            GLScalableRectTexture gLScalableRectTexture2 = renderThread.mWaterMark;
            gLScalableRectTexture2.setScale(gLScalableRectTexture2.getWidth(), this.mWaterMark.getHeight());
            renderThread.mWaterMark.setOffset(0.0f, 0.0f);
            int n4 = n;
            renderThread.mWaterMark.updatePosition(n4, n2);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void releaseWatermark() {
        var1_1 = this.mWaterMark;
        if (var1_1 == null) return;
        v0 = this;
        var1_1.close();
        v0.mWaterMark = null;
        return;
        {
            catch (Exception var1_2) {}
            {
                v0 = this;
                Logger.e("RenderThread", new Object[]{var1_2});
            }
        }
        ** finally { 
lbl12:
        // 1 sources

        this.mWaterMark = null;
        throw v1;
    }

    public void handleProcessImage(FullImageData fullImageData) {
        if (this.mShouldDoFrame) {
            this.mImageData = fullImageData;
            this.mShouldProcessImage = true;
            this.doFrame(System.nanoTime());
            return;
        }
        throw new AssertionError((Object)"RenderThread: frame processing should be enabled");
    }

    public void handleStartEditingImage(FullImageData fullImageData) {
        boolean bl;
        block7: {
            objectArray2.handleStopEditingImage();
            objectArray2.stopDoFrame();
            Size size = fullImageData.getSize();
            long l = size.getHeight();
            CameraOrientation cameraOrientation = fullImageData.getOrientation().getCameraOrientation();
            objectArray2.mEffectPlayer.startVideoProcessing((long)size.getWidth(), l, cameraOrientation, false, true);
            objectArray2.editingImage = fullImageData;
            objectArray2.editingImageFrameData = objectArray2.mEffectPlayer.processVideoFrame(fullImageData, null);
            objectArray2.mEffectPlayer.stopVideoProcessing(false);
            objectArray2.resumeDoFrame();
            bl = false;
            Object object = objectArray2.editingImageFrameData;
            if (object == null) break block7;
            if (object.getFrxRecognitionResult() == null) break block7;
            object = objectArray2.editingImageFrameData.getFrxRecognitionResult().getFaces();
            if (object.isEmpty()) break block7;
            if (((FaceData)object.get(0)).getLatents().isEmpty()) break block7;
            bl = true;
        }
        try {
            objectArray2.mRecordingListenerHandler.sendEditingModeFaceFound(bl);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = "FRX features disabled";
            Logger.e("RenderThread", objectArray2);
        }
    }

    public void setDrawSize(int n, int n2) {
        Size size;
        RenderThread renderThread = renderThread2;
        RenderThread renderThread2 = size;
        size = new Size(n, n2);
        renderThread.mDrawSize = renderThread2;
    }

    void handleStopEditingImage() {
        this.editingImageFrameData = (FrameData)Recycler.recycle((Object)this.editingImageFrameData);
        this.editingImage = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void handleTakeEditedImage() {
        RenderThread renderThread;
        PixelFormat pixelFormat;
        RenderThread renderThread2;
        if (renderThread5.editingImage == null) return;
        if (renderThread5.editingImageFrameData == null) {
            return;
        }
        RenderThread renderThread3 = renderThread5;
        renderThread3.stopDoFrame();
        Size size = renderThread3.editingImage.getSize();
        FullImageData.Orientation orientation = renderThread3.editingImage.getOrientation();
        RenderThread renderThread4 = renderThread5;
        Size size2 = size;
        long l = size2.getWidth();
        long l2 = size2.getHeight();
        CameraOrientation cameraOrientation = orientation.getCameraOrientation();
        renderThread4.mEffectPlayer.startVideoProcessing(l, l2, cameraOrientation, false, true);
        PixelFormat pixelFormat2 = PixelFormat.RGBA;
        pixelFormat2 = renderThread4.mEffectPlayer.drawVideoFrame(renderThread5.editingImageFrameData, 0L, pixelFormat2);
        try {
            int n;
            int n2;
            renderThread4.mEffectPlayer.stopVideoProcessing(false);
            if (orientation.getCameraOrientation() != CameraOrientation.DEG_90 && orientation.getCameraOrientation() != CameraOrientation.DEG_270) {
                Size size3 = size;
                n2 = size3.getWidth();
                n = size3.getHeight();
            } else {
                Size size4 = size;
                n2 = size4.getHeight();
                n = size4.getWidth();
            }
            int n3 = n;
            renderThread2 = renderThread5;
            pixelFormat = pixelFormat2;
            renderThread = renderThread5;
            RenderThread renderThread5 = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        catch (Throwable throwable) {
            if (pixelFormat2 == null) throw throwable;
            try {
                pixelFormat2.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        renderThread5.copyPixelsFromBuffer(pixelFormat2.getData());
        renderThread.mRecordingListenerHandler.sendEditedImageReady((Bitmap)renderThread5);
        pixelFormat.close();
        renderThread2.resumeDoFrame();
    }

    void handleStartForwardingFrames() {
        this.mForwardFrames = true;
    }

    void handleStopForwardingFrames() {
        this.mForwardFrames = false;
    }

    void handleStartForwardingTextures() {
        SurfaceTexture surfaceTexture;
        SurfaceTexture surfaceTexture2;
        RenderThread renderThread = eglCore;
        renderThread.mOutTexture = GlUtils.createExternalTextureObject();
        SurfaceTexture surfaceTexture3 = surfaceTexture2 = surfaceTexture;
        surfaceTexture3(((RenderThread)((Object)eglCore)).mOutTexture);
        ((RenderThread)((Object)eglCore)).mSurfaceTexture = surfaceTexture3;
        surfaceTexture.setDefaultBufferSize(((RenderThread)((Object)eglCore)).mDrawSize.getWidth(), ((RenderThread)((Object)eglCore)).mDrawSize.getHeight());
        RenderThread renderThread2 = eglCore;
        EglCore eglCore = renderThread2.mEglCore;
        renderThread.mTextureWidowSurface = new WindowSurface(eglCore, renderThread2.mSurfaceTexture);
        renderThread.mDrawToTexture = true;
    }

    void handleStopForwardingTextures() {
        this.mDrawToTexture = false;
        this.releaseRenderTexture();
    }

    void handleEffectPlayerPlay() {
        this.mEffectPlayer.playbackPlay();
    }

    void handleEffectPlayerPause() {
        this.mEffectPlayer.playbackPause();
    }

    void handleRunnable(Runnable runnable) {
        runnable.run();
    }

    void handleClearSurface() {
        FullImageData.Orientation orientation;
        RenderThread renderThread = renderThread2;
        RenderThread renderThread2 = Bitmap.createBitmap((int)renderThread.mDrawSize.getWidth(), (int)renderThread2.mDrawSize.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        FullImageData.Orientation orientation2 = orientation;
        orientation = new FullImageData.Orientation(CameraOrientation.DEG_0);
        renderThread.mEffectPlayer.pushFrame(new FullImageData((Bitmap)renderThread2, orientation2));
    }

    private static class RenderThreadRecordingListener
    extends EmptyRecordingListener {
        private EffectManager mEffectManager;

        RenderThreadRecordingListener(EffectManager effectManager) {
            this.mEffectManager = effectManager;
        }

        @Override
        public void onPhotoReady(@NonNull Bitmap bitmap) {
            if (objectArray2.mEffectManager.current() == null) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = "There is no active (empty or not empty) effect.";
                Logger.e("RenderThread", objectArray2);
                return;
            }
        }
    }
}

