/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.utils;

import android.graphics.Bitmap;
import com.banuba.sdk.frame.FramePixelBuffer;
import com.banuba.sdk.frame.FramePixelBufferFormat;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public final class BitmapUtils {
    private BitmapUtils() {
    }

    public static Bitmap createBitmap(FramePixelBuffer framePixelBuffer) {
        if (framePixelBuffer.getFormat() == FramePixelBufferFormat.BPC8_RGBA) {
            FramePixelBuffer framePixelBuffer2 = framePixelBuffer;
            Bitmap bitmap = Bitmap.createBitmap((int)framePixelBuffer2.getWidth(), (int)framePixelBuffer.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            if (framePixelBuffer2.getBytesPerRow() == framePixelBuffer.getWidth() * framePixelBuffer.getFormat().getPixelComponents()) {
                bitmap.copyPixelsFromBuffer((Buffer)framePixelBuffer.getBuffer());
            } else {
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(framePixelBuffer.getBuffer().capacity());
                for (int i = 0; i < framePixelBuffer.getHeight(); ++i) {
                    FramePixelBuffer framePixelBuffer3 = framePixelBuffer;
                    int n = framePixelBuffer3.getBuffer().arrayOffset() + i * framePixelBuffer.getBytesPerRow();
                    byteBuffer.put(framePixelBuffer.getBuffer().array(), n, framePixelBuffer3.getWidth() * framePixelBuffer.getBytesPerPixel());
                }
                byteBuffer.rewind();
                bitmap.copyPixelsFromBuffer((Buffer)byteBuffer);
            }
            return bitmap;
        }
        throw new RuntimeException("Only BPC8_RGBA format supported.");
    }
}

