/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.utils;

import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.ImageReader;
import android.os.Build;
import android.util.Pair;
import android.util.Size;
import android.util.SizeF;
import androidx.annotation.NonNull;
import com.banuba.sdk.effect_player.CameraOrientation;
import com.banuba.sdk.internal.Constants;
import com.banuba.sdk.internal.camera.PreviewSizeComparator;
import com.banuba.sdk.internal.utils.DisplayUtils;
import com.banuba.sdk.player.Orientation;
import com.banuba.sdk.types.FullImageData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;

public final class CameraUtils {
    private static final int DEFAULT_CAMERA_ORIENTATION = 270;
    private static final int MAX_PREVIEW_WIDTH = 1920;
    private static final int MAX_PREVIEW_HEIGHT = 1080;
    private static final int MAX_PREVIEW_WIDTH_LOW = 640;
    private static final int MAX_PREVIEW_HEIGHT_LOW = 480;
    private static final double DEFAULT_CAMERA_FOV = 55.0;

    private CameraUtils() {
    }

    public static int getSensorOrientation(@NonNull CameraCharacteristics object) {
        return (object = (Integer)object.get(CameraCharacteristics.SENSOR_ORIENTATION)) != null ? (Integer)object : 270;
    }

    public static int getLensFacing(@NonNull CameraCharacteristics object) {
        return (object = (Integer)object.get(CameraCharacteristics.LENS_FACING)) != null ? (Integer)object : 0;
    }

    public static double getFov(@NonNull CameraCharacteristics object) {
        CameraCharacteristics cameraCharacteristics = object;
        object = (float[])cameraCharacteristics.get(CameraCharacteristics.LENS_INFO_AVAILABLE_FOCAL_LENGTHS);
        SizeF sizeF = (SizeF)cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_PHYSICAL_SIZE);
        if (sizeF != null && object != null && ((CameraCharacteristics)object).length > 0) {
            return Math.toDegrees(Math.atan(sizeF.getWidth() * 0.5f / object[0]) * 2.0);
        }
        return 55.0;
    }

    public static Size getPreviewSize(@NonNull CameraCharacteristics pair, @NonNull Size size) {
        if ((pair = (StreamConfigurationMap)pair.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP)) != null) {
            ArrayList<Size> arrayList;
            Pair<Integer, Integer> pair2 = pair;
            pair = DisplayUtils.getAspectRatio(size.getWidth(), size.getHeight());
            ArrayList<Size> arrayList2 = arrayList;
            arrayList = new ArrayList<Size>(10);
            for (Size size2 : pair2.getOutputSizes(ImageReader.class)) {
                Pair<Integer, Integer> pair3 = DisplayUtils.getAspectRatio(size2.getWidth(), size2.getHeight());
                if (!((Integer)pair3.first).equals(pair.first) || !((Integer)pair3.second).equals(pair.second) || size2.getWidth() > size.getWidth() || size2.getHeight() > size.getHeight()) continue;
                arrayList2.add(size2);
            }
            return arrayList2.isEmpty() ? Constants.FALLBACK_PREVIEW_SIZE : Collections.max(arrayList2, new PreviewSizeComparator());
        }
        return Constants.FALLBACK_PREVIEW_SIZE;
    }

    public static Size getHighResPhotoSize(@NonNull CameraCharacteristics object) {
        if ((object = (StreamConfigurationMap)object.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP)) != null) {
            ArrayList arrayList;
            CameraCharacteristics cameraCharacteristics = object;
            object = arrayList;
            arrayList = new ArrayList();
            for (Size size : cameraCharacteristics.getOutputSizes(35)) {
                Pair<Integer, Integer> pair = DisplayUtils.getAspectRatio(size.getWidth(), size.getHeight());
                if ((Integer)pair.first != 16 || (Integer)pair.second != 9) continue;
                object.add(size);
            }
            return object.isEmpty() ? Constants.FALLBACK_PREVIEW_SIZE : Collections.max(object, new PreviewSizeComparator());
        }
        return Constants.FALLBACK_PREVIEW_SIZE;
    }

    public static String getCameraInfo(CameraCharacteristics object) {
        StringBuilder stringBuilder;
        CameraCharacteristics cameraCharacteristics = object;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        SizeF sizeF = (SizeF)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        Integer n = (Integer)cameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        stringBuilder2.append(Build.MANUFACTURER);
        stringBuilder2.append(" ");
        stringBuilder2.append(Build.MODEL);
        stringBuilder2.append("\nCamera 2 API\n");
        Integer n2 = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
        if (n2 != null) {
            stringBuilder2.append("Facing = ");
            if (n2 == 1) {
                stringBuilder2.append("BACK");
            } else if (n2 == 0) {
                stringBuilder2.append("FRONT");
            } else if (n2 == 2) {
                stringBuilder2.append("EXTERNAL");
            } else {
                stringBuilder2.append("UNKNOWN");
            }
            stringBuilder2.append("\n");
        } else {
            stringBuilder2.append("Facing = NO DATA\n");
        }
        stringBuilder2.append("SensorOrientation = ").append(n).append("\n");
        n = (Integer)object.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
        if (n != null) {
            if (n == 2) {
                stringBuilder2.append("Level: LEGACY");
            } else if (n == 0) {
                stringBuilder2.append("Level: HARDWARE_LIMITED");
            } else if (n == 1) {
                stringBuilder2.append("Level: HARDWARE_FULL");
            }
        } else {
            stringBuilder2.append("Camera2 support level: UNKNOWN");
        }
        stringBuilder2.append("\n\n");
        if (sizeF != null && (sizeF = sizeF.getOutputSizes(SurfaceTexture.class)) != null) {
            for (SizeF sizeF2 : sizeF) {
                Pair<Integer, Integer> pair = DisplayUtils.getAspectRatio(sizeF2.getWidth(), sizeF2.getHeight());
                stringBuilder2.append("Size: ").append(sizeF2.getWidth()).append("x").append(sizeF2.getHeight()).append("  ");
                stringBuilder2.append(pair.first).append(":").append(pair.second).append("\n");
            }
        }
        CameraCharacteristics cameraCharacteristics2 = object;
        object = (float[])cameraCharacteristics2.get(CameraCharacteristics.LENS_INFO_AVAILABLE_FOCAL_LENGTHS);
        sizeF = (SizeF)cameraCharacteristics2.get(CameraCharacteristics.SENSOR_INFO_PHYSICAL_SIZE);
        if (sizeF != null && object != null) {
            SizeF sizeF3 = sizeF;
            stringBuilder2.append("\nSensor Size: ");
            Locale locale = Locale.ENGLISH;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = Float.valueOf(sizeF.getWidth());
            stringBuilder2.append(String.format(locale, "%.2f", objectArray2));
            stringBuilder2.append(" x ");
            Object[] objectArray3 = new Object[1];
            objectArray2 = objectArray3;
            objectArray3[0] = Float.valueOf(sizeF.getHeight());
            stringBuilder2.append(String.format(locale, "%.2f", objectArray2));
            stringBuilder2.append(" mm\n");
            double d = (double)sizeF3.getWidth() * 0.5;
            double d2 = (double)sizeF3.getHeight() * 0.5;
            int n3 = ((CameraCharacteristics)object).length;
            for (int i = 0; i < n3; ++i) {
                double d3 = (double)object[i];
                double d4 = Math.toDegrees(Math.atan(d / d3) * 2.0);
                d3 = Math.toDegrees(Math.atan(d2 / d3) * 2.0);
                stringBuilder2.append("FOV: H = ");
                Locale locale2 = Locale.ENGLISH;
                Object[] objectArray4 = new Object[1];
                Object[] objectArray5 = objectArray4;
                objectArray4[0] = d4;
                stringBuilder2.append(String.format(locale2, "%.1f", objectArray5));
                stringBuilder2.append(" V = ");
                Object[] objectArray6 = new Object[1];
                Object[] objectArray7 = objectArray6;
                objectArray6[0] = d3;
                stringBuilder2.append(String.format(locale2, "%.1f", objectArray7));
            }
        }
        return stringBuilder2.toString();
    }

    public static Rect getCroppedRect(Rect rect, float f) {
        Rect rect2 = rect;
        f = 1.0f / f;
        int n = (rect2.width() - Math.round((float)rect.width() * f)) / 2;
        int n2 = (rect2.height() - Math.round((float)rect.height() * f)) / 2;
        int n3 = n;
        Rect rect3 = rect;
        int n4 = rect3.width() - n;
        n = rect3.height() - n2;
        return new Rect(n3, n2, n4, n);
    }

    public static CameraOrientation degreesToCameraOrientation(int n) {
        if (n == 0) {
            return CameraOrientation.DEG_0;
        }
        if (n == 90) {
            return CameraOrientation.DEG_90;
        }
        if (n == 180) {
            return CameraOrientation.DEG_180;
        }
        if (n == 270) {
            return CameraOrientation.DEG_270;
        }
        throw new RuntimeException("Unknown degrees value: " + n);
    }

    public static FullImageData.Orientation makeFullImageDataOrientation(Orientation orientation, boolean bl) {
        orientation = CameraUtils.degreesToCameraOrientation(orientation.degrees());
        return new FullImageData.Orientation((CameraOrientation)orientation, bl, 0);
    }
}

