/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.utils;

import android.content.Context;
import android.util.Pair;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import com.banuba.sdk.internal.utils.Logger;
import java.util.concurrent.TimeUnit;

public final class DisplayUtils {
    private DisplayUtils() {
    }

    public static int getDisplayRefreshRate(Context context) {
        return Math.round(((WindowManager)context.getSystemService("window")).getDefaultDisplay().getRefreshRate());
    }

    public static long getDisplayRefreshNS(Context objectArray) {
        double d = ((WindowManager)objectArray.getSystemService("window")).getDefaultDisplay().getRefreshRate();
        long l = Math.round((double)TimeUnit.SECONDS.toNanos(1L) / d);
        Object[] objectArray2 = new Object[1];
        objectArray = objectArray2;
        objectArray2[0] = l;
        Logger.d("Refresh ns: %d", objectArray);
        return l;
    }

    @NonNull
    public static Pair<Integer, Integer> getAspectRatio(int n, int n2) {
        int n3 = n2;
        int n4 = n;
        n = DisplayUtils.greatestCommonFactor(n4, n2);
        n2 = n4 / n;
        n = n3 / n;
        Integer n5 = n2;
        return new Pair((Object)n5, (Object)n);
    }

    private static int greatestCommonFactor(int n, int n2) {
        if (n2 != 0) {
            n = DisplayUtils.greatestCommonFactor(n2, n % n2);
        }
        return n;
    }
}

