/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.utils;

import android.content.Context;
import android.util.Log;
import android.view.OrientationEventListener;
import androidx.annotation.NonNull;
import com.banuba.sdk.effect_player.CameraOrientation;
import com.banuba.sdk.types.FullImageData;

public final class OrientationHelper {
    private static final String TAG = "OrientationHelper";
    private static final int ORIENTATION_PORTRAIT_NORMAL = 0;
    private static final int ORIENTATION_LANDSCAPE_NORMAL = 90;
    private static final int ORIENTATION_PORTRAIT_INVERTED = 180;
    private static final int ORIENTATION_LANDSCAPE_INVERTED = 270;
    private static OrientationHelper instance;
    private static final OrientationCreator ORIENTATION_CREATOR;
    @NonNull
    private final OrientationEventListener mOrientationEventListener;
    private int mCurrentOrientationAngle = 0;
    private boolean isOrientationListenerStarted = false;

    private OrientationHelper(@NonNull Context context) {
        OrientationEventListener orientationEventListener;
        OrientationEventListener orientationEventListener2 = orientationEventListener;
        orientationEventListener = new OrientationEventListener(context){

            public void onOrientationChanged(int n) {
                if (n >= 35 && 325 > n) {
                    if (235 <= n && n < 305) {
                        OrientationHelper.access$002(OrientationHelper.this, 90);
                    } else if (145 <= n && n < 215) {
                        OrientationHelper.access$002(OrientationHelper.this, 180);
                    } else if (55 <= n && n < 125) {
                        OrientationHelper.access$002(OrientationHelper.this, 270);
                    }
                } else {
                    OrientationHelper.access$002(OrientationHelper.this, 0);
                }
            }
        };
        this.mOrientationEventListener = orientationEventListener2;
        Log.i((String)TAG, (String)"OrientationHelper was instantiated.");
    }

    public static OrientationHelper getInstance(@NonNull Context context) {
        if (instance == null) {
            instance = new OrientationHelper(context);
        }
        return instance;
    }

    public static int getFaceOrientationByCamera(int n, int n2, int n3, boolean bl, boolean bl2) {
        int n4;
        if (bl) {
            n4 = n3 - n + n2;
        } else {
            int n5 = n;
            n = 360 - n2;
            n4 = n3 - n5 + n;
        }
        n = n4 % 360;
        if (!bl2 && n % 180 != 0) {
            return n * -1;
        }
        return n;
    }

    public static FullImageData.Orientation getOrientationByCamera(int n, int n2, int n3, boolean bl, boolean bl2) {
        n2 = OrientationHelper.getFaceOrientationByCamera(n, n2, n3, bl, bl2);
        return ORIENTATION_CREATOR.getOrientation(n, n2, bl2);
    }

    /*
     * Unable to fully structure code
     */
    public static int getFaceOrientation(int var0, int var1_1, boolean var2_2) {
        block5: {
            block8: {
                block7: {
                    block4: {
                        block6: {
                            var3_3 = 0;
                            if (var0 == 90 || var0 == 270) break block4;
                            if (var0 != 0 && var0 != 180) break block5;
                            if (var1_1 == 0 || var1_1 == 180) break block6;
                            if ((var1_1 != 270 || var0 != 0) && (var1_1 != 90 || var0 != 180)) break block5;
                            break block7;
                        }
                        var2_2 = var2_2 != 0 ? -1 : 1;
                        var0 = var0 == 0 ? 1 : -1;
                        var0 = var2_2 * var0;
                        if (var1_1 != 0) ** GOTO lbl-1000
                        ** GOTO lbl-1000
                    }
                    if (var1_1 == 90 || var1_1 == 270) break block8;
                    if ((var1_1 != 180 || var0 != 270) && (var1_1 != 0 || var0 != 90)) break block5;
                }
                var3_3 = 180;
                break block5;
            }
            var2_2 = var2_2 != 0 ? 1 : -1;
            var0 = var0 == 270 ? 1 : -1;
            var0 = var2_2 * var0;
            if (var1_1 == 90) lbl-1000:
            // 2 sources

            {
                var1_1 = 90;
            } else lbl-1000:
            // 2 sources

            {
                var1_1 = -90;
            }
            var3_3 = var0 * var1_1;
        }
        return var3_3;
    }

    public static FullImageData.Orientation getOrientation(int n, int n2, boolean bl) {
        n2 = OrientationHelper.getFaceOrientation(n, n2, bl);
        return ORIENTATION_CREATOR.getOrientation(n, n2, bl);
    }

    static /* synthetic */ int access$002(OrientationHelper orientationHelper, int n) {
        orientationHelper.mCurrentOrientationAngle = n;
        return n;
    }

    static {
        ORIENTATION_CREATOR = (n, n2, bl) -> {
            CameraOrientation cameraOrientation = CameraOrientation.DEG_0;
            if (n != 0) {
                if (n != 90) {
                    if (n != 180) {
                        if (n == 270) {
                            cameraOrientation = CameraOrientation.DEG_270;
                        }
                    } else {
                        cameraOrientation = CameraOrientation.DEG_180;
                    }
                } else {
                    cameraOrientation = CameraOrientation.DEG_90;
                }
            }
            return new FullImageData.Orientation(cameraOrientation, bl, n2);
        };
    }

    public void startDeviceOrientationUpdates() {
        this.mOrientationEventListener.enable();
        this.isOrientationListenerStarted = true;
        Log.i((String)TAG, (String)"OrientationEventListener was enabled.");
    }

    public void stopDeviceOrientationUpdates() {
        this.mOrientationEventListener.disable();
        this.isOrientationListenerStarted = false;
        Log.i((String)TAG, (String)"OrientationEventListener was disabled.");
    }

    public int getDeviceOrientationAngle() {
        if (!this.isOrientationListenerStarted) {
            Log.w((String)TAG, (String)"OrientationEventListener was not enabled.");
        }
        return this.mCurrentOrientationAngle;
    }

    protected void finalize() {
        OrientationHelper orientationHelper = this;
        super.finalize();
        orientationHelper.mOrientationEventListener.disable();
        Log.i((String)TAG, (String)"OrientationHelper was destroyed.");
    }

    @FunctionalInterface
    private static interface OrientationCreator {
        public FullImageData.Orientation getOrientation(int var1, int var2, boolean var3);
    }
}

