/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.utils;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;

@TargetApi(value=23)
public final class PermissionUtils {
    private PermissionUtils() {
    }

    public static boolean isPermissionGrantedWithMCheck(@NonNull String string, Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            return PermissionUtils.isPermissionGranted(context, string);
        }
        return true;
    }

    public static boolean isCameraPermissionGranted(Context context) {
        return PermissionUtils.isPermissionGranted(context, "android.permission.CAMERA");
    }

    public static boolean isPermissionGranted(@NonNull Context context, @NonNull String string) {
        return context.checkSelfPermission(string) == 0;
    }

    public static boolean isMicrophoneDenied(@NonNull Activity activity) {
        if (Build.VERSION.SDK_INT >= 23 && PermissionUtils.isPermissionGranted((Context)activity, "android.permission.CAMERA")) {
            return !PermissionUtils.isMicrophonePermissionGranted((Context)activity) && !activity.shouldShowRequestPermissionRationale("android.permission.RECORD_AUDIO");
        }
        return false;
    }

    public static boolean isMicrophonePermissionGranted(Context context) {
        return PermissionUtils.isPermissionGrantedWithMCheck("android.permission.RECORD_AUDIO", context);
    }
}

