/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.internal.utils;

import com.banuba.sdk.internal.encoding.RecordingParams;
import java.util.concurrent.TimeUnit;

public final class TimeUtils {
    public static double micro2second(long l) {
        return (double)l / 1000000.0;
    }

    public static long micro2nano(long l) {
        return l * 1000L;
    }

    public static int micro2milli(long l) {
        return (int)(l / 1000L);
    }

    public static int nano2milli(long l) {
        return (int)(l / 1000000L);
    }

    public static long milli2nano(long l) {
        return l * 1000000L;
    }

    public static double nano2sec(long l) {
        return (double)l / 1.0E9;
    }

    public static double micro2sec(long l) {
        return (double)l / 1000000.0;
    }

    public static double milli2sec(int n) {
        return (double)n / 1000.0;
    }

    public static double milli2sec(long l) {
        return (double)l / 1000.0;
    }

    public static int audioTimeSec2BufferPosition(double d) {
        return (int)TimeUtils.alignSampleSize((int)Math.round(d * (double)RecordingParams.getAudioFormatBytes() * (double)RecordingParams.getChannelCount() * (double)RecordingParams.getAudioSampleRate()));
    }

    public static int audioTimeSec2BufferPositionBlocked(double d, int n) {
        int n2 = (int)TimeUtils.alignSampleSize((int)Math.round(d * (double)RecordingParams.getAudioFormatBytes() * (double)RecordingParams.getChannelCount() * (double)RecordingParams.getAudioSampleRate()));
        return Math.max(0, n2 - n2 % n - n);
    }

    public static long audioBufferPosition2TimeNanoSec(int n) {
        return TimeUtils.alignSampleSize((long)(n / (RecordingParams.getAudioFormatBytes() * RecordingParams.getChannelCount())) * TimeUnit.SECONDS.toNanos(1L) / (long)RecordingParams.getAudioSampleRate());
    }

    public static long milli2nanoWithSpeed(int n, float f) {
        double d = f;
        return (long)((double)TimeUtils.milli2nano(n) * (1.0 / d));
    }

    public static long getCorrectedTime(long l, float f) {
        double d = f;
        return (long)((double)l * (1.0 / d));
    }

    private static long alignSampleSize(long l) {
        long l2 = l;
        return l2 - l2 % (long)RecordingParams.getAudioSampleSize();
    }
}

