/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.manager;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Size;
import android.view.Choreographer;
import android.view.OrientationEventListener;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.Recycler;
import com.banuba.sdk.camera.CameraFpsMode;
import com.banuba.sdk.camera.Facing;
import com.banuba.sdk.effect_player.Effect;
import com.banuba.sdk.effect_player.EffectManager;
import com.banuba.sdk.effect_player.EffectPlayer;
import com.banuba.sdk.effect_player.EffectPlayerConfiguration;
import com.banuba.sdk.entity.ContentRatioParams;
import com.banuba.sdk.entity.DebugVideoCallbackListener;
import com.banuba.sdk.entity.PreferredSize;
import com.banuba.sdk.entity.RecordedVideoInfo;
import com.banuba.sdk.entity.WatermarkInfo;
import com.banuba.sdk.internal.camera.CameraHandler;
import com.banuba.sdk.internal.camera.CameraListener;
import com.banuba.sdk.internal.camera.CameraThread;
import com.banuba.sdk.internal.encoding.RecordingListener;
import com.banuba.sdk.internal.renderer.RenderMsgSender;
import com.banuba.sdk.internal.renderer.RenderThread;
import com.banuba.sdk.internal.utils.Logger;
import com.banuba.sdk.manager.BanubaSdkManagerConfiguration;
import com.banuba.sdk.manager.EffectInfo;
import com.banuba.sdk.manager.IAutoRotationHandler;
import com.banuba.sdk.manager.IEventCallback;
import com.banuba.sdk.manager.IFpsController;
import com.banuba.sdk.manager.IResolutionController;
import com.banuba.sdk.recognizer.UtilityManager;
import com.banuba.sdk.types.Data;
import com.banuba.sdk.types.FullImageData;
import com.banuba.sdk.utils.ContextProvider;
import com.banuba.sdk.utils.HardwareClass;
import com.getkeepsafe.relinker.ReLinker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

public final class BanubaSdkManager
implements Choreographer.FrameCallback {
    public static final String EFFECTS_RESOURCES_PATH = "/effects";
    private static final String RESOURCES_PATH = "bnb-resources";
    private static final String TAG = "BanubaSdkManager";
    private static final long DO_FRAME_INTERVAL = 30000000L;
    private static final int ORIENTATION_PORTRAIT_NORMAL = 0;
    private static final int ORIENTATION_LANDSCAPE_NORMAL = 90;
    private static final int ORIENTATION_PORTRAIT_INVERTED = 180;
    private static final int ORIENTATION_LANDSCAPE_INVERTED = 270;
    private static ArrayList<String> sUserResourcesPathsList;
    private final SurfaceCallback mSurfaceCallback;
    @Nullable
    private Surface mSurface;
    @Nullable
    private SurfaceHolder mSurfaceHolder;
    @Nullable
    private IEventCallback mCallback;
    @NonNull
    private final Context mContext;
    private RenderThread mRenderThread;
    private CameraThread mCameraThread;
    @Nullable
    private EffectPlayer mEffectPlayer;
    @Nullable
    private final EffectManager mEffectManager;
    @NonNull
    private final Size mPreferredSize;
    @NonNull
    private Facing mFacing;
    private boolean mRequireMirroring;
    private boolean mFlashlightEnabled;
    private float mCameraZoom;
    private int mScreenOrientation;
    private int mLastLandscapeScreenRotation;
    private boolean mIsFirstLandscapeRotation;
    private OrientationEventListener mOrientationEventListener;
    private FullImageData mPendingProcessImage;
    private long lastDoFrameNanos;
    @Nullable
    private final WindowManager mWindowManager;
    @Nullable
    private IFpsController mFpsController;
    @Nullable
    private IAutoRotationHandler mAutoRotationHandler;
    private final Object mSyncObj;
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private int mDrawWidth;
    private int mDrawHeight;

    public static void initialize(@NonNull Context context, @NonNull String string, String ... stringArray) {
        if (sUserResourcesPathsList != null) {
            return;
        }
        sUserResourcesPathsList = stringArray == null ? new ArrayList() : new ArrayList<String>(Arrays.asList(stringArray));
        Context context2 = context;
        ReLinker.loadLibrary((Context)context2, (String)"banuba");
        ContextProvider.setContext((Context)context2);
        UtilityManager.initialize(sUserResourcesPathsList, (String)string.trim());
    }

    public static void deinitialize() {
        UtilityManager.release();
        sUserResourcesPathsList = null;
    }

    public static void enableDiagnostics(String string) {
        UtilityManager.enableDiagnostics((String)string);
    }

    public BanubaSdkManager(@NonNull Context context) {
        this(context, (IResolutionController)null);
    }

    public BanubaSdkManager(@NonNull Context context, @NonNull BanubaSdkManagerConfiguration banubaSdkManagerConfiguration) {
        this(context, banubaSdkManagerConfiguration.getResolutionController());
        this.mFpsController = banubaSdkManagerConfiguration.getFpsController();
        this.mFacing = banubaSdkManagerConfiguration.getFacing();
        this.mRequireMirroring = banubaSdkManagerConfiguration.isFacingMirrored();
        this.mAutoRotationHandler = banubaSdkManagerConfiguration.getAutoRotationHandler();
    }

    public BanubaSdkManager(@NonNull Context object, @Nullable IResolutionController iResolutionController) {
        Object object2;
        SurfaceCallback surfaceCallback;
        Object object3 = surfaceCallback;
        surfaceCallback = new SurfaceCallback();
        this.mSurfaceCallback = object3;
        this.mFacing = Facing.FRONT;
        this.mRequireMirroring = true;
        this.mCameraZoom = 1.0f;
        this.mLastLandscapeScreenRotation = 0;
        this.mIsFirstLandscapeRotation = true;
        object3 = object2;
        object2 = new Object();
        this.mSyncObj = object3;
        this.mSurfaceWidth = 1;
        this.mSurfaceHeight = 1;
        this.mDrawWidth = 1;
        this.mDrawHeight = 1;
        if (sUserResourcesPathsList != null) {
            RenderThread renderThread;
            CameraThread cameraThread;
            InternalCombinedCallback internalCombinedCallback;
            this.mContext = object;
            HardwareClass hardwareClass = UtilityManager.getHardwareClass();
            Logger.i("Hardware class is " + hardwareClass, new Object[0]);
            object3 = PreferredSize.getForHardwareClass(hardwareClass).getMaxSize();
            if (iResolutionController != null) {
                object3 = iResolutionController.getSize((Size)object3);
            }
            this.mPreferredSize = object3;
            iResolutionController = this.getRenderPreferredSize();
            this.mEffectPlayer = Objects.requireNonNull(EffectPlayer.create((EffectPlayerConfiguration)EffectPlayerConfiguration.create((int)iResolutionController.getWidth(), (int)iResolutionController.getHeight())));
            this.mEffectManager = this.mEffectPlayer.effectManager();
            this.mWindowManager = (WindowManager)object.getSystemService("window");
            InternalCombinedCallback internalCombinedCallback2 = internalCombinedCallback;
            internalCombinedCallback = new InternalCombinedCallback();
            CameraThread cameraThread2 = cameraThread;
            Context context = object;
            object = Objects.requireNonNull(this.mEffectPlayer);
            IFpsController iFpsController = this.mFpsController;
            this.mCameraThread = cameraThread2;
            new CameraThread(context, (EffectPlayer)object, internalCombinedCallback2, (Size)object3, iFpsController).startAndGetHandler();
            object = renderThread;
            this.mRenderThread = object;
            new RenderThread(this.mEffectPlayer, (Size)iResolutionController, internalCombinedCallback2).startAndGetHandler();
            this.setAutoFaceOrientation(true);
            this.setRequireMirroring(this.mRequireMirroring);
            this.mScreenOrientation = this.getScreenRotation() * 90;
            return;
        }
        throw new IllegalStateException("You must call `initialize` before an instance creation");
    }

    /*
     * Unable to fully structure code
     */
    public static List<EffectInfo> loadEffects() {
        var0 = v0;
        v0 = new ArrayList<EffectInfo>();
        var1_1 = ContextProvider.getAssets();
        var2_2 = 2;
        v1 = new String[2];
        var3_3 = v1;
        v1[0] = "effects/";
        v1[1] = "bnb-resources/effects/";
        for (var4_4 = 0; var4_4 < var2_2; ++var4_4) {
            var5_5 = var3_3[var4_4];
            ** try [egrp 0[TRYBLOCK] [0 : 48->51)] { 
lbl12:
            // 2 sources

            for (String var9_9 : var1_1.list(var5_5)) {
                var0.add(new EffectInfo(var5_5 + var9_9));
            }
            continue;
lbl17:
            // 1 sources

            catch (IOException v2) {}
        }
        return var0;
    }

    public static String getResourcesBase() {
        return RESOURCES_PATH;
    }

    @Nullable
    private RenderMsgSender getRenderMsgSender() {
        RenderThread renderThread = ((BanubaSdkManager)((Object)renderThread)).mRenderThread;
        if (renderThread == null) {
            return null;
        }
        return (RenderMsgSender)renderThread.getHandler();
    }

    @Nullable
    private CameraHandler getCameraMsgSender() {
        CameraThread cameraThread = ((BanubaSdkManager)((Object)cameraThread)).mCameraThread;
        if (cameraThread != null) {
            return (CameraHandler)((Object)cameraThread.getHandler());
        }
        return null;
    }

    private void shutdownCameraThread() {
        Object object = this.getCameraMsgSender();
        if (object != null) {
            object.sendShutdown();
        }
        if ((object = this.mCameraThread) != null) {
            try {
                ((Thread)object).join();
            }
            catch (InterruptedException interruptedException) {}
            this.mCameraThread = null;
        }
    }

    private void shutdownRenderThread() {
        Object object = this.getRenderMsgSender();
        if (object != null) {
            object.sendShutdown();
        }
        if ((object = this.mRenderThread) != null) {
            try {
                ((Thread)object).join();
            }
            catch (InterruptedException interruptedException) {}
            this.mRenderThread = null;
        }
    }

    private int getScreenRotation() {
        int n = 0;
        WindowManager windowManager = this.mWindowManager;
        if (windowManager != null) {
            n = windowManager.getDefaultDisplay().getRotation();
        }
        return n;
    }

    private void onOrientationChange(int n) {
        BanubaSdkManager banubaSdkManager = this;
        banubaSdkManager.ifAutoRotationOff(() -> {
            if ((this = ((BanubaSdkManager)this).getCameraMsgSender()) != null) {
                ((CameraHandler)((Object)((Object)this))).sendFaceOrient(n);
            }
        });
    }

    private void onSurfaceChanged(final boolean bl) {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                Object object = BanubaSdkManager.this.mSyncObj;
                synchronized (object) {
                    if (BanubaSdkManager.this.mCameraThread != null) {
                        BanubaSdkManager.this.mCameraThread.setPushOn(false);
                        BanubaSdkManager.this.mCameraThread.setScreenOrientation(BanubaSdkManager.this.getScreenRotation());
                        if (BanubaSdkManager.this.isAutoRotationOff()) {
                            BanubaSdkManager.this.mCameraThread.setFaceOrient(BanubaSdkManager.this.mScreenOrientation);
                        }
                        if (bl && BanubaSdkManager.this.mRenderThread != null && BanubaSdkManager.this.mEffectPlayer != null && BanubaSdkManager.this.mEffectManager != null) {
                            BanubaSdkManager.this.mEffectPlayer.playbackPause();
                            BanubaSdkManager.this.mEffectPlayer.surfaceChanged(BanubaSdkManager.this.mSurfaceWidth, BanubaSdkManager.this.mSurfaceHeight);
                            BanubaSdkManager.this.mEffectManager.setEffectSize(BanubaSdkManager.this.mDrawWidth, BanubaSdkManager.this.mDrawHeight);
                            BanubaSdkManager.this.mRenderThread.setDrawSize(BanubaSdkManager.this.mDrawWidth, BanubaSdkManager.this.mDrawHeight);
                            BanubaSdkManager.this.mEffectPlayer.playbackPlay();
                        }
                        BanubaSdkManager.this.mCameraThread.setPushOn(true);
                    }
                    return;
                }
            }
        };
        this.runOnRenderThread(runnable2);
    }

    private boolean isAutoRotationOff() {
        IAutoRotationHandler iAutoRotationHandler = ((BanubaSdkManager)((Object)iAutoRotationHandler)).mAutoRotationHandler;
        return iAutoRotationHandler != null && iAutoRotationHandler.isAutoRotationOff();
    }

    private void ifAutoRotationOff(@NonNull Runnable runnable) {
        if (this.isAutoRotationOff()) {
            runnable.run();
        }
    }

    private boolean isLandscapeSurfaceRotation() {
        return this.getScreenRotation() == 1 || this.getScreenRotation() == 3;
    }

    @NonNull
    private Size getRenderPreferredSize() {
        if (this.isLandscapeSurfaceRotation()) {
            return new Size(this.mPreferredSize.getHeight(), this.mPreferredSize.getWidth());
        }
        return new Size(this.mPreferredSize.getWidth(), this.mPreferredSize.getHeight());
    }

    private /* synthetic */ Effect lambda$loadEffect$0(String string) {
        return this.getEffectManager().load(string);
    }

    static /* synthetic */ int access$102(BanubaSdkManager banubaSdkManager, int n) {
        banubaSdkManager.mScreenOrientation = n;
        return n;
    }

    static /* synthetic */ int access$302(BanubaSdkManager banubaSdkManager, int n) {
        banubaSdkManager.mLastLandscapeScreenRotation = n;
        return n;
    }

    static /* synthetic */ boolean access$502(BanubaSdkManager banubaSdkManager, boolean bl) {
        banubaSdkManager.mIsFirstLandscapeRotation = bl;
        return bl;
    }

    public void doFrame(long l) {
        RenderMsgSender renderMsgSender = this.getRenderMsgSender();
        if (renderMsgSender != null) {
            long l2 = this.lastDoFrameNanos;
            if (l2 == 0L || l - l2 >= 30000000L) {
                this.lastDoFrameNanos = l;
                renderMsgSender.sendDoFrame(l);
            }
            Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
        }
    }

    public void setCallback(IEventCallback iEventCallback) {
        this.mCallback = iEventCallback;
    }

    public boolean setCameraFacing(@NonNull Facing facing) {
        return this.setCameraFacing(facing, this.mRequireMirroring);
    }

    public boolean setCameraFacing(@NonNull Facing facing, boolean bl) {
        if (this.mFacing != facing || this.mRequireMirroring != bl) {
            BanubaSdkManager banubaSdkManager = this;
            banubaSdkManager.mFacing = facing;
            banubaSdkManager.mCameraZoom = 1.0f;
            banubaSdkManager.closeCamera();
            banubaSdkManager.setRequireMirroring(bl);
            banubaSdkManager.openCamera();
        }
        return true;
    }

    public Facing getCameraFacing() {
        return this.mFacing;
    }

    public void setCameraZoom(float f) {
        if (this.mCameraZoom != f) {
            this.mCameraZoom = f;
            CameraHandler cameraHandler = this.getCameraMsgSender();
            if (cameraHandler != null) {
                cameraHandler.sendChangeZoom(this.mCameraZoom);
            } else {
                Logger.w("Failed to change camera zoom: camera thread is dead.", new Object[0]);
            }
        }
    }

    public void setAutoFaceOrientation(boolean bl) {
        if (!bl) {
            OrientationEventListener orientationEventListener = this.mOrientationEventListener;
            if (orientationEventListener != null) {
                orientationEventListener.disable();
            }
            this.mOrientationEventListener = null;
            return;
        }
        if (this.mOrientationEventListener == null) {
            OrientationEventListener orientationEventListener;
            OrientationEventListener orientationEventListener2 = orientationEventListener;
            orientationEventListener = new OrientationEventListener(this.mContext, 3){

                public void onOrientationChanged(int n) {
                    int n2 = BanubaSdkManager.this.mScreenOrientation;
                    if (n >= 35 && 325 > n) {
                        if (235 <= n && n < 305) {
                            if (BanubaSdkManager.this.mScreenOrientation != 90) {
                                BanubaSdkManager.access$102(BanubaSdkManager.this, 90);
                            }
                        } else if (145 <= n && n < 215) {
                            if (BanubaSdkManager.this.mScreenOrientation != 180) {
                                BanubaSdkManager.access$102(BanubaSdkManager.this, 180);
                            }
                        } else if (55 <= n && n < 125 && BanubaSdkManager.this.mScreenOrientation != 270) {
                            BanubaSdkManager.access$102(BanubaSdkManager.this, 270);
                        }
                    } else if (BanubaSdkManager.this.mScreenOrientation != 0) {
                        BanubaSdkManager.access$102(BanubaSdkManager.this, 0);
                    }
                    if (n2 != BanubaSdkManager.this.mScreenOrientation) {
                        BanubaSdkManager banubaSdkManager = BanubaSdkManager.this;
                        banubaSdkManager.onOrientationChange(banubaSdkManager.mScreenOrientation);
                    }
                    if (BanubaSdkManager.this.mLastLandscapeScreenRotation != BanubaSdkManager.this.getScreenRotation() && (BanubaSdkManager.this.getScreenRotation() == 1 || BanubaSdkManager.this.getScreenRotation() == 3)) {
                        1 v1 = this;
                        BanubaSdkManager banubaSdkManager = v1.BanubaSdkManager.this;
                        BanubaSdkManager.access$302(banubaSdkManager, banubaSdkManager.getScreenRotation());
                        if (v1.BanubaSdkManager.this.mIsFirstLandscapeRotation) {
                            BanubaSdkManager.access$502(BanubaSdkManager.this, false);
                            return;
                        }
                        BanubaSdkManager.this.onSurfaceChanged(false);
                    }
                }
            };
            this.mOrientationEventListener = orientationEventListener2;
        }
        this.mOrientationEventListener.enable();
    }

    public void setRequireMirroring(boolean bl) {
        ((BanubaSdkManager)this).mRequireMirroring = bl;
        if ((this = ((BanubaSdkManager)this).getCameraMsgSender()) != null) {
            ((CameraHandler)((Object)this)).sendRequireMirroring(bl);
        }
    }

    public void setCameraFpsMode(@NonNull CameraFpsMode cameraFpsMode) {
        if ((this = ((BanubaSdkManager)this).getCameraMsgSender()) != null) {
            ((CameraHandler)((Object)this)).sendFpsMode(cameraFpsMode);
        }
    }

    public void setWatermarkInfo(WatermarkInfo watermarkInfo) {
        if ((this = ((BanubaSdkManager)this).getRenderMsgSender()) != null) {
            this.sendWatermarkInfo(watermarkInfo);
        }
    }

    public void effectPlayerPlay() {
        RenderMsgSender renderMsgSender = this.getRenderMsgSender();
        if (renderMsgSender != null) {
            RenderMsgSender renderMsgSender2 = renderMsgSender;
            renderMsgSender2.sendEffectPlayerPlay();
            renderMsgSender2.sendResumeDoFrame();
            Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
        } else {
            Objects.requireNonNull(this.mEffectPlayer).playbackPlay();
        }
    }

    public void effectPlayerPause() {
        RenderMsgSender renderMsgSender = this.getRenderMsgSender();
        if (renderMsgSender != null) {
            RenderMsgSender renderMsgSender2 = renderMsgSender;
            Choreographer.getInstance().removeFrameCallback((Choreographer.FrameCallback)this);
            renderMsgSender2.sendStopDoFrame();
            renderMsgSender2.sendEffectPlayerPause();
        } else {
            Objects.requireNonNull(this.mEffectPlayer).playbackPause();
        }
    }

    public void setFlashlightEnabled(boolean bl) {
        BanubaSdkManager banubaSdkManager = this;
        banubaSdkManager.mFlashlightEnabled = bl;
        banubaSdkManager.closeCamera();
        banubaSdkManager.openCamera();
    }

    public void openCamera() {
        CameraHandler cameraHandler = this.getCameraMsgSender();
        if (cameraHandler != null) {
            BanubaSdkManager banubaSdkManager = this;
            Facing facing = banubaSdkManager.mFacing;
            float f = banubaSdkManager.mCameraZoom;
            int n = banubaSdkManager.getScreenRotation();
            boolean bl = banubaSdkManager.mRequireMirroring;
            boolean bl2 = banubaSdkManager.mFlashlightEnabled;
            cameraHandler.sendOpenCamera(facing, f, n, bl, bl2);
            if (this.isAutoRotationOff()) {
                cameraHandler.sendFaceOrient(this.mScreenOrientation);
            }
        }
    }

    public void closeCamera() {
        if ((this = ((BanubaSdkManager)this).getCameraMsgSender()) != null) {
            ((CameraHandler)((Object)this)).sendCloseCamera();
        }
    }

    public void releaseSurface() {
        SurfaceHolder surfaceHolder = this.mSurfaceHolder;
        if (surfaceHolder != null) {
            surfaceHolder.removeCallback((SurfaceHolder.Callback)this.mSurfaceCallback);
        }
        this.mSurfaceCallback.surfaceDestroyed(this.mSurfaceHolder);
    }

    public void attachSurface(Surface surface) {
        this.mSurface = surface;
    }

    public void attachSurface(SurfaceView surfaceView) {
        SurfaceView surfaceView2 = surfaceView;
        surfaceView = surfaceView2.getHolder();
        this.mSurfaceHolder = surfaceView;
        surfaceView.addCallback((SurfaceHolder.Callback)this.mSurfaceCallback);
        this.attachSurface(surfaceView2.getHolder().getSurface());
    }

    public void clearSurface() {
        if ((this = ((BanubaSdkManager)this).getRenderMsgSender()) != null) {
            this.sendClearSurface();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Effect loadEffect(String objectArray, boolean bl) {
        if (bl) {
            void var0_3;
            FutureTask<Effect> futureTask;
            FutureTask<Effect> futureTask2 = futureTask;
            this.runOnRenderThread(new FutureTask<Effect>(() -> this.lambda$loadEffect$0((String)objectArray)));
            try {
                return (Effect)futureTask2.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = var0_3;
            Logger.wtf(TAG, objectArray);
            return null;
        }
        return this.getEffectManager().loadAsync((String)objectArray);
    }

    public void unloadEffect(Effect effect) {
        this.runOnRenderThread(new FutureTask<Void>(() -> {
            this.getEffectManager().unload(effect);
            return null;
        }));
    }

    public void onSurfaceCreated() {
        Object object = objectArray2.mSurface;
        if (object != null && object.isValid()) {
            object = super.getRenderMsgSender();
            if (object != null) {
                object.sendSurfaceCreated(objectArray2.mSurface);
            }
            Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)objectArray2);
            return;
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = "Invalid surface";
        Logger.w(TAG, objectArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSurfaceChanged(int n, int n2, int n3) {
        Object object = banubaSdkManager3.getRenderMsgSender();
        if (object != null) {
            object.sendSurfaceChanged(n2, n3);
            FullImageData fullImageData = banubaSdkManager3.mPendingProcessImage;
            if (fullImageData != null) {
                object.sendProcessImage(fullImageData);
                banubaSdkManager3.mPendingProcessImage = null;
            }
        }
        object = banubaSdkManager3.mSyncObj;
        BanubaSdkManager banubaSdkManager = banubaSdkManager3;
        BanubaSdkManager banubaSdkManager2 = banubaSdkManager3;
        synchronized (object) {
            BanubaSdkManager banubaSdkManager3 = banubaSdkManager3.getRenderPreferredSize();
            banubaSdkManager2.mSurfaceWidth = n2;
            banubaSdkManager.mSurfaceHeight = n3;
            banubaSdkManager.mDrawWidth = banubaSdkManager3.getWidth();
            banubaSdkManager.mDrawHeight = banubaSdkManager3.getHeight();
            banubaSdkManager.onSurfaceChanged(true);
            return;
        }
    }

    public void onSurfaceDestroyed() {
        Choreographer.getInstance().removeFrameCallback((Choreographer.FrameCallback)this);
        RenderMsgSender renderMsgSender = this.getRenderMsgSender();
        if (renderMsgSender != null) {
            renderMsgSender.sendSurfaceDestroyed();
            this.waitOnRenderThread();
        }
    }

    public void takePhoto(@Nullable ContentRatioParams contentRatioParams) {
        if ((this = ((BanubaSdkManager)this).getRenderMsgSender()) != null) {
            this.sendTakePhoto(contentRatioParams);
        }
    }

    public void processCameraPhoto() {
        if ((this = ((BanubaSdkManager)this).getCameraMsgSender()) != null) {
            ((CameraHandler)((Object)this)).sendRequestHighResPhoto();
        }
    }

    public void processImage(@NonNull FullImageData fullImageData) {
        RenderMsgSender renderMsgSender = this.getRenderMsgSender();
        if (renderMsgSender != null) {
            renderMsgSender.sendProcessImage(fullImageData);
        } else {
            this.mPendingProcessImage = fullImageData;
        }
    }

    public void startVideoRecording(@Nullable String string, boolean bl, @Nullable ContentRatioParams contentRatioParams, float f) {
        if (string != null) {
            if ((this = ((BanubaSdkManager)this).getRenderMsgSender()) != null) {
                this.sendStartRecording(string, bl, contentRatioParams, f);
            }
            return;
        }
        throw new IllegalStateException("At least 1 path for recording should be provided!");
    }

    public void startDebugVideoRecording(@NonNull DebugVideoCallbackListener debugVideoCallbackListener) {
        if ((this = ((BanubaSdkManager)this).getCameraMsgSender()) != null) {
            ((CameraHandler)((Object)this)).sendRecordDebugVideo(debugVideoCallbackListener);
        }
    }

    public void stopDebugVideoRecording() {
        if ((this = ((BanubaSdkManager)this).getCameraMsgSender()) != null) {
            ((CameraHandler)((Object)this)).sendRecordDebugVideo(null);
        }
    }

    public void stopVideoRecording() {
        if ((this = ((BanubaSdkManager)this).getRenderMsgSender()) != null) {
            this.sendStopRecording();
        }
    }

    public void pauseVideoRecording() {
        if ((this = ((BanubaSdkManager)this).getRenderMsgSender()) != null) {
            this.sendPauseRecording();
        }
    }

    public void unpauseVideoRecording() {
        if ((this = ((BanubaSdkManager)this).getRenderMsgSender()) != null) {
            this.sendUnpauseRecording();
        }
    }

    public void startForwardingFrames() {
        Objects.requireNonNull(this.getRenderMsgSender()).sendStartForwardingFrames();
    }

    public void stopForwardingFrames() {
        Objects.requireNonNull(this.getRenderMsgSender()).sendStopForwardingFrames();
    }

    public void startForwardingTextures() {
        Objects.requireNonNull(this.getRenderMsgSender()).sendStartForwardingTextures();
    }

    public void stopForwardingTextures() {
        Objects.requireNonNull(this.getRenderMsgSender()).sendStopForwardingTextures();
    }

    public void startEditingImage(@NonNull FullImageData fullImageData) {
        Objects.requireNonNull(this.getRenderMsgSender()).sendStartEditingImage(fullImageData);
    }

    public void stopEditingImage() {
        Objects.requireNonNull(this.getRenderMsgSender()).sendStopEditingImage();
    }

    public void takeEditedImage() {
        Objects.requireNonNull(this.getRenderMsgSender()).sendTakeEditedImage();
    }

    public EffectPlayer getEffectPlayer() {
        return this.mEffectPlayer;
    }

    @NonNull
    public EffectManager getEffectManager() {
        return Objects.requireNonNull(this.mEffectManager);
    }

    public void recycle() {
        BanubaSdkManager banubaSdkManager = this;
        banubaSdkManager.releaseSurface();
        banubaSdkManager.shutdownCameraThread();
        banubaSdkManager.shutdownRenderThread();
        banubaSdkManager.setAutoFaceOrientation(false);
        banubaSdkManager.mEffectPlayer = (EffectPlayer)Recycler.recycle((Object)banubaSdkManager.mEffectPlayer);
    }

    public void runOnRenderThread(Runnable runnable) {
        Objects.requireNonNull(this.getRenderMsgSender()).sendRunnable(runnable);
    }

    /*
     * WARNING - void declaration
     */
    public void waitOnRenderThread() {
        block3: {
            void var0_3;
            FutureTask<Void> futureTask = new FutureTask<Void>(() -> null);
            this.runOnRenderThread(futureTask);
            try {
                futureTask.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
            break block3;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = var0_3;
            Logger.wtf(TAG, objectArray2);
        }
    }

    protected void finalize() {
        BanubaSdkManager banubaSdkManager = this;
        banubaSdkManager.shutdownCameraThread();
        banubaSdkManager.shutdownRenderThread();
        super.finalize();
    }

    private class SurfaceCallback
    implements SurfaceHolder.Callback {
        private SurfaceCallback() {
        }

        public void surfaceCreated(SurfaceHolder surfaceHolder) {
            BanubaSdkManager.this.onSurfaceCreated();
        }

        public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
            BanubaSdkManager.this.onSurfaceChanged(n, n2, n3);
        }

        public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
            BanubaSdkManager.this.onSurfaceDestroyed();
        }
    }

    private class InternalCombinedCallback
    implements CameraListener,
    RecordingListener {
        private InternalCombinedCallback() {
        }

        private void ifCallbackDefined(@NonNull Consumer<IEventCallback> consumer) {
            this.ifCallbackDefined(consumer, null);
        }

        private void ifCallbackDefined(@NonNull Consumer<IEventCallback> consumer, @Nullable String string) {
            if (BanubaSdkManager.this.mCallback != null) {
                consumer.accept(BanubaSdkManager.this.mCallback);
            } else if (string != null) {
                Logger.w(string, new Object[0]);
            }
        }

        @Override
        public void onCameraOpenError(Throwable throwable) {
            this.ifCallbackDefined(iEventCallback -> iEventCallback.onCameraOpenError(throwable), "Failed to open camera, reason: " + throwable.getMessage());
        }

        @Override
        public void onCameraStatus(boolean bl) {
            this.ifCallbackDefined(iEventCallback -> iEventCallback.onCameraStatus(bl));
        }

        @Override
        public void onRecordingChanged(boolean bl) {
            this.ifCallbackDefined(iEventCallback -> iEventCallback.onVideoRecordingStatusChange(bl));
        }

        @Override
        public void onHighResPhoto(@NonNull FullImageData fullImageData) {
            RenderMsgSender renderMsgSender = ((InternalCombinedCallback)((Object)renderMsgSender)).BanubaSdkManager.this.getRenderMsgSender();
            if (renderMsgSender != null) {
                renderMsgSender.sendProcessPhoto(fullImageData);
            }
        }

        @Override
        public void onRecordingStatusChange(boolean bl) {
            this.ifCallbackDefined(iEventCallback -> iEventCallback.onVideoRecordingStatusChange(bl));
        }

        @Override
        public void onRecordingCompleted(@NonNull RecordedVideoInfo recordedVideoInfo) {
            this.ifCallbackDefined(iEventCallback -> iEventCallback.onVideoRecordingFinished(recordedVideoInfo));
        }

        @Override
        public void onPhotoReady(@NonNull Bitmap bitmap) {
            this.ifCallbackDefined(iEventCallback -> iEventCallback.onScreenshotReady(bitmap));
        }

        @Override
        public void onHQPhotoProcessed(@NonNull Bitmap bitmap) {
            this.ifCallbackDefined(iEventCallback -> iEventCallback.onHQPhotoReady(bitmap));
        }

        @Override
        public void onImageProcessed(@NonNull Bitmap bitmap) {
            this.ifCallbackDefined(iEventCallback -> iEventCallback.onImageProcessed(bitmap));
        }

        @Override
        public void onEditedImageReady(@NonNull Bitmap bitmap) {
            this.ifCallbackDefined(iEventCallback -> iEventCallback.onEditedImageReady(bitmap));
        }

        @Override
        public void onEditingModeFaceFound(boolean bl) {
            this.ifCallbackDefined(iEventCallback -> iEventCallback.onEditingModeFaceFound(bl));
        }

        @Override
        public void onFrame(@NonNull Data data, int n, int n2) {
            this.ifCallbackDefined(iEventCallback -> iEventCallback.onFrameRendered(data, n, n2), "Probably data was not closed - potential memory leak issue!");
        }

        @Override
        public void onTextureFrame(int n, int n2, int n3, long l, float[] fArray) {
            this.ifCallbackDefined(iEventCallback -> iEventCallback.onTextureRendered(n, n2, n3, l, fArray));
        }
    }

    @FunctionalInterface
    public static interface Consumer<T> {
        public void accept(T var1);
    }
}

