/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.manager;

import androidx.annotation.Nullable;
import com.banuba.sdk.camera.Facing;
import com.banuba.sdk.manager.IAutoRotationHandler;
import com.banuba.sdk.manager.IFpsController;
import com.banuba.sdk.manager.IResolutionController;

public final class BanubaSdkManagerConfiguration {
    private final boolean mIsMirrored;
    private final Facing mFacing;
    @Nullable
    private final IResolutionController mResolutionController;
    @Nullable
    private final IFpsController mFpsController;
    @Nullable
    private final IAutoRotationHandler mAutoRotationHandler;

    private BanubaSdkManagerConfiguration(Builder builder) {
        this.mIsMirrored = builder.mIsMirrored;
        this.mFacing = builder.mFacing;
        this.mResolutionController = builder.mResolutionController;
        this.mFpsController = builder.mFpsController;
        this.mAutoRotationHandler = builder.mAutoRotationHandler;
    }

    public static Builder newInstance() {
        return new Builder();
    }

    public static Builder newInstance(Facing facing, boolean bl) {
        return new Builder(facing, bl);
    }

    public boolean isFacingMirrored() {
        return this.mIsMirrored;
    }

    public Facing getFacing() {
        return this.mFacing;
    }

    @Nullable
    public IResolutionController getResolutionController() {
        return this.mResolutionController;
    }

    @Nullable
    public IFpsController getFpsController() {
        return this.mFpsController;
    }

    @Nullable
    public IAutoRotationHandler getAutoRotationHandler() {
        return this.mAutoRotationHandler;
    }

    public static class Builder {
        private boolean mIsMirrored = true;
        private Facing mFacing;
        @Nullable
        private IResolutionController mResolutionController;
        @Nullable
        private IFpsController mFpsController;
        @Nullable
        private IAutoRotationHandler mAutoRotationHandler;

        private Builder() {
            this.mFacing = Facing.FRONT;
        }

        private Builder(Facing facing, boolean bl) {
            this.mFacing = facing;
            this.mIsMirrored = bl;
        }

        public Builder setFacingMirrored(boolean bl) {
            this.mIsMirrored = bl;
            return this;
        }

        public Builder setFacing(Facing facing) {
            this.mFacing = facing;
            return this;
        }

        public Builder setResolutionController(@Nullable IResolutionController iResolutionController) {
            this.mResolutionController = iResolutionController;
            return this;
        }

        public Builder setFpsController(@Nullable IFpsController iFpsController) {
            this.mFpsController = iFpsController;
            return this;
        }

        public Builder setAutoRotationHandler(@Nullable IAutoRotationHandler iAutoRotationHandler) {
            this.mAutoRotationHandler = iAutoRotationHandler;
            return this;
        }

        public BanubaSdkManagerConfiguration build() {
            return new BanubaSdkManagerConfiguration(this);
        }
    }
}

