/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.manager;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import androidx.annotation.NonNull;
import com.banuba.sdk.effect_player.EffectPlayer;
import com.banuba.sdk.effect_player.InputManager;
import com.banuba.sdk.types.Touch;
import java.util.HashMap;

public class BanubaSdkTouchListener
implements View.OnTouchListener {
    @SuppressLint(value={"UseSparseArrays"})
    private static HashMap<Long, Touch> map = new HashMap(1);
    private final EffectPlayer mEffectPlayer;
    private GesturesHandler mGestureHandler;
    private boolean misLongTapOccurs;

    public BanubaSdkTouchListener(@NonNull Context context, @NonNull EffectPlayer object) {
        GesturesHandler gesturesHandler;
        this.mEffectPlayer = object;
        object = gesturesHandler;
        gesturesHandler = new GesturesHandler(context, this);
        this.mGestureHandler = object;
    }

    private InputManager getInputManager() {
        return this.mEffectPlayer.getInputManager();
    }

    private void longTapOccurs() {
        this.misLongTapOccurs = true;
    }

    private static HashMap<Long, Touch> event2Touch(View view, MotionEvent motionEvent) {
        int n;
        int n2;
        if (motionEvent.getActionMasked() == 2) {
            n2 = 0;
            n = motionEvent.getPointerCount();
        } else {
            n2 = motionEvent.getActionIndex();
            n = n2 + 1;
        }
        map.clear();
        while (n2 < n) {
            float f = motionEvent.getX(n2) / (float)view.getWidth() * 2.0f + -1.0f;
            float f2 = ((float)view.getHeight() - motionEvent.getY(n2)) / (float)view.getHeight() * 2.0f + -1.0f;
            long l = motionEvent.getPointerId(n2);
            map.put(l, new Touch(f, f2, l));
            ++n2;
        }
        return map;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouch(View view, MotionEvent motionEvent) {
        HashMap<Long, Touch> hashMap = BanubaSdkTouchListener.event2Touch(view, motionEvent);
        this.mGestureHandler.onTouch(view, motionEvent);
        switch (motionEvent.getActionMasked()) {
            default: {
                return false;
            }
            case 3: {
                this.getInputManager().onTouchesCancelled(hashMap);
                break;
            }
            case 2: {
                this.getInputManager().onTouchesMoved(hashMap);
                break;
            }
            case 1: {
                if (this.misLongTapOccurs) {
                    this.mGestureHandler.onLongTapEnded();
                    this.misLongTapOccurs = false;
                }
            }
            case 6: {
                this.getInputManager().onTouchesEnded(hashMap);
                break;
            }
            case 0: 
            case 5: {
                this.getInputManager().onTouchesBegan(hashMap);
            }
        }
        return true;
    }

    private class GesturesHandler {
        private GestureDetector mGestureDetector;
        private RotationGestureDetector mRotationDetector;
        private ScaleGestureDetector mScaleDetector;
        private BanubaSdkTouchListener mTouchListener;
        private View mCurrentView;

        GesturesHandler(Context context, BanubaSdkTouchListener object) {
            ScaleGestureHandler scaleGestureHandler;
            ScaleGestureDetector scaleGestureDetector;
            RotationGestureDetector rotationGestureDetector;
            TouchGesturesHandler touchGesturesHandler;
            GestureDetector gestureDetector;
            this.mTouchListener = object;
            object = gestureDetector;
            Object object2 = touchGesturesHandler;
            touchGesturesHandler = new TouchGesturesHandler(this);
            gestureDetector = new GestureDetector((GestureDetector.OnGestureListener)object2);
            this.mGestureDetector = object;
            object = rotationGestureDetector;
            rotationGestureDetector = new RotationGestureDetector(this);
            this.mRotationDetector = object;
            object = scaleGestureDetector;
            object2 = scaleGestureHandler;
            scaleGestureHandler = new ScaleGestureHandler(this);
            scaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)object2);
            this.mScaleDetector = object;
        }

        public void onTouch(View view, MotionEvent motionEvent) {
            GesturesHandler gesturesHandler = this;
            gesturesHandler.mCurrentView = view;
            gesturesHandler.mRotationDetector.onTouchEvent(motionEvent);
            gesturesHandler.mScaleDetector.onTouchEvent(motionEvent);
            gesturesHandler.mGestureDetector.onTouchEvent(motionEvent);
        }

        public void onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
            this.mTouchListener.getInputManager().onSwipeGesture(Math.signum(f), -Math.signum(f2));
            if (motionEvent2.getActionMasked() == 1) {
                this.mTouchListener.getInputManager().onGestureEnded("Swipe");
            }
        }

        public void onLongTap(MotionEvent motionEvent) {
            MotionEvent motionEvent2 = motionEvent;
            if ((motionEvent = (Touch)BanubaSdkTouchListener.event2Touch(this.mCurrentView, motionEvent).get(motionEvent2.getPointerId(motionEvent2.getActionIndex()))) != null) {
                GesturesHandler gesturesHandler = this;
                gesturesHandler.mTouchListener.getInputManager().onLongTapGesture((Touch)motionEvent);
                gesturesHandler.mTouchListener.longTapOccurs();
            }
        }

        public void onLongTapEnded() {
            this.mTouchListener.getInputManager().onGestureEnded("LongTap");
        }

        public void onDoubleTap(MotionEvent motionEvent) {
            MotionEvent motionEvent2 = motionEvent;
            if ((motionEvent = (Touch)BanubaSdkTouchListener.event2Touch(this.mCurrentView, motionEvent).get(motionEvent2.getPointerId(motionEvent2.getActionIndex()))) != null) {
                this.mTouchListener.getInputManager().onDoubleTapGesture((Touch)motionEvent);
            }
        }

        public void onDoubleTapEnded() {
            this.mTouchListener.getInputManager().onGestureEnded("DoubleTap");
        }

        public void onScale(float f) {
            this.mTouchListener.getInputManager().onScaleGesture(f);
        }

        public void onScaleEnded() {
            this.mTouchListener.getInputManager().onGestureEnded("Scale");
        }

        public void onRotation(float f) {
            this.mTouchListener.getInputManager().onRotationGesture(-f);
        }

        public void onRotationEnded() {
            this.mTouchListener.getInputManager().onGestureEnded("Rotation");
        }
    }

    private class RotationGestureDetector {
        private float mFirstFingerX;
        private float mFirstFingerY;
        private float mSecondFingerX;
        private float mSecondFingerY;
        private int mFirstFingerID = -1;
        private int mSecondFingerID = -1;
        private float mCurrAngle = 0.0f;
        private GesturesHandler mGestureHandler;

        RotationGestureDetector(GesturesHandler gesturesHandler) {
            this.mGestureHandler = gesturesHandler;
        }

        void onTouchEvent(MotionEvent motionEvent) {
            switch (motionEvent.getActionMasked()) {
                default: {
                    break;
                }
                case 6: {
                    this.mSecondFingerID = -1;
                    this.mGestureHandler.onRotationEnded();
                    break;
                }
                case 5: {
                    int n = this.mFirstFingerID;
                    if (n < 0 || motionEvent.findPointerIndex(n) < 0) break;
                    this.mSecondFingerID = motionEvent.getPointerId(motionEvent.getActionIndex());
                    this.mSecondFingerX = motionEvent.getX(motionEvent.findPointerIndex(this.mFirstFingerID));
                    this.mSecondFingerY = motionEvent.getY(motionEvent.findPointerIndex(this.mFirstFingerID));
                    this.mFirstFingerX = motionEvent.getX(motionEvent.findPointerIndex(this.mSecondFingerID));
                    this.mFirstFingerY = motionEvent.getY(motionEvent.findPointerIndex(this.mSecondFingerID));
                    break;
                }
                case 3: {
                    this.mFirstFingerID = -1;
                    this.mSecondFingerID = -1;
                    break;
                }
                case 2: {
                    int n = this.mFirstFingerID;
                    if (n < 0 || this.mSecondFingerID < 0) break;
                    float f = motionEvent.getX(motionEvent.findPointerIndex(n));
                    float f2 = motionEvent.getX(motionEvent.findPointerIndex(this.mSecondFingerID));
                    float f3 = f;
                    float f4 = this.mFirstFingerX - this.mSecondFingerX;
                    f = this.mFirstFingerY - this.mSecondFingerY;
                    float f5 = motionEvent.getY(motionEvent.findPointerIndex(this.mSecondFingerID)) - motionEvent.getY(motionEvent.findPointerIndex(this.mFirstFingerID));
                    this.mCurrAngle = f4 = this.getAngle(f4, f, f2 -= f3, f5);
                    this.mGestureHandler.onRotation(f4);
                    break;
                }
                case 1: {
                    this.mFirstFingerID = -1;
                    break;
                }
                case 0: {
                    this.mFirstFingerID = motionEvent.getPointerId(motionEvent.getActionIndex());
                }
            }
        }

        float getAngle(float f, float f2, float f3, float f4) {
            float f5;
            float f6 = (float)Math.toDegrees(Math.atan2(f, f2) - Math.atan2(f3, f4)) % 360.0f;
            if (f5 < -180.0f) {
                f6 += 360.0f;
            }
            if (f6 > 180.0f) {
                f6 -= 360.0f;
            }
            return f6;
        }
    }

    private class ScaleGestureHandler
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        private GesturesHandler mGestureHandler;

        ScaleGestureHandler(GesturesHandler gesturesHandler) {
            this.mGestureHandler = gesturesHandler;
        }

        public boolean onScale(ScaleGestureDetector scaleGestureDetector) {
            this.mGestureHandler.onScale(scaleGestureDetector.getScaleFactor());
            return super.onScale(scaleGestureDetector);
        }

        public void onScaleEnd(ScaleGestureDetector scaleGestureDetector) {
            this.mGestureHandler.onScaleEnded();
            super.onScaleEnd(scaleGestureDetector);
        }
    }

    private class TouchGesturesHandler
    extends GestureDetector.SimpleOnGestureListener {
        private GesturesHandler mGestureHandler;
        private boolean mIsLongPressOccurs;

        TouchGesturesHandler(GesturesHandler gesturesHandler) {
            this.mGestureHandler = gesturesHandler;
        }

        public void onLongPress(MotionEvent motionEvent) {
            this.mGestureHandler.onLongTap(motionEvent);
            this.mIsLongPressOccurs = true;
            super.onLongPress(motionEvent);
        }

        public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
            this.mGestureHandler.onFling(motionEvent, motionEvent2, f, f2);
            return super.onFling(motionEvent, motionEvent2, f, f2);
        }

        public boolean onDoubleTap(MotionEvent motionEvent) {
            this.mGestureHandler.onDoubleTap(motionEvent);
            return super.onDoubleTap(motionEvent);
        }

        public boolean onDoubleTapEvent(MotionEvent motionEvent) {
            if (motionEvent.getActionMasked() == 1) {
                this.mGestureHandler.onDoubleTapEnded();
            }
            return super.onDoubleTapEvent(motionEvent);
        }
    }
}

