/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.offscreen;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import com.banuba.sdk.offscreen.ImageOrientation;
import com.banuba.sdk.offscreen.OEPImageFormat;
import java.nio.ByteBuffer;

@Deprecated
@Keep
public class ImageProcessResult {
    private final OEPImageFormat format;
    private final long timestamp;
    private final ImageOrientation orientation;
    private final ByteBuffer buffer;
    private final int planeCount;
    private final int[] rowStrides;
    private final int[] pixelStrides;
    private final int[] planesOffsets;
    private final int[] planesWidths;
    private final int[] planesHeights;

    ImageProcessResult(int n, int n2, @NonNull OEPImageFormat oEPImageFormat, long l, @NonNull ImageOrientation imageOrientation, @NonNull ByteBuffer byteBuffer) {
        block4: {
            block3: {
                block2: {
                    ((ImageProcessResult)object).format = oEPImageFormat;
                    ((ImageProcessResult)object).timestamp = l;
                    ((ImageProcessResult)object).orientation = imageOrientation;
                    ((ImageProcessResult)object).buffer = byteBuffer;
                    ((ImageProcessResult)object).planeCount = oEPImageFormat.getPlanesCount();
                    ((ImageProcessResult)object).pixelStrides = oEPImageFormat.getPixelStrides();
                    if (!oEPImageFormat.isI420()) break block2;
                    ImageProcessResult imageProcessResult = object;
                    ImageProcessResult imageProcessResult2 = object;
                    int n3 = n2 / 2;
                    imageProcessResult2.planesHeights = new int[]{n2, n3, n3};
                    n3 = n / 2;
                    imageProcessResult2.planesWidths = new int[]{n, n3, n3};
                    n3 = n + 7 & 0xFFFFFFF8;
                    imageProcessResult.rowStrides = new int[]{n3, n3, n3};
                    int[] nArray = new int[3];
                    int[] nArray2 = nArray;
                    nArray2[0] = 0;
                    nArray2[1] = n3 *= n2;
                    nArray[2] = n3 + n3 / 2;
                    imageProcessResult.planesOffsets = nArray;
                    break block3;
                }
                if (!oEPImageFormat.isRGBA()) break block4;
                ImageProcessResult imageProcessResult = object;
                int[] nArray = new int[1];
                Object object = nArray;
                nArray[0] = n;
                imageProcessResult.rowStrides = (int[])object;
                int[] nArray3 = new int[1];
                object = nArray3;
                nArray3[0] = 0;
                imageProcessResult.planesOffsets = (int[])object;
                int[] nArray4 = new int[1];
                object = nArray4;
                nArray4[0] = n2;
                imageProcessResult.planesHeights = (int[])object;
                int[] nArray5 = new int[1];
                object = nArray5;
                nArray5[0] = n;
                imageProcessResult.planesWidths = (int[])object;
            }
            return;
        }
        throw new RuntimeException("Unknown Image format = " + ((Object)((Object)oEPImageFormat)).toString());
    }

    public int getPlaneCount() {
        return this.planeCount;
    }

    public int getWidthOfPlane(int n) {
        return this.planesWidths[n];
    }

    public int getHeightOfPlane(int n) {
        return this.planesHeights[n];
    }

    public int getBytesPerRowOfPlane(int n) {
        return this.rowStrides[n];
    }

    public int getOffsetOfPlane(int n) {
        return this.planesOffsets[n];
    }

    public int getWidth() {
        return this.planesWidths[0];
    }

    public int getHeight() {
        return this.planesHeights[0];
    }

    public int getBytesPerRow() {
        return this.rowStrides[0];
    }

    @NonNull
    public int[] getPixelStrides() {
        return this.pixelStrides;
    }

    public int getPixelStride(int n) {
        return this.pixelStrides[n];
    }

    @NonNull
    public int[] getRowStrides() {
        return this.rowStrides;
    }

    public int getRowStride(int n) {
        return this.rowStrides[n];
    }

    @NonNull
    public OEPImageFormat getFormat() {
        return this.format;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @NonNull
    public ImageOrientation getOrientation() {
        return this.orientation;
    }

    @NonNull
    public ByteBuffer getBuffer() {
        ImageProcessResult imageProcessResult = this;
        imageProcessResult.buffer.position(0);
        ByteBuffer byteBuffer = imageProcessResult.buffer;
        byteBuffer.limit(byteBuffer.capacity());
        return imageProcessResult.buffer;
    }

    @NonNull
    public ByteBuffer getPlaneBuffer(int n) {
        ImageProcessResult imageProcessResult = this;
        imageProcessResult.buffer.position(this.getOffsetOfPlane(n));
        imageProcessResult.buffer.limit(this.getOffsetOfPlane(n) + this.getBytesPerRowOfPlane(n) * this.getHeightOfPlane(n));
        return imageProcessResult.buffer.slice();
    }
}

