/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.offscreen;

import androidx.annotation.NonNull;
import com.banuba.sdk.effect_player.ColorRange;
import com.banuba.sdk.effect_player.ColorStd;
import com.banuba.sdk.types.FullImageData;

@Deprecated
public final class OEPImageFormat
extends Enum<OEPImageFormat> {
    public static final /* enum */ OEPImageFormat RGBA;
    public static final /* enum */ OEPImageFormat I420_BT601_FULL;
    public static final /* enum */ OEPImageFormat I420_BT601_VIDEO;
    public static final /* enum */ OEPImageFormat I420_BT709_FULL;
    public static final /* enum */ OEPImageFormat I420_BT709_VIDEO;
    private static final /* synthetic */ OEPImageFormat[] $VALUES;
    private final boolean isRGBA;
    private final int planesCount;
    private final int[] pixelStrides;

    public static OEPImageFormat[] values() {
        return (OEPImageFormat[])$VALUES.clone();
    }

    public static OEPImageFormat valueOf(String string) {
        return Enum.valueOf(OEPImageFormat.class, string);
    }

    private OEPImageFormat(@NonNull boolean bl, int n2, int[] nArray) {
        this.isRGBA = bl;
        this.planesCount = n2;
        this.pixelStrides = nArray;
    }

    @NonNull
    public static OEPImageFormat makeFromFullImageData(@NonNull FullImageData fullImageData) {
        FullImageData fullImageData2 = fullImageData;
        OEPImageFormat.doThrowIfUnsupportedImageFormat(fullImageData2.getPixelFormat());
        if (fullImageData2.getPixelFormat() == 35) {
            FullImageData fullImageData3 = fullImageData;
            fullImageData = fullImageData3.getColorRange();
            if (fullImageData3.getColorStd() == ColorStd.BT601) {
                if (fullImageData == ColorRange.VIDEO) {
                    return I420_BT601_VIDEO;
                }
                return I420_BT601_FULL;
            }
            if (fullImageData == ColorRange.VIDEO) {
                return I420_BT709_VIDEO;
            }
            return I420_BT709_FULL;
        }
        return RGBA;
    }

    public static OEPImageFormat makeFromImageFormat(@NonNull Integer n) {
        Integer n2 = n;
        OEPImageFormat.doThrowIfUnsupportedImageFormat(n2);
        return n2 == 35 ? I420_BT601_FULL : RGBA;
    }

    private static void doThrowIfUnsupportedImageFormat(@NonNull Integer n) {
        if (n != 1 && n != 35) {
            throw new RuntimeException("Only PixelFormat.RGBA_8888(0x1) or ImageFormat.YUV_420_888(0x23) are supported! Image format = 0x" + Integer.toHexString(n));
        }
    }

    private static /* synthetic */ OEPImageFormat[] $values() {
        return new OEPImageFormat[]{RGBA, I420_BT601_FULL, I420_BT601_VIDEO, I420_BT709_FULL, I420_BT709_VIDEO};
    }

    static {
        int[] nArray = new int[1];
        int[] nArray2 = nArray;
        nArray[0] = 4;
        RGBA = new OEPImageFormat(true, 1, nArray2);
        int[] nArray3 = new int[3];
        nArray2 = nArray3;
        nArray3[0] = 1;
        nArray3[1] = 1;
        nArray3[2] = 1;
        I420_BT601_FULL = new OEPImageFormat(false, 3, nArray2);
        int[] nArray4 = new int[3];
        nArray2 = nArray4;
        nArray4[0] = 1;
        nArray4[1] = 1;
        nArray4[2] = 1;
        I420_BT601_VIDEO = new OEPImageFormat(false, 3, nArray2);
        int[] nArray5 = new int[3];
        nArray2 = nArray5;
        nArray5[0] = 1;
        nArray5[1] = 1;
        nArray5[2] = 1;
        I420_BT709_FULL = new OEPImageFormat(false, 3, nArray2);
        int[] nArray6 = new int[3];
        nArray2 = nArray6;
        nArray6[0] = 1;
        nArray6[1] = 1;
        nArray6[2] = 1;
        I420_BT709_VIDEO = new OEPImageFormat(false, 3, nArray2);
        $VALUES = OEPImageFormat.$values();
    }

    public boolean isRGBA() {
        return this.isRGBA;
    }

    public boolean isI420() {
        return this.isRGBA ^ true;
    }

    public int getPlanesCount() {
        return this.planesCount;
    }

    @NonNull
    public int[] getPixelStrides() {
        return this.pixelStrides;
    }
}

