/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.offscreen;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.Image;
import android.os.Handler;
import android.util.Size;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.banuba.sdk.effect_player.EffectPlayer;
import com.banuba.sdk.effect_player.JsCallback;
import com.banuba.sdk.offscreen.ImageOrientation;
import com.banuba.sdk.offscreen.ImageProcessedListener;
import com.banuba.sdk.offscreen.OEPImageFormat;
import com.banuba.sdk.offscreen.OffscreenEffectPlayerConfig;
import com.banuba.sdk.offscreen.OffscreenPlayerHandler;
import com.banuba.sdk.offscreen.OffscreenPlayerThread;
import com.banuba.sdk.offscreen.OffscreenSimpleConfig;
import com.banuba.sdk.offscreen.ReleaseCallback;
import com.banuba.sdk.types.FullImageData;

@Deprecated
@Keep
public class OffscreenEffectPlayer {
    private final OffscreenPlayerHandler mHandler;
    private final OffscreenSimpleConfig mConfig;

    public OffscreenEffectPlayer(@NonNull Context context, @NonNull OffscreenEffectPlayerConfig offscreenEffectPlayerConfig, @NonNull String string) {
        OffscreenEffectPlayer offscreenEffectPlayer = this;
        offscreenEffectPlayer.mConfig = offscreenEffectPlayerConfig.getSimpleConfig();
        offscreenEffectPlayer.mHandler = (OffscreenPlayerHandler)((Object)new OffscreenPlayerThread(context.getApplicationContext(), offscreenEffectPlayerConfig, string).startAndGetHandler());
    }

    public OffscreenEffectPlayer(@NonNull Context context, @NonNull EffectPlayer effectPlayer, @NonNull Size size, @NonNull OffscreenSimpleConfig offscreenSimpleConfig) {
        OffscreenEffectPlayer offscreenEffectPlayer = this;
        offscreenEffectPlayer.mConfig = offscreenSimpleConfig;
        offscreenEffectPlayer.mHandler = (OffscreenPlayerHandler)((Object)new OffscreenPlayerThread(context.getApplicationContext(), effectPlayer, size, offscreenSimpleConfig).startAndGetHandler());
    }

    public void setImageProcessListener(@Nullable ImageProcessedListener imageProcessedListener, @Nullable Handler handler) {
        this.mHandler.sendImage2ProcessListener(imageProcessedListener, handler);
    }

    public void setSurfaceTexture(@Nullable SurfaceTexture surfaceTexture) {
        this.mHandler.sendSurfaceTexture(surfaceTexture);
    }

    public void processImage(@NonNull Image image, @NonNull ImageOrientation imageOrientation) {
        Image image2 = image;
        this.processImage(image2, imageOrientation, OEPImageFormat.makeFromImageFormat(image2.getFormat()));
    }

    public void processImage(@NonNull Image image, @NonNull ImageOrientation imageOrientation, @NonNull OEPImageFormat oEPImageFormat) {
        Image image2 = image;
        long l = image2.getTimestamp();
        this.mHandler.sendImage2Process(image2, imageOrientation, oEPImageFormat, l);
    }

    public void processFullImageData(@NonNull FullImageData fullImageData, @Nullable ReleaseCallback releaseCallback, long l) {
        OffscreenEffectPlayer offscreenEffectPlayer = object;
        Object object = OEPImageFormat.makeFromFullImageData(fullImageData);
        offscreenEffectPlayer.processFullImageData(fullImageData, releaseCallback, (OEPImageFormat)((Object)object), l);
    }

    public void processFullImageData(@NonNull FullImageData fullImageData, @Nullable ReleaseCallback releaseCallback, @NonNull OEPImageFormat oEPImageFormat, long l) {
        this.mHandler.sendFullImage2Process(fullImageData, releaseCallback, oEPImageFormat, l, true);
    }

    @VisibleForTesting
    public void processFullImageDataNoSkip(@NonNull FullImageData fullImageData, @Nullable ReleaseCallback releaseCallback, long l) {
        FullImageData fullImageData2 = fullImageData;
        this.mHandler.sendFullImage2Process(fullImageData2, releaseCallback, OEPImageFormat.makeFromFullImageData(fullImageData2), l, false);
    }

    public void loadEffect(@NonNull String string) {
        this.mHandler.sendLoadEffect(string);
    }

    public void loadEffect(@NonNull String string, boolean bl) {
        this.mHandler.sendLoadEffect(string, bl);
    }

    public void unloadEffect() {
        this.mHandler.sendUnloadEffect();
    }

    public void callJsMethod(@NonNull String string, @NonNull String string2) {
        this.mHandler.sendCallJSMethod(string, string2);
    }

    public void evalJs(@NonNull String string, @Nullable JsCallback jsCallback) {
        this.mHandler.sendEvalJs(string, jsCallback);
    }

    public void release() {
        this.mHandler.sendShutdown();
    }

    public void playbackPlay() {
        this.mHandler.sendPlaybackPlay();
    }

    public void playbackPause() {
        this.mHandler.sendPlaybackPause();
    }

    public void playbackStop() {
        this.mHandler.sendPlaybackStop();
    }

    @NonNull
    public OffscreenSimpleConfig getConfig() {
        return this.mConfig;
    }

    public void enableAudio(boolean bl) {
        this.mHandler.sendEnableAudio(bl);
    }
}

