/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.offscreen;

import android.util.Size;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.effect_player.EffectPlayerConfiguration;
import com.banuba.sdk.effect_player.RealtimeProcessorMode;
import com.banuba.sdk.offscreen.BufferAllocator;
import com.banuba.sdk.offscreen.OffscreenSimpleConfig;

@Deprecated
@Keep
public class OffscreenEffectPlayerConfig {
    private final int fxWidth;
    private final int fxHeight;
    private final RealtimeProcessorMode realtimeProcessorMode;
    private final boolean useFutureFrameFilter;
    @Nullable
    private final BufferAllocator bufferAllocator;
    private final boolean debugSaveFrames;
    private final int debugSaveFramesDivider;

    private OffscreenEffectPlayerConfig(Builder builder) {
        this.fxWidth = builder.fxWidth;
        this.fxHeight = builder.fxHeight;
        this.bufferAllocator = builder.bufferAllocator;
        this.debugSaveFrames = builder.debugSaveFrames;
        this.debugSaveFramesDivider = builder.debugSaveFramesDivider;
        this.realtimeProcessorMode = builder.realtimeProcessorMode;
        this.useFutureFrameFilter = builder.useFutureFrameFilter;
    }

    public static Builder newBuilder(@NonNull Size size, @Nullable BufferAllocator bufferAllocator) {
        Size size2 = size;
        int n = size2.getWidth();
        return new Builder(n, size2.getHeight(), bufferAllocator);
    }

    int getVerticalPictureWidth() {
        return Math.min(this.fxWidth, this.fxHeight);
    }

    int getMinDimension() {
        return Math.min(this.fxWidth, this.fxHeight);
    }

    int getMaxDimension() {
        return Math.max(this.fxWidth, this.fxHeight);
    }

    int getVerticalPictureHeight() {
        return Math.max(this.fxWidth, this.fxHeight);
    }

    public RealtimeProcessorMode getRealtimeProcessorMode() {
        return this.realtimeProcessorMode;
    }

    public boolean getUseFutureFrameFilter() {
        return this.useFutureFrameFilter;
    }

    @NonNull
    EffectPlayerConfiguration getEffectPlayerConfig() {
        return EffectPlayerConfiguration.create((int)this.getVerticalPictureWidth(), (int)this.getVerticalPictureHeight());
    }

    @NonNull
    public OffscreenSimpleConfig getSimpleConfig() {
        return OffscreenSimpleConfig.newBuilder(this.bufferAllocator).setDebugSaveFrames(this.debugSaveFrames).setDebugSaveFramesDivider(this.debugSaveFramesDivider).setRealtimeProcessorMode(this.realtimeProcessorMode).setUseFutureFrameFilter(this.useFutureFrameFilter).build();
    }

    @Keep
    public static class Builder {
        private final int fxWidth;
        private final int fxHeight;
        @Nullable
        private final BufferAllocator bufferAllocator;
        private boolean debugSaveFrames = false;
        private int debugSaveFramesDivider = 100;
        private RealtimeProcessorMode realtimeProcessorMode = RealtimeProcessorMode.SYNC_WHEN_EFFECT_LOADED;
        private boolean useFutureFrameFilter = false;

        public Builder(int n, int n2, @Nullable BufferAllocator bufferAllocator) {
            this.fxWidth = n;
            this.fxHeight = n2;
            this.bufferAllocator = bufferAllocator;
        }

        @NonNull
        public Builder setDebugSaveFrames(boolean bl) {
            this.debugSaveFrames = bl;
            return this;
        }

        @NonNull
        public Builder setDebugSaveFramesDivider(int n) {
            this.debugSaveFramesDivider = n;
            return this;
        }

        @NonNull
        public Builder setRealtimeProcessorMode(RealtimeProcessorMode realtimeProcessorMode) {
            this.realtimeProcessorMode = realtimeProcessorMode;
            return this;
        }

        @NonNull
        public Builder setUseFutureFrameFilter(boolean bl) {
            this.useFutureFrameFilter = bl;
            return this;
        }

        @NonNull
        public OffscreenEffectPlayerConfig build() {
            return new OffscreenEffectPlayerConfig(this);
        }
    }
}

