/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.offscreen;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.Image;
import android.opengl.GLES20;
import android.os.Handler;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.Recycler;
import com.banuba.sdk.effect_player.CameraOrientation;
import com.banuba.sdk.effect_player.Effect;
import com.banuba.sdk.effect_player.EffectPlayer;
import com.banuba.sdk.effect_player.EffectPlayerConfiguration;
import com.banuba.sdk.effect_player.FrameProcessor;
import com.banuba.sdk.effect_player.JsCallback;
import com.banuba.sdk.effect_player.ProcessorConfiguration;
import com.banuba.sdk.effect_player.RealtimeProcessorMode;
import com.banuba.sdk.internal.BaseWorkThread;
import com.banuba.sdk.internal.gl.EglCore;
import com.banuba.sdk.internal.gl.EglSurfaceBase;
import com.banuba.sdk.internal.gl.GLFullRectTexture;
import com.banuba.sdk.internal.gl.OffscreenSurface;
import com.banuba.sdk.internal.gl.RenderBuffer;
import com.banuba.sdk.internal.gl.WindowSurface;
import com.banuba.sdk.internal.utils.OrientationHelper;
import com.banuba.sdk.manager.BanubaSdkManager;
import com.banuba.sdk.offscreen.BufferAllocator;
import com.banuba.sdk.offscreen.ImageDebugUtils;
import com.banuba.sdk.offscreen.ImageOrientation;
import com.banuba.sdk.offscreen.ImageProcessResult;
import com.banuba.sdk.offscreen.ImageProcessedListener;
import com.banuba.sdk.offscreen.ImageReleaserImpl;
import com.banuba.sdk.offscreen.OEPImageFormat;
import com.banuba.sdk.offscreen.OffscreenEffectPlayerConfig;
import com.banuba.sdk.offscreen.OffscreenPlayerHandler;
import com.banuba.sdk.offscreen.OffscreenSimpleConfig;
import com.banuba.sdk.offscreen.ReleaseCallback;
import com.banuba.sdk.offscreen.SingleRenderBufferAllocator;
import com.banuba.sdk.offscreen.YUVConverterMod;
import com.banuba.sdk.types.FrameData;
import com.banuba.sdk.types.FullImageData;
import com.banuba.sdk.utils.ImageReleaser;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Objects;

@Deprecated
public class OffscreenPlayerThread
extends BaseWorkThread<OffscreenPlayerHandler> {
    private static final String TAG = "OffscreenPlayerThread";
    private static final float[] MATRIX_V_FLIP = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f};
    private final Context mContext;
    private final int mVerticalPictureWidth;
    private final int mVerticalPictureHeight;
    @NonNull
    private final OffscreenSimpleConfig mConfig;
    private final int mMinDimension;
    private final int mMaxDimension;
    @Nullable
    private final BufferAllocator mAllocator;
    private final SingleRenderBufferAllocator mPlayerRenderBufferAllocator;
    private final SingleRenderBufferAllocator mConvertRenderBufferAllocator;
    private EglCore mEglCore;
    private EffectPlayer mEffectPlayer;
    private FrameProcessor mFrameProcessor;
    private ImageProcessedListener mProcessListener;
    private Handler mProcessHandler;
    private Effect mEffect;
    private YUVConverterMod mYUVConverter;
    private int mSavedImageOrientation;
    private int mFrameNumber;
    private int mSavedEffectWidth;
    private int mSavedEffectHeight;
    private OffscreenSurface mOffscreenSurface;
    private GLFullRectTexture mTextureDrawer;
    private WindowSurface mExternalSurface;

    public OffscreenPlayerThread(@NonNull Context context, @NonNull OffscreenEffectPlayerConfig offscreenEffectPlayerConfig, @NonNull String string) {
        OffscreenPlayerThread offscreenPlayerThread = offscreenPlayerThread2;
        super("OffscreenEffectPlayerThread");
        offscreenPlayerThread2.mPlayerRenderBufferAllocator = new SingleRenderBufferAllocator();
        offscreenPlayerThread2.mConvertRenderBufferAllocator = new SingleRenderBufferAllocator();
        offscreenPlayerThread2.mSavedImageOrientation = -1;
        offscreenPlayerThread2.mContext = context;
        offscreenPlayerThread2.mConfig = offscreenEffectPlayerConfig.getSimpleConfig();
        offscreenPlayerThread2.mAllocator = offscreenEffectPlayerConfig.getSimpleConfig().getBufferAllocator();
        offscreenPlayerThread2.mVerticalPictureWidth = offscreenEffectPlayerConfig.getVerticalPictureWidth();
        offscreenPlayerThread2.mVerticalPictureHeight = offscreenEffectPlayerConfig.getVerticalPictureHeight();
        offscreenPlayerThread2.mMinDimension = offscreenEffectPlayerConfig.getMinDimension();
        offscreenPlayerThread2.mMaxDimension = offscreenEffectPlayerConfig.getMaxDimension();
        BanubaSdkManager.initialize(context, string, new String[0]);
        offscreenPlayerThread2.mEffectPlayer = Objects.requireNonNull(EffectPlayer.create((EffectPlayerConfiguration)offscreenEffectPlayerConfig.getEffectPlayerConfig()));
        OffscreenPlayerThread offscreenPlayerThread2 = ProcessorConfiguration.create();
        offscreenPlayerThread2.setUseFutureFilter(offscreenEffectPlayerConfig.getUseFutureFrameFilter());
        offscreenPlayerThread2 = Objects.requireNonNull(FrameProcessor.createRealtimeProcessor((RealtimeProcessorMode)offscreenEffectPlayerConfig.getRealtimeProcessorMode(), (ProcessorConfiguration)offscreenPlayerThread2));
        offscreenPlayerThread.mFrameProcessor = offscreenPlayerThread2;
        offscreenPlayerThread.mEffectPlayer.setFrameProcessor((FrameProcessor)offscreenPlayerThread2);
    }

    public OffscreenPlayerThread(@NonNull Context context, @NonNull EffectPlayer effectPlayer, @NonNull Size size, @NonNull OffscreenSimpleConfig offscreenSimpleConfig) {
        OffscreenPlayerThread offscreenPlayerThread = offscreenPlayerThread5;
        OffscreenPlayerThread offscreenPlayerThread2 = offscreenPlayerThread5;
        OffscreenPlayerThread offscreenPlayerThread3 = offscreenPlayerThread5;
        OffscreenPlayerThread offscreenPlayerThread4 = offscreenPlayerThread5;
        super("OffscreenEffectPlayerThread");
        offscreenPlayerThread5.mPlayerRenderBufferAllocator = new SingleRenderBufferAllocator();
        offscreenPlayerThread5.mConvertRenderBufferAllocator = new SingleRenderBufferAllocator();
        offscreenPlayerThread5.mSavedImageOrientation = -1;
        offscreenPlayerThread5.mContext = context;
        offscreenPlayerThread5.mEffectPlayer = effectPlayer;
        OffscreenPlayerThread offscreenPlayerThread5 = ProcessorConfiguration.create();
        offscreenPlayerThread5.setUseFutureFilter(offscreenSimpleConfig.getUseFutureFrameFilter());
        offscreenPlayerThread5 = Objects.requireNonNull(FrameProcessor.createRealtimeProcessor((RealtimeProcessorMode)offscreenSimpleConfig.getRealtimeProcessorMode(), (ProcessorConfiguration)offscreenPlayerThread5));
        offscreenPlayerThread4.mFrameProcessor = offscreenPlayerThread5;
        offscreenPlayerThread4.mEffectPlayer.setFrameProcessor((FrameProcessor)offscreenPlayerThread5);
        offscreenPlayerThread3.mConfig = offscreenSimpleConfig;
        offscreenPlayerThread2.mAllocator = offscreenSimpleConfig.getBufferAllocator();
        int n = Math.min(size.getWidth(), size.getHeight());
        int n2 = Math.max(size.getWidth(), size.getHeight());
        offscreenPlayerThread.mVerticalPictureWidth = n;
        offscreenPlayerThread.mVerticalPictureHeight = n2;
        offscreenPlayerThread.mMinDimension = n;
        offscreenPlayerThread.mMaxDimension = n2;
    }

    private void processFrame(@NonNull EffectPlayer object, int n, int n2, int n3, int n4, @NonNull OEPImageFormat oEPImageFormat, long l, @NonNull ImageOrientation imageOrientation) {
        OffscreenPlayerThread offscreenPlayerThread = this;
        offscreenPlayerThread.mOffscreenSurface.makeCurrent();
        object = offscreenPlayerThread.mPlayerRenderBufferAllocator.getRenderBuffer(n, n2);
        GLES20.glBindFramebuffer((int)36160, (int)((RenderBuffer)object).getFrameBufferId());
        GLES20.glViewport((int)0, (int)0, (int)n, (int)n2);
        GLES20.glClear((int)16384);
        Object object2 = offscreenPlayerThread.mFrameProcessor.pop();
        if (object2.getFrameData() != null) {
            if (this.mEffectPlayer.drawWithExternalFrameData(object2.getFrameData()) >= 0L) {
                OffscreenPlayerThread offscreenPlayerThread2 = this;
                offscreenPlayerThread2.debugSaveEffectPlayerFrame(imageOrientation, n, n2);
                object2 = offscreenPlayerThread2.mExternalSurface;
                if (object2 != null) {
                    OffscreenPlayerThread offscreenPlayerThread3 = this;
                    ((EglSurfaceBase)object2).makeCurrent();
                    GLES20.glBindFramebuffer((int)36160, (int)0);
                    int n5 = n = Math.max(n, n2);
                    GLES20.glViewport((int)0, (int)0, (int)n5, (int)n5);
                    GLES20.glClear((int)16384);
                    this.mTextureDrawer.draw(((RenderBuffer)object).getTextureId(), MATRIX_V_FLIP);
                    long l2 = l & 0xFFFFFFFFFFFFFFFCL | (long)imageOrientation.getRotationIndex();
                    offscreenPlayerThread3.mExternalSurface.setPresentationTime(l2);
                    offscreenPlayerThread3.mExternalSurface.swapBuffers();
                }
                Handler handler = this.mProcessHandler;
                ImageProcessedListener imageProcessedListener = this.mProcessListener;
                if (handler != null && imageProcessedListener != null) {
                    if (oEPImageFormat.isI420()) {
                        int n6 = n3 * 2 * n4;
                        BufferAllocator bufferAllocator = this.mAllocator;
                        ByteBuffer byteBuffer = bufferAllocator != null ? bufferAllocator.allocateBuffer(n6) : ByteBuffer.allocateDirect(n6);
                        ImageOrientation imageOrientation2 = imageOrientation;
                        int n7 = ((RenderBuffer)object).getTextureId();
                        object = imageOrientation2.getConvertMatrix();
                        int n8 = imageOrientation2.getConverterMode();
                        this.getYUVConverter(n3, n4).convert(n7, byteBuffer, (float[])object, n8, oEPImageFormat);
                        this.debugSaveResultFrame(imageOrientation, oEPImageFormat, n3, n4, byteBuffer);
                        handler.post(() -> {
                            ImageProcessResult imageProcessResult;
                            ImageProcessedListener imageProcessedListener = imageProcessedListener;
                            imageProcessedListener = imageProcessResult;
                            imageProcessResult = new ImageProcessResult(n3, n4, oEPImageFormat, l, imageOrientation, byteBuffer);
                            imageProcessedListener.onImageProcessed((ImageProcessResult)((Object)imageProcessedListener));
                        });
                    } else if (oEPImageFormat.isRGBA()) {
                        int n9 = n3 * 4 * n4;
                        BufferAllocator bufferAllocator = this.mAllocator;
                        ByteBuffer byteBuffer = bufferAllocator != null ? bufferAllocator.allocateBuffer(n9) : ByteBuffer.allocateDirect(n9);
                        OffscreenPlayerThread offscreenPlayerThread4 = this;
                        GLES20.glBindFramebuffer((int)36160, (int)offscreenPlayerThread4.mConvertRenderBufferAllocator.getRenderBuffer(n3, n4).getFrameBufferId());
                        GLES20.glViewport((int)0, (int)0, (int)n3, (int)n4);
                        GLES20.glClear((int)16384);
                        int n10 = ((RenderBuffer)object).getTextureId();
                        offscreenPlayerThread4.mTextureDrawer.draw(n10, imageOrientation.getConvertMatrix());
                        this.debugSaveResultFrame(imageOrientation, oEPImageFormat, n3, n4, byteBuffer);
                        GLES20.glReadPixels((int)0, (int)0, (int)n3, (int)n4, (int)6408, (int)5121, (Buffer)byteBuffer);
                        byteBuffer.rewind();
                        handler.post(() -> {
                            ImageProcessResult imageProcessResult;
                            ImageProcessedListener imageProcessedListener = imageProcessedListener;
                            imageProcessedListener = imageProcessResult;
                            imageProcessResult = new ImageProcessResult(n3, n4, oEPImageFormat, l, imageOrientation, byteBuffer);
                            imageProcessedListener.onImageProcessed((ImageProcessResult)((Object)imageProcessedListener));
                        });
                    }
                }
                GLES20.glBindFramebuffer((int)36160, (int)0);
                return;
            }
            throw new RuntimeException("Frame processing error: couldn't draw processed frame data");
        }
        throw new RuntimeException("Frame processing error: frame processor error");
    }

    private int getAngleValue(@NonNull CameraOrientation cameraOrientation) {
        int n = 1.$SwitchMap$com$banuba$sdk$effect_player$CameraOrientation[cameraOrientation.ordinal()];
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    return 0;
                }
                return 270;
            }
            return 180;
        }
        return 90;
    }

    private void debugSaveResultFrame(@NonNull ImageOrientation imageOrientation, OEPImageFormat oEPImageFormat, int n, int n2, ByteBuffer byteBuffer) {
        if (this.mConfig.isSaveFrame(this.mFrameNumber)) {
            int n3 = this.mFrameNumber;
            ImageDebugUtils.saveImageDetailed(this.mContext, oEPImageFormat, byteBuffer, n, n2, n, "result.jpg", n3, imageOrientation);
        }
    }

    private void debugSaveEffectPlayerFrame(@NonNull ImageOrientation imageOrientation, int n, int n2) {
        if (object.mConfig.isSaveFrame(object.mFrameNumber)) {
            int n3 = n * n2 * 4;
            Buffer buffer = ByteBuffer.allocateDirect(n3);
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n3);
            GLES20.glReadPixels((int)0, (int)0, (int)n, (int)n2, (int)6408, (int)5121, (Buffer)buffer);
            buffer = ((ByteBuffer)buffer).order(ByteOrder.nativeOrder()).asIntBuffer();
            IntBuffer intBuffer = byteBuffer.order(ByteOrder.nativeOrder()).asIntBuffer();
            for (int i = n2 - 1; i >= 0; --i) {
                ((IntBuffer)buffer).position(n * i);
                for (int j = 0; j < n; ++j) {
                    intBuffer.put(((IntBuffer)buffer).get());
                }
            }
            byteBuffer.rewind();
            OffscreenPlayerThread offscreenPlayerThread = object;
            Object object = OEPImageFormat.RGBA;
            int n4 = offscreenPlayerThread.mFrameNumber;
            ImageDebugUtils.saveImageDetailed(object.mContext, (OEPImageFormat)((Object)object), byteBuffer, n, n2, n, "player.jpg", n4, imageOrientation);
        }
    }

    @NonNull
    private YUVConverterMod getYUVConverter(int n, int n2) {
        YUVConverterMod yUVConverterMod = this.mYUVConverter;
        if (yUVConverterMod == null) {
            YUVConverterMod yUVConverterMod2;
            yUVConverterMod = yUVConverterMod2;
            yUVConverterMod2 = new YUVConverterMod(n, n2);
            this.mYUVConverter = yUVConverterMod;
        } else if (yUVConverterMod.getWidth() != n || this.mYUVConverter.getHeight() != n2) {
            this.mYUVConverter.clear();
            this.mYUVConverter = new YUVConverterMod(n, n2);
        }
        return this.mYUVConverter;
    }

    @Override
    @NonNull
    protected OffscreenPlayerHandler constructHandler() {
        return new OffscreenPlayerHandler(this);
    }

    @Override
    protected void preRunInit() {
        EglCore eglCore;
        OffscreenPlayerThread offscreenPlayerThread = this;
        EglCore eglCore2 = eglCore;
        offscreenPlayerThread.mEglCore = new EglCore(null, 2);
        this.mOffscreenSurface = new OffscreenSurface(eglCore2, 16, 16);
        this.mOffscreenSurface.makeCurrent();
        OffscreenPlayerThread offscreenPlayerThread2 = this;
        int n = offscreenPlayerThread2.mVerticalPictureWidth;
        offscreenPlayerThread.mEffectPlayer.surfaceCreated(n, offscreenPlayerThread2.mVerticalPictureHeight);
        offscreenPlayerThread.mEffectPlayer.playbackPlay();
        offscreenPlayerThread.mTextureDrawer = new GLFullRectTexture(false);
    }

    @Override
    protected void postRunClear() {
        Object object = this.mEffectPlayer;
        if (object != null) {
            object.surfaceDestroyed();
        }
        OffscreenPlayerThread offscreenPlayerThread = this;
        offscreenPlayerThread.mEffectPlayer = (EffectPlayer)Recycler.recycle((Object)offscreenPlayerThread.mEffectPlayer);
        offscreenPlayerThread.mConvertRenderBufferAllocator.clear();
        offscreenPlayerThread.mPlayerRenderBufferAllocator.clear();
        object = offscreenPlayerThread.mYUVConverter;
        if (object != null) {
            ((YUVConverterMod)object).clear();
        }
        OffscreenPlayerThread offscreenPlayerThread2 = this;
        offscreenPlayerThread2.mEglCore.makeNothingCurrent();
        offscreenPlayerThread2.mEglCore.release();
    }

    public void handleLoadEffect(@NonNull String string) {
        EffectPlayer effectPlayer = this.mEffectPlayer;
        if (effectPlayer != null && (effectPlayer = effectPlayer.effectManager()) != null) {
            this.mEffect = effectPlayer.loadAsync(string);
        }
    }

    public void handleLoadEffect(@NonNull String string, boolean bl) {
        EffectPlayer effectPlayer = this.mEffectPlayer;
        if (effectPlayer != null && (effectPlayer = effectPlayer.effectManager()) != null) {
            string = bl ? effectPlayer.loadAsync(string) : effectPlayer.load(string);
            this.mEffect = string;
        }
    }

    public void handleImageProcess(@NonNull Image size, @NonNull ImageOrientation imageOrientation, @NonNull OEPImageFormat oEPImageFormat, long l) {
        Size size2;
        FullImageData fullImageData;
        Object object;
        int n;
        int n2;
        EffectPlayer effectPlayer = this.mEffectPlayer;
        if (effectPlayer == null) {
            return;
        }
        Size size3 = size;
        int n3 = size3.getWidth();
        int n4 = size3.getHeight();
        if (imageOrientation.getImageOrientationAngle() % 180 == 0) {
            OffscreenPlayerThread offscreenPlayerThread = this;
            n2 = offscreenPlayerThread.mMaxDimension;
            n = offscreenPlayerThread.mMinDimension;
        } else {
            OffscreenPlayerThread offscreenPlayerThread = this;
            n2 = offscreenPlayerThread.mMinDimension;
            n = offscreenPlayerThread.mMaxDimension;
        }
        if (this.mSavedImageOrientation != imageOrientation.getImageOrientationAngle()) {
            EffectPlayer effectPlayer2 = effectPlayer;
            effectPlayer2.surfaceChanged(n2, n);
            object = effectPlayer2.effectManager();
            if (object != null) {
                object.setEffectSize(n2, n);
            }
            effectPlayer.playbackPlay();
            this.mSavedImageOrientation = imageOrientation.getImageOrientationAngle();
        }
        OffscreenPlayerThread offscreenPlayerThread = this;
        EffectPlayer effectPlayer3 = effectPlayer;
        Size size4 = size;
        Size size5 = size;
        ImageOrientation imageOrientation2 = imageOrientation;
        int n5 = imageOrientation2.getAccelerometerDeviceOrientation();
        FullImageData.Orientation orientation = OrientationHelper.getOrientation(imageOrientation.getImageOrientationAngle(), n5, imageOrientation2.isRequireMirroring());
        size5.getFormat();
        size = size5.getPlanes();
        effectPlayer = fullImageData;
        Size size6 = size;
        size = size2;
        size2 = new Size(n3, n4);
        object = size6[0].getBuffer();
        ByteBuffer byteBuffer = size6[1].getBuffer();
        ByteBuffer byteBuffer2 = size6[2].getBuffer();
        int n6 = size6[0].getRowStride();
        int n7 = size6[1].getRowStride();
        int n8 = size6[2].getRowStride();
        int n9 = size6[0].getPixelStride();
        int n10 = size6[1].getPixelStride();
        int n11 = size6[2].getPixelStride();
        fullImageData = new FullImageData(size, (Buffer)object, (Buffer)byteBuffer, (Buffer)byteBuffer2, n6, n7, n8, n9, n10, n11, orientation);
        orientation = FrameData.create();
        orientation.addFullImg((FullImageData)effectPlayer);
        orientation.addFrameNumber(l);
        this.mFrameProcessor.push((FrameData)orientation);
        size4.close();
        offscreenPlayerThread.processFrame(effectPlayer3, n2, n, n3, n4, oEPImageFormat, l, imageOrientation);
        ++offscreenPlayerThread.mFrameNumber;
    }

    public void handleFullImageData(@NonNull FullImageData fullImageData, @Nullable ReleaseCallback releaseCallback, @NonNull OEPImageFormat oEPImageFormat, long l) {
        EffectPlayer effectPlayer = ((OffscreenPlayerThread)object2).mEffectPlayer;
        if (effectPlayer != null) {
            Object object;
            int n = fullImageData.getOrientation().getCameraOrientation() != CameraOrientation.DEG_90 && fullImageData.getOrientation().getCameraOrientation() != CameraOrientation.DEG_270 ? 0 : 1;
            int n2 = ((OffscreenPlayerThread)object2).getAngleValue(fullImageData.getOrientation().getCameraOrientation());
            Size size = fullImageData.getSize();
            int n3 = n != 0 ? size.getHeight() : size.getWidth();
            n = n != 0 ? size.getWidth() : size.getHeight();
            if (((OffscreenPlayerThread)object2).mSavedEffectWidth != n3 || ((OffscreenPlayerThread)object2).mSavedEffectHeight != n) {
                object = effectPlayer.effectManager();
                if (object != null) {
                    object.setEffectSize(n3, n);
                }
                EffectPlayer effectPlayer2 = effectPlayer;
                OffscreenPlayerThread offscreenPlayerThread = object2;
                offscreenPlayerThread.mSavedEffectWidth = n3;
                offscreenPlayerThread.mSavedEffectHeight = n;
                effectPlayer2.surfaceChanged(n3, n);
                effectPlayer2.playbackPlay();
            }
            if (releaseCallback != null) {
                ImageReleaserImpl imageReleaserImpl;
                object = imageReleaserImpl;
                imageReleaserImpl = new ImageReleaserImpl(releaseCallback);
                fullImageData.setImageReleaser((ImageReleaser)object);
            }
            OffscreenPlayerThread offscreenPlayerThread = object2;
            Size size2 = size;
            OffscreenPlayerThread offscreenPlayerThread2 = object2;
            Object object2 = FrameData.create();
            object2.addFullImg(fullImageData);
            object2.addFrameNumber(l);
            offscreenPlayerThread2.mFrameProcessor.push((FrameData)object2);
            object2 = ImageOrientation.getForBufferFrame(n2);
            int n4 = size2.getWidth();
            int n5 = size2.getHeight();
            offscreenPlayerThread.processFrame(effectPlayer, n3, n, n4, n5, oEPImageFormat, l, (ImageOrientation)object2);
            ++offscreenPlayerThread.mFrameNumber;
        }
    }

    public void handleUnloadEffect() {
        EffectPlayer effectPlayer = this.mEffectPlayer;
        if (effectPlayer != null && this.mEffect != null && (effectPlayer = effectPlayer.effectManager()) != null) {
            effectPlayer.unload(this.mEffect);
        }
    }

    public void handleCallJsMethod(@NonNull String string, @NonNull String string2) {
        OffscreenPlayerThread offscreenPlayerThread = offscreenPlayerThread.mEffect;
        if (offscreenPlayerThread != null) {
            offscreenPlayerThread.callJsMethod(string, string2);
        }
    }

    public void handleEvalJs(@NonNull String string, @Nullable JsCallback jsCallback) {
        OffscreenPlayerThread offscreenPlayerThread = offscreenPlayerThread.mEffect;
        if (offscreenPlayerThread != null) {
            offscreenPlayerThread.evalJs(string, jsCallback);
        }
    }

    public void handleSetListener(@Nullable ImageProcessedListener imageProcessedListener, @Nullable Handler handler) {
        OffscreenPlayerThread offscreenPlayerThread = this;
        offscreenPlayerThread.mProcessListener = imageProcessedListener;
        offscreenPlayerThread.mProcessHandler = handler;
    }

    public void handleSetSurface(@Nullable SurfaceTexture surfaceTexture) {
        if (surfaceTexture != null) {
            int n = this.mMaxDimension;
            surfaceTexture.setDefaultBufferSize(n, n);
            this.mExternalSurface = new WindowSurface(this.mEglCore, surfaceTexture);
        } else {
            this.mExternalSurface.release();
            this.mExternalSurface = null;
        }
    }

    public void handlePlaybackPlay() {
        this.mEffectPlayer.playbackPlay();
    }

    public void handlePlaybackPause() {
        this.mEffectPlayer.playbackPause();
    }

    public void handlePlaybackStop() {
        this.mEffectPlayer.playbackStop();
    }

    public void enableAudio(boolean bl) {
        OffscreenPlayerThread offscreenPlayerThread = offscreenPlayerThread.mEffectPlayer.effectManager();
        float f = bl ? 1.0f : 0.0f;
        offscreenPlayerThread.setEffectVolume(f);
    }
}

