/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.offscreen;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.effect_player.RealtimeProcessorMode;
import com.banuba.sdk.offscreen.BufferAllocator;

@Deprecated
@Keep
public final class OffscreenSimpleConfig {
    @Nullable
    private final BufferAllocator bufferAllocator;
    private final boolean debugSaveFrames;
    private final int debugSaveFramesDivider;
    private final RealtimeProcessorMode realtimeProcessorMode;
    private final boolean useFutureFrameFilter;

    private OffscreenSimpleConfig(Builder builder) {
        this.bufferAllocator = builder.bufferAllocator;
        this.debugSaveFrames = builder.debugSaveFrames;
        this.debugSaveFramesDivider = builder.debugSaveFramesDivider;
        this.realtimeProcessorMode = builder.realtimeProcessorMode;
        this.useFutureFrameFilter = builder.useFutureFrameFilter;
    }

    public static Builder newBuilder(@Nullable BufferAllocator bufferAllocator) {
        return new Builder(bufferAllocator);
    }

    @Nullable
    public BufferAllocator getBufferAllocator() {
        return this.bufferAllocator;
    }

    public RealtimeProcessorMode getRealtimeProcessorMode() {
        return this.realtimeProcessorMode;
    }

    public boolean getUseFutureFrameFilter() {
        return this.useFutureFrameFilter;
    }

    public boolean isSaveFrame(int n) {
        if (this.debugSaveFrames) {
            return n % this.debugSaveFramesDivider == 0;
        }
        return false;
    }

    @Keep
    public static class Builder {
        @Nullable
        private final BufferAllocator bufferAllocator;
        private boolean debugSaveFrames = false;
        private int debugSaveFramesDivider = 100;
        private RealtimeProcessorMode realtimeProcessorMode = RealtimeProcessorMode.SYNC_WHEN_EFFECT_LOADED;
        private boolean useFutureFrameFilter = false;

        private Builder(@Nullable BufferAllocator bufferAllocator) {
            this.bufferAllocator = bufferAllocator;
        }

        @NonNull
        public Builder setDebugSaveFrames(boolean bl) {
            this.debugSaveFrames = bl;
            return this;
        }

        @NonNull
        public Builder setDebugSaveFramesDivider(int n) {
            this.debugSaveFramesDivider = n;
            return this;
        }

        @NonNull
        public Builder setRealtimeProcessorMode(RealtimeProcessorMode realtimeProcessorMode) {
            this.realtimeProcessorMode = realtimeProcessorMode;
            return this;
        }

        @NonNull
        public Builder setUseFutureFrameFilter(boolean bl) {
            this.useFutureFrameFilter = bl;
            return this;
        }

        @NonNull
        public OffscreenSimpleConfig build() {
            return new OffscreenSimpleConfig(this);
        }
    }
}

