/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.offscreen;

import android.opengl.GLES20;
import android.util.Log;
import android.util.Size;
import androidx.annotation.NonNull;
import com.banuba.sdk.internal.gl.GlUtils;
import com.banuba.sdk.internal.gl.RenderBuffer;
import com.banuba.sdk.offscreen.OEPImageFormat;
import java.nio.Buffer;
import java.nio.ByteBuffer;

@Deprecated
public class YUVConverterMod {
    public static final int CONV_MODE_STEP_X = 0;
    public static final int CONV_MODE_STEP_NEG_X = 1;
    public static final int CONV_MODE_STEP_Y = 2;
    public static final int CONV_MODE_STEP_NEG_Y = 3;
    private static final float[] RECTANGLE_VERTICES;
    private static final float[] RECTANGLE_UV_COORDS;
    private static final String SHADER_VEC_PROG = "uniform mat4 uTexMatrix;\nattribute vec4 a_position;\nattribute vec2 a_texCoord;\nvarying vec2 tc;\nvoid main() {\n  gl_Position = a_position;\n  vec4 texCoord = vec4(a_texCoord, 0.0, 1.0);\n  tc = (uTexMatrix * texCoord).xy;\n}\n";
    private static final String SHADER_FRAG_PROG = "precision highp float;\nuniform vec2 xUnit;\nvarying vec2 tc;\nuniform vec4 coeffs;\nuniform sampler2D s_baseMap;\nvoid main()  {\n  gl_FragColor.r = coeffs.a + dot(coeffs.rgb, texture2D(s_baseMap, tc - 1.5 * xUnit).rgb);\n  gl_FragColor.g = coeffs.a + dot(coeffs.rgb, texture2D(s_baseMap, tc - 0.5 * xUnit).rgb);\n  gl_FragColor.b = coeffs.a + dot(coeffs.rgb, texture2D(s_baseMap, tc + 0.5 * xUnit).rgb);\n  gl_FragColor.a = coeffs.a + dot(coeffs.rgb, texture2D(s_baseMap, tc + 1.5 * xUnit).rgb);\n}\n";
    private static final float[] MAT_CVT_TO_BT601_VIDEO_RANGE;
    private static final float[] MAT_CVT_TO_BT601_FULL_RANGE;
    private static final float[] MAT_CVT_TO_BT709_VIDEO_RANGE;
    private static final float[] MAT_CVT_TO_BT709_FULL_RANGE;
    private static final int offsetToYPlaneCoeffs = 0;
    private static final int offsetToUPlaneCoeffs = 4;
    private static final int offsetToVPlaneCoeffs = 8;
    static final /* synthetic */ boolean $assertionsDisabled;
    private final RenderBuffer mFrameBufferYUV;
    private final int mVertexCount;
    private final Size mFrameSizeYUV;
    private final Size mPlaneSizeY;
    private final Size mPlaneSizeUV;
    private final Size mOutputFrameSize;
    private final int[] mVBO;
    private final int mProgramHandle;
    private final int mAttributePosition;
    private final int mAttributeTextureCoord;
    private final int mUniformSampler;
    private final int mUniformTextureMatrix;
    private final int mTextureLocation;
    private final int mCoeffsLocation;

    public YUVConverterMod(int n, int n2) {
        Size size;
        YUVConverterMod yUVConverterMod = this;
        int n3 = n + 7 & 0xFFFFFFF8;
        Size size2 = size;
        int n4 = n2;
        yUVConverterMod.mFrameSizeYUV = new Size(n3 /= 4, n4 + n4);
        yUVConverterMod.mPlaneSizeY = new Size(n / 4, n2);
        n3 = n / 8;
        yUVConverterMod.mPlaneSizeUV = new Size(n3, n2 / 2);
        yUVConverterMod.mFrameBufferYUV = RenderBuffer.prepareFrameBuffer(size2.getWidth(), size2.getHeight());
        yUVConverterMod.mOutputFrameSize = new Size(n, n2);
        float[] fArray = RECTANGLE_VERTICES;
        yUVConverterMod.mVBO = GlUtils.setupVertexTextureBuffers(RECTANGLE_VERTICES, RECTANGLE_UV_COORDS);
        this.mProgramHandle = n2 = GlUtils.loadProgram(SHADER_VEC_PROG, SHADER_FRAG_PROG);
        this.mAttributePosition = GLES20.glGetAttribLocation((int)n2, (String)"a_position");
        this.mAttributeTextureCoord = GLES20.glGetAttribLocation((int)n2, (String)"a_texCoord");
        this.mUniformTextureMatrix = GLES20.glGetUniformLocation((int)n2, (String)"uTexMatrix");
        this.mUniformSampler = GLES20.glGetUniformLocation((int)n2, (String)"s_baseMap");
        this.mTextureLocation = GLES20.glGetUniformLocation((int)n2, (String)"xUnit");
        yUVConverterMod.mCoeffsLocation = GLES20.glGetUniformLocation((int)n2, (String)"coeffs");
        yUVConverterMod.mVertexCount = fArray.length / 3;
        int n5 = GLES20.glGetError();
        if (n5 != 0) {
            Log.w((String)"YUVConverter.create", (String)("OpenGL error code: " + n5));
        }
    }

    private float[] getConvertionMatrix(@NonNull OEPImageFormat oEPImageFormat) {
        if (!$assertionsDisabled && !oEPImageFormat.isI420()) {
            throw new AssertionError((Object)"YUVConverterMod only supports i420 formats");
        }
        switch (1.$SwitchMap$com$banuba$sdk$offscreen$OEPImageFormat[oEPImageFormat.ordinal()]) {
            default: {
                return null;
            }
            case 4: {
                return MAT_CVT_TO_BT709_FULL_RANGE;
            }
            case 3: {
                return MAT_CVT_TO_BT709_VIDEO_RANGE;
            }
            case 2: {
                return MAT_CVT_TO_BT601_FULL_RANGE;
            }
            case 1: 
        }
        return MAT_CVT_TO_BT601_VIDEO_RANGE;
    }

    static {
        $assertionsDisabled = YUVConverterMod.class.desiredAssertionStatus() ^ true;
        RECTANGLE_VERTICES = new float[]{-1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f};
        RECTANGLE_UV_COORDS = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
        MAT_CVT_TO_BT601_VIDEO_RANGE = new float[]{0.256788f, 0.504129f, 0.0979059f, 0.0627451f, -0.148223f, -0.290993f, 0.439216f, 0.501961f, 0.439216f, -0.367788f, -0.0714274f, 0.501961f};
        MAT_CVT_TO_BT601_FULL_RANGE = new float[]{0.299f, 0.587f, 0.114f, 0.0f, -0.16873589f, -0.3312641f, 0.5f, 0.5f, 0.5f, -0.41868758f, -0.08131241f, 0.5f};
        MAT_CVT_TO_BT709_VIDEO_RANGE = new float[]{0.18258588f, 0.6142306f, 0.06200706f, 0.0627451f, -0.10064373f, -0.33857197f, 0.4392157f, 0.5019608f, 0.4392157f, -0.39894217f, -0.040273525f, 0.5019608f};
        MAT_CVT_TO_BT709_FULL_RANGE = new float[]{0.2126f, 0.7152f, 0.0722f, 0.0f, -0.11457211f, -0.3854279f, 0.5f, 0.5019608f, 0.5f, -0.4541529f, -0.04584709f, 0.5019608f};
    }

    public void convert(int n, @NonNull ByteBuffer byteBuffer, @NonNull float[] fArray, int n2, @NonNull OEPImageFormat object) {
        object = this.getConvertionMatrix((OEPImageFormat)((Object)object));
        if (!$assertionsDisabled && object == null) {
            throw new AssertionError();
        }
        GLES20.glUseProgram((int)this.mProgramHandle);
        GLES20.glDisable((int)3042);
        GLES20.glBindBuffer((int)34962, (int)this.mVBO[0]);
        GLES20.glVertexAttribPointer((int)this.mAttributePosition, (int)3, (int)5126, (boolean)false, (int)12, (int)0);
        GLES20.glEnableVertexAttribArray((int)this.mAttributePosition);
        GLES20.glBindBuffer((int)34962, (int)this.mVBO[1]);
        GLES20.glVertexAttribPointer((int)this.mAttributeTextureCoord, (int)2, (int)5126, (boolean)false, (int)8, (int)0);
        GLES20.glEnableVertexAttribArray((int)this.mAttributeTextureCoord);
        GLES20.glUniformMatrix4fv((int)this.mUniformTextureMatrix, (int)1, (boolean)false, (float[])fArray, (int)0);
        GlUtils.setupSampler(0, this.mUniformSampler, n, false);
        GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBufferYUV.getFrameBufferId());
        float f = 0.0f;
        float f2 = 0.0f;
        if (n2 == 0) {
            f = 1.0f / (float)this.mOutputFrameSize.getWidth();
        } else if (n2 == 1) {
            f = -1.0f / (float)this.mOutputFrameSize.getWidth();
        } else if (n2 == 2) {
            f2 = 1.0f / (float)this.mOutputFrameSize.getWidth();
        } else if (n2 == 3) {
            f2 = -1.0f / (float)this.mOutputFrameSize.getWidth();
        }
        GLES20.glUniform4fv((int)this.mCoeffsLocation, (int)1, (float[])object, (int)0);
        GLES20.glUniform2f((int)this.mTextureLocation, (float)f, (float)f2);
        int n3 = this.mPlaneSizeY.getWidth();
        int n4 = this.mPlaneSizeY.getHeight();
        GLES20.glViewport((int)0, (int)0, (int)n3, (int)n4);
        n3 = this.mVertexCount;
        GLES20.glDrawArrays((int)5, (int)0, (int)n3);
        float f3 = f * 2.0f;
        float f4 = f2 * 2.0f;
        GLES20.glUniform4fv((int)this.mCoeffsLocation, (int)1, (float[])object, (int)4);
        GLES20.glUniform2f((int)this.mTextureLocation, (float)f3, (float)f4);
        n2 = this.mPlaneSizeUV.getWidth();
        int n5 = this.mPlaneSizeUV.getHeight();
        GLES20.glViewport((int)0, (int)this.mPlaneSizeY.getHeight(), (int)n2, (int)n5);
        n2 = this.mVertexCount;
        GLES20.glDrawArrays((int)5, (int)0, (int)n2);
        GLES20.glUniform4fv((int)this.mCoeffsLocation, (int)1, (float[])object, (int)8);
        GLES20.glUniform2f((int)this.mTextureLocation, (float)f3, (float)f4);
        int n6 = this.mPlaneSizeUV.getWidth();
        int n7 = this.mPlaneSizeUV.getHeight();
        GLES20.glViewport((int)0, (int)(this.mPlaneSizeY.getHeight() + this.mPlaneSizeUV.getHeight()), (int)n6, (int)n7);
        n6 = this.mVertexCount;
        GLES20.glDrawArrays((int)5, (int)0, (int)n6);
        n6 = this.mFrameSizeYUV.getWidth();
        n7 = this.mFrameSizeYUV.getHeight();
        GLES20.glReadPixels((int)0, (int)0, (int)n6, (int)n7, (int)6408, (int)5121, (Buffer)byteBuffer);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glDisableVertexAttribArray((int)this.mAttributeTextureCoord);
        GLES20.glDisableVertexAttribArray((int)this.mAttributePosition);
        GLES20.glBindBuffer((int)34962, (int)0);
        GLES20.glUseProgram((int)0);
        int n8 = GLES20.glGetError();
        if (n8 != 0) {
            Log.w((String)"YUVConverter.convert", (String)("OpenGL error code: " + n8));
        }
    }

    public int getWidth() {
        return this.mOutputFrameSize.getWidth();
    }

    public int getHeight() {
        return this.mOutputFrameSize.getHeight();
    }

    public void clear() {
        YUVConverterMod yUVConverterMod = object;
        yUVConverterMod.mFrameBufferYUV.clear();
        GLES20.glDeleteProgram((int)yUVConverterMod.mProgramHandle);
        Object object = yUVConverterMod.mVBO;
        GLES20.glDeleteBuffers((int)yUVConverterMod.mVBO.length, (int[])object, (int)0);
    }
}

