/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.output;

import android.util.Log;
import android.util.Size;
import androidx.annotation.NonNull;
import com.banuba.sdk.frame.FramePixelBuffer;
import com.banuba.sdk.frame.FramePixelBufferFormat;
import com.banuba.sdk.internal.gl.EglCore;
import com.banuba.sdk.internal.gl.GLOrientableTextureReader;
import com.banuba.sdk.internal.gl.IOrientable;
import com.banuba.sdk.internal.gl.OffscreenSurface;
import com.banuba.sdk.output.IOutput;
import com.banuba.sdk.player.IDirectBufferAllocator;
import com.banuba.sdk.player.Orientation;
import com.banuba.sdk.player.SimpleDirectBufferAllocator;
import com.banuba.sdk.player.VerifyCloseable;
import com.banuba.sdk.render_target.IRenderTargetPresentable;
import com.banuba.sdk.render_target.OpenGLRenderTarget;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class FrameOutput
extends VerifyCloseable
implements IOutput,
IOrientable {
    private final IFramePixelBufferProvider mCallback;
    private EglCore mEglCore;
    private OffscreenSurface mOffscreenSurface;
    private GLOrientableTextureReader mTextureReader;
    private final IDirectBufferAllocator mAllocator;
    private final boolean mUsedDefaultAllocator;
    private final ReadBufferMode mReadBufferMode;
    private int mWidth;
    private int mHeight;
    private int mMinBufferSize;
    private int[] mPlaneOffsets;
    private int[] mPlaneStrides;
    private int[] mPixelStrides;
    private boolean mFormatWasChanged;
    private FramePixelBufferFormat mFormat;
    private boolean mOrientationWasChanged;
    private Orientation mOrientation;
    private boolean mMirroring;

    public FrameOutput(@NonNull IFramePixelBufferProvider iFramePixelBufferProvider) {
        FrameOutput frameOutput = object;
        Object object = ReadBufferMode.SYNC;
        frameOutput(iFramePixelBufferProvider, null, (ReadBufferMode)((Object)object));
    }

    public FrameOutput(@NonNull IFramePixelBufferProvider iFramePixelBufferProvider, @NonNull ReadBufferMode readBufferMode) {
        this(iFramePixelBufferProvider, null, readBufferMode);
    }

    public FrameOutput(@NonNull IFramePixelBufferProvider iFramePixelBufferProvider, IDirectBufferAllocator iDirectBufferAllocator) {
        FrameOutput frameOutput = object;
        Object object = ReadBufferMode.SYNC;
        frameOutput(iFramePixelBufferProvider, iDirectBufferAllocator, (ReadBufferMode)((Object)object));
    }

    public FrameOutput(@NonNull IFramePixelBufferProvider iFramePixelBufferProvider, IDirectBufferAllocator iDirectBufferAllocator, @NonNull ReadBufferMode readBufferMode) {
        FrameOutput frameOutput = this;
        super("FrameOutput");
        frameOutput.mCallback = iFramePixelBufferProvider;
        frameOutput.setFormat(FramePixelBufferFormat.BPC8_RGBA);
        frameOutput.setOrientation(Orientation.UP, false);
        boolean bl = iDirectBufferAllocator == null;
        this.mUsedDefaultAllocator = bl;
        if (bl) {
            SimpleDirectBufferAllocator simpleDirectBufferAllocator;
            iDirectBufferAllocator = simpleDirectBufferAllocator;
            simpleDirectBufferAllocator = new SimpleDirectBufferAllocator();
        }
        FrameOutput frameOutput2 = this;
        frameOutput2.mAllocator = iDirectBufferAllocator;
        frameOutput2.mReadBufferMode = readBufferMode;
    }

    private ReadTextureDataResult readTextureData(int n, int n2, int n3) {
        FramePixelBuffer framePixelBuffer;
        Object object;
        ReadTextureDataResult readTextureDataResult;
        Object object2;
        if (object.mOrientationWasChanged) {
            object.mTextureReader.setOrientation(object.mOrientation, object.mMirroring);
            object.mOrientationWasChanged = false;
        }
        if (object.mWidth != n2 || object.mHeight != n3 || object.mFormatWasChanged) {
            object.mWidth = n2;
            object.mHeight = n3;
            if (object.mFormat.isI420()) {
                int n4 = n2;
                object.mMinBufferSize = GLOrientableTextureReader.calculateMinYuvBufferSize(n2, n3);
                object.mPlaneOffsets = GLOrientableTextureReader.calculateOffsets(n4, n3);
                object.mPlaneStrides = GLOrientableTextureReader.calculateStrides(n4);
                int[] nArray = new int[3];
                object2 = nArray;
                nArray[0] = 1;
                nArray[1] = 1;
                nArray[2] = 1;
                object.mPixelStrides = (int[])object2;
                object.mTextureReader.setFormat(object.mFormat.getColorStandard(), object.mFormat.getColorRange());
            } else if (object.mFormat.isBpc8()) {
                object.mMinBufferSize = GLOrientableTextureReader.calculateMinBufferSize(n2, n3, object.mFormat.getPixelFormat());
                int[] nArray = new int[1];
                object2 = nArray;
                nArray[0] = 0;
                object.mPlaneOffsets = (int[])object2;
                int[] nArray2 = new int[1];
                object2 = nArray2;
                nArray2[0] = GLOrientableTextureReader.calculateStrideForPlane(n2 * object.mFormat.getPixelComponents(), 0);
                object.mPlaneStrides = (int[])object2;
                int[] nArray3 = new int[1];
                object2 = nArray3;
                nArray3[0] = object.mFormat.getPixelComponents();
                object.mPixelStrides = (int[])object2;
                object.mTextureReader.setFormat(object.mFormat.getPixelFormat());
            }
            object.mFormatWasChanged = false;
        }
        object2 = readTextureDataResult;
        readTextureDataResult = new ReadTextureDataResult();
        if (object.mReadBufferMode == ReadBufferMode.SYNC) {
            ReadTextureDataResult readTextureDataResult2 = object2;
            object2 = object.mAllocator.allocateBuffer(object.mMinBufferSize);
            ((ByteBuffer)object2).order(ByteOrder.LITTLE_ENDIAN);
            object.mTextureReader.readOrientedTextureData(n, n2, n3, (ByteBuffer)object2);
            ((ByteBuffer)object2).rewind();
            Object object3 = object2;
            int[] nArray = object.mPlaneOffsets;
            object2 = object.mPixelStrides;
            object = object.mFormat;
            readTextureDataResult2.frame = new FramePixelBuffer((ByteBuffer)object3, nArray, object.mPlaneStrides, (int[])object2, n2, n3, (FramePixelBufferFormat)((Object)object));
            return readTextureDataResult2;
        }
        Object object4 = object.mTextureReader.mapOrientedTextureData(n, n2, n3);
        if (object4 == null) {
            return object2;
        }
        Object object5 = object.mAllocator;
        if (object5 != null) {
            Object object6 = object2;
            object2 = object5.allocateBuffer(object.mMinBufferSize);
            ((ByteBuffer)object2).order(ByteOrder.LITTLE_ENDIAN);
            ((ByteBuffer)object2).put((ByteBuffer)object4);
            ((ByteBuffer)object2).rewind();
            object.mTextureReader.unmapPBO();
            Object object7 = object2;
            object4 = object.mPlaneOffsets;
            object2 = object.mPixelStrides;
            object = object.mFormat;
            ((ReadTextureDataResult)object6).frame = new FramePixelBuffer((ByteBuffer)object7, (int[])object4, object.mPlaneStrides, (int[])object2, n2, n3, (FramePixelBufferFormat)((Object)object));
            return object6;
        }
        Object object8 = object2;
        object2 = framePixelBuffer;
        object5 = object.mPlaneStrides;
        int[] nArray = object.mPixelStrides;
        object = object.mFormat;
        framePixelBuffer = new FramePixelBuffer((ByteBuffer)object4, object.mPlaneOffsets, (int[])object5, nArray, n2, n3, (FramePixelBufferFormat)((Object)object));
        ((ReadTextureDataResult)object8).frame = object2;
        ((ReadTextureDataResult)object8).needUnmap = true;
        return object8;
    }

    public synchronized void setFormat(FramePixelBufferFormat framePixelBufferFormat) {
        FrameOutput frameOutput = this;
        frameOutput.mFormat = framePixelBufferFormat;
        frameOutput.mFormatWasChanged = true;
    }

    @Override
    public synchronized void setOrientation(Orientation orientation, boolean bl) {
        FrameOutput frameOutput = this;
        frameOutput.mOrientation = orientation;
        frameOutput.mMirroring = bl;
        frameOutput.mOrientationWasChanged = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void present(IRenderTargetPresentable iRenderTargetPresentable) {
        if (((VerifyCloseable)this).mIsClosed) {
            Log.e((String)((VerifyCloseable)this).mTag, (String)"The FrameOutput::present(...) method was called on a closed object.");
            return;
        }
        if (((FrameOutput)this).mEglCore == null) {
            void var3_10;
            EglCore eglCore;
            Object object = ((OpenGLRenderTarget)iRenderTargetPresentable).getContext();
            EglCore eglCore2 = eglCore;
            ((FrameOutput)this).mEglCore = new EglCore(((EglCore)object).getEGLContext(), 2);
            ((FrameOutput)this).mOffscreenSurface = new OffscreenSurface(eglCore2, 1, 1);
            ((FrameOutput)this).mOffscreenSurface.makeCurrent();
            if (((FrameOutput)this).mReadBufferMode == ReadBufferMode.ASYNC) {
                boolean bl = true;
            } else {
                boolean bl = false;
            }
            ((FrameOutput)this).mTextureReader = object = new GLOrientableTextureReader((boolean)var3_10);
        }
        ((FrameOutput)this).mOffscreenSurface.makeCurrent();
        Size size = iRenderTargetPresentable.getRenderingSize();
        int n = ((OpenGLRenderTarget)iRenderTargetPresentable).getGlTexture();
        int n2 = size.getWidth();
        int n3 = size.getHeight();
        ReadTextureDataResult readTextureDataResult = ((FrameOutput)this).readTextureData(n, n2, n3);
        FramePixelBuffer framePixelBuffer = readTextureDataResult.frame;
        if (framePixelBuffer != null) {
            FrameOutput frameOutput = this;
            frameOutput.mCallback.onFrame((IOutput)this, framePixelBuffer);
            if (frameOutput.mUsedDefaultAllocator) {
                ((SimpleDirectBufferAllocator)((FrameOutput)this).mAllocator).retainBuffer(readTextureDataResult.frame.getBuffer());
            }
        }
        if (readTextureDataResult.needUnmap) {
            ((FrameOutput)this).mTextureReader.unmapPBO();
        }
        if ((this = ((FrameOutput)this).mEglCore) != null) {
            ((EglCore)this).makeNothingCurrent();
        }
    }

    @Override
    public synchronized void close() {
        FrameOutput frameOutput = this;
        super.close();
        if (frameOutput.mEglCore == null) {
            return;
        }
        FrameOutput frameOutput2 = this;
        frameOutput2.mOffscreenSurface.makeCurrent();
        GLOrientableTextureReader gLOrientableTextureReader = frameOutput2.mTextureReader;
        if (gLOrientableTextureReader != null) {
            gLOrientableTextureReader.close();
            this.mTextureReader = null;
        }
        FrameOutput frameOutput3 = this;
        frameOutput3.mOffscreenSurface.release();
        frameOutput3.mOffscreenSurface = null;
        frameOutput3.mEglCore.release();
        frameOutput3.mEglCore = null;
        if (frameOutput3.mUsedDefaultAllocator) {
            ((SimpleDirectBufferAllocator)this.mAllocator).clear();
        }
    }

    public static enum ReadBufferMode {
        SYNC,
        ASYNC;

    }

    public static interface IFramePixelBufferProvider {
        public void onFrame(IOutput var1, FramePixelBuffer var2);
    }

    private static final class ReadTextureDataResult {
        FramePixelBuffer frame = null;
        boolean needUnmap = false;

        private ReadTextureDataResult() {
        }
    }
}

