/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.output;

import android.graphics.Rect;
import android.view.TextureView;
import com.banuba.sdk.internal.gl.EglCore;
import com.banuba.sdk.internal.gl.WindowSurface;
import com.banuba.sdk.output.ViewOutput;

public class TextureOutput
extends ViewOutput {
    private final TextureView mTextureView;

    public TextureOutput(TextureView textureView) {
        super("TextureOutput");
        this.mTextureView = textureView;
    }

    @Override
    protected boolean isSurfaceAvailable() {
        return this.mTextureView.isAvailable();
    }

    @Override
    protected WindowSurface createWindowSurface(EglCore eglCore) {
        return new WindowSurface(eglCore, this.mTextureView.getSurfaceTexture());
    }

    @Override
    protected void destroyWindowSurface(WindowSurface windowSurface) {
        windowSurface.release();
    }

    @Override
    protected Rect getSurfaceFrame() {
        TextureOutput textureOutput = this;
        int n = textureOutput.mTextureView.getWidth();
        int n2 = textureOutput.mTextureView.getHeight();
        return new Rect(0, 0, n, n2);
    }
}

