/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.output;

import android.util.Size;
import com.banuba.sdk.entity.WatermarkInfo;
import com.banuba.sdk.internal.gl.EglCore;
import com.banuba.sdk.internal.gl.EglSurfaceBase;
import com.banuba.sdk.internal.gl.WatermarkRenderer;
import com.banuba.sdk.internal.gl.WindowSurface;
import com.banuba.sdk.output.ContentMode;
import com.banuba.sdk.output.FrameLayoutHelper;
import com.banuba.sdk.output.IOutput;
import com.banuba.sdk.render_target.IRenderTargetPresentable;
import com.banuba.sdk.render_target.OpenGLRenderTarget;
import com.banuba.sdk.video.RecordingState;
import com.banuba.sdk.video.VideoFileRecorder;

public class VideoOutput
extends VideoFileRecorder
implements IOutput {
    private Size mRecordingSize;
    private ContentMode mContentMode;
    private WatermarkRenderer mWatermarkRenderer;

    public VideoOutput() {
        VideoOutput videoOutput = this;
        super("VideoOutput");
        videoOutput.setContentMode(ContentMode.ASPECT_FILL);
        videoOutput.mWatermarkRenderer = new WatermarkRenderer();
    }

    public void setContentMode(ContentMode contentMode) {
        this.mContentMode = contentMode;
    }

    public void setWatermark(WatermarkInfo watermarkInfo) {
        this.mWatermarkRenderer.init(watermarkInfo);
    }

    @Override
    public synchronized void present(IRenderTargetPresentable iRenderTargetPresentable) {
        Object object = this.getRenderingSurface();
        if (object == null && this.getRecordingState() == RecordingState.IN_PROGRESS) {
            Size size;
            VideoOutput videoOutput = this;
            IRenderTargetPresentable iRenderTargetPresentable2 = iRenderTargetPresentable;
            object = ((OpenGLRenderTarget)iRenderTargetPresentable2).getContext();
            videoOutput.mRecordingSize = size = iRenderTargetPresentable2.getRenderingSize();
            videoOutput.initializeMuxerAndSurface((EglCore)object, size);
            object = videoOutput.getRenderingSurface();
        }
        if (object != null && this.getRecordingState() == RecordingState.IN_PROGRESS) {
            IRenderTargetPresentable iRenderTargetPresentable3 = iRenderTargetPresentable;
            IRenderTargetPresentable iRenderTargetPresentable4 = iRenderTargetPresentable;
            iRenderTargetPresentable = iRenderTargetPresentable.getRenderingSize();
            iRenderTargetPresentable4.present((WindowSurface)object, FrameLayoutHelper.calculateFrameLayout(this.mRecordingSize, (Size)iRenderTargetPresentable, this.mContentMode));
            this.mWatermarkRenderer.draw(this.mRecordingSize.getWidth(), this.mRecordingSize.getHeight());
            this.frameAvailable(iRenderTargetPresentable3.getFrameTimeNanos());
            ((EglSurfaceBase)object).swapBuffers();
        }
    }

    @Override
    public synchronized void close() {
        VideoOutput videoOutput = this;
        super.close();
        videoOutput.mWatermarkRenderer.close();
    }
}

