/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.output;

import android.graphics.Rect;
import android.util.Log;
import android.util.Size;
import com.banuba.sdk.internal.gl.EglCore;
import com.banuba.sdk.internal.gl.WindowSurface;
import com.banuba.sdk.output.ContentMode;
import com.banuba.sdk.output.FrameLayoutHelper;
import com.banuba.sdk.output.IOutput;
import com.banuba.sdk.player.VerifyCloseable;
import com.banuba.sdk.render_target.IRenderTargetPresentable;
import com.banuba.sdk.render_target.OpenGLRenderTarget;

public abstract class ViewOutput
extends VerifyCloseable
implements IOutput {
    private WindowSurface mWindowSurface;
    private ContentMode mContentMode;

    protected ViewOutput(String string) {
        ViewOutput viewOutput = this;
        super(string);
        viewOutput.mWindowSurface = null;
        viewOutput.setContentMode(ContentMode.ASPECT_FILL);
    }

    public void setContentMode(ContentMode contentMode) {
        this.mContentMode = contentMode;
    }

    @Override
    public synchronized void present(IRenderTargetPresentable iRenderTargetPresentable) {
        Size size;
        if (this.mIsClosed) {
            Log.e((String)this.mTag, (String)"The ViewOutput::present(...) method was called on a closed object.");
            return;
        }
        if (!this.isSurfaceAvailable()) {
            this.destroy();
            return;
        }
        if (this.mWindowSurface == null) {
            this.mWindowSurface = this.createWindowSurface(((OpenGLRenderTarget)iRenderTargetPresentable).getContext());
        }
        ViewOutput viewOutput = this;
        Rect rect = viewOutput.getSurfaceFrame();
        Size size2 = size;
        Rect rect2 = rect;
        int n = rect2.width();
        size2(n, rect2.height());
        Size size3 = iRenderTargetPresentable.getRenderingSize();
        size3 = FrameLayoutHelper.calculateFrameLayout(size, size3, this.mContentMode);
        iRenderTargetPresentable.present(viewOutput.mWindowSurface, (Rect)size3);
        this.mWindowSurface.swapBuffers();
    }

    protected abstract boolean isSurfaceAvailable();

    protected abstract WindowSurface createWindowSurface(EglCore var1);

    protected abstract void destroyWindowSurface(WindowSurface var1);

    protected abstract Rect getSurfaceFrame();

    protected synchronized void destroy() {
        WindowSurface windowSurface = this.mWindowSurface;
        if (windowSurface != null) {
            this.destroyWindowSurface(windowSurface);
            this.mWindowSurface = null;
        }
    }

    @Override
    public void close() {
        ViewOutput viewOutput = this;
        super.close();
        viewOutput.destroy();
    }
}

