/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.player;

import android.content.Context;
import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.util.Size;
import android.view.Choreographer;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.Recycler;
import com.banuba.sdk.effect_player.Effect;
import com.banuba.sdk.effect_player.EffectActivatedListener;
import com.banuba.sdk.effect_player.EffectPlayer;
import com.banuba.sdk.effect_player.EffectPlayerConfiguration;
import com.banuba.sdk.effect_player.EffectPlayerPlaybackState;
import com.banuba.sdk.effect_player.JsCallback;
import com.banuba.sdk.input.IInput;
import com.banuba.sdk.internal.utils.Logger;
import com.banuba.sdk.manager.BanubaSdkTouchListener;
import com.banuba.sdk.output.IOutput;
import com.banuba.sdk.player.VerifyCloseable;
import com.banuba.sdk.player.render_thread.RenderHandler;
import com.banuba.sdk.player.render_thread.RenderThread;
import com.banuba.sdk.render_target.IRenderTarget;
import com.banuba.sdk.render_target.OpenGLRenderTarget;
import com.banuba.sdk.scene.RenderBackendType;
import com.banuba.sdk.types.FrameData;
import com.banuba.sdk.types.FullImageFormat;
import com.banuba.sdk.types.Rotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

public class Player
extends VerifyCloseable {
    private static final Size DEFAULT_SIZE = new Size(720, 1280);
    private static final int DEFAULT_FPS = 33;
    private EffectPlayer mEffectPlayer;
    private Effect mCurrentEffect;
    private IRenderTarget mRenderTarget;
    private IInput mInput;
    private final ArrayList<IOutput> mOutputs;
    private final RenderThread mRenderThread;
    private final Drawer mDrawer;
    private IRenderStatusCallback mRenderCallback;
    private RenderMode mRenderMode;

    public Player() {
        this(33);
    }

    public Player(int n) {
        RenderThread renderThread;
        Player player = this;
        super("Player");
        player.mCurrentEffect = null;
        player.mOutputs = new ArrayList();
        player.mRenderMode = RenderMode.LOOP;
        EffectPlayer.setRenderBackend((RenderBackendType)RenderBackendType.OPENGL);
        player.mRenderCallback = null;
        Object object = DEFAULT_SIZE;
        player.mEffectPlayer = Objects.requireNonNull(EffectPlayer.create((EffectPlayerConfiguration)EffectPlayerConfiguration.create((int)object.getWidth(), (int)object.getHeight())));
        Object object2 = object = renderThread;
        super();
        this.mRenderThread = object2;
        renderThread.startAndGetHandler();
        player.mDrawer = new Drawer(n, (RenderThread)object, this::draw);
        player.runOnRenderThreadSync(() -> player.lambda$new$0(EGL14.eglGetCurrentContext()));
    }

    private synchronized ArrayList<IOutput> getOutputs() {
        return (ArrayList)this.mOutputs.clone();
    }

    private void notifyRenderStatus(boolean bl, long l) {
        IRenderStatusCallback iRenderStatusCallback = ((Player)((Object)iRenderStatusCallback)).mRenderCallback;
        if (iRenderStatusCallback != null) {
            iRenderStatusCallback.onFrameRendered(bl, l);
        }
    }

    private synchronized Boolean draw() {
        boolean bl = this.mEffectPlayer.getPlaybackState() != EffectPlayerPlaybackState.ACTIVE || this.mOutputs.size() == 0 || this.mInput == null;
        if (bl) {
            this.notifyRenderStatus(false, -1L);
            return Boolean.FALSE;
        }
        Player player = this;
        player.mRenderTarget.activate();
        FrameData frameData = Objects.requireNonNull(player.mInput.frameProcessor()).pop().getFrameData();
        this.mRenderTarget.setFrameTimeNanos(this.mInput.getFrameTimeNanos());
        if (frameData != null) {
            this.resize(frameData.getFullImgFormat());
        }
        Player player2 = this;
        player2.mRenderTarget.resize();
        long l = player2.mEffectPlayer.drawWithExternalFrameData(frameData);
        if (l < 0L) {
            this.notifyRenderStatus(false, l);
            return Boolean.FALSE;
        }
        Iterator<IOutput> iterator = this.getOutputs().iterator();
        while (iterator.hasNext()) {
            iterator.next().present(this.mRenderTarget);
        }
        this.notifyRenderStatus(true, l);
        return Boolean.TRUE;
    }

    private void resize(FullImageFormat fullImageFormat) {
        Rotation rotation = fullImageFormat.getOrientation();
        boolean bl = rotation == Rotation.DEG_0 || rotation == Rotation.DEG_180;
        int n = bl ? fullImageFormat.getWidth() : fullImageFormat.getHeight();
        int n2 = bl ? fullImageFormat.getHeight() : fullImageFormat.getWidth();
        com.banuba.sdk.types.Size size = this.mEffectPlayer.effectManager().effectSize();
        if (size.getWidth() != n || size.getHeight() != n2) {
            Player player = this;
            player.mEffectPlayer.surfaceChanged(n, n2);
            player.mEffectPlayer.effectManager().setEffectSize(n, n2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runOnRenderThreadSync(Runnable runnable) {
        FutureTask<Object> futureTask;
        FutureTask<Object> futureTask2 = futureTask;
        futureTask2(runnable, null);
        this.runOnRenderThread(futureTask2);
        try {
            futureTask.get();
            return;
        }
        catch (InterruptedException exception) {
        }
        catch (ExecutionException exception) {
            // empty catch block
        }
        Logger.wtf(exception);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private <T> T runOnRenderThreadAndGetResult(Callable<T> callable) {
        Exception exception2;
        FutureTask<T> futureTask;
        Player player = futureTask2;
        FutureTask<T> futureTask2 = futureTask;
        player.runOnRenderThread(new FutureTask<T>(callable));
        try {
            try {
                return (T)futureTask2.get();
            }
            catch (InterruptedException exception2) {
            }
        }
        catch (ExecutionException exception2) {
            // empty catch block
        }
        Logger.wtf(exception2);
        return null;
    }

    private void runOnRenderThread(Runnable runnable) {
        if (this.mRenderThread.getId() == Thread.currentThread().getId()) {
            runnable.run();
        } else {
            ((RenderHandler)((Object)this.mRenderThread.getHandler())).sendRunnable(runnable);
        }
    }

    static BanubaSdkTouchListener createTouchListener(Context context, Player player) {
        return new BanubaSdkTouchListener(context, player.mEffectPlayer);
    }

    private /* synthetic */ void lambda$new$0(EGLContext eGLContext) {
        Player player = player2;
        Player player2 = DEFAULT_SIZE;
        player.mRenderTarget = new OpenGLRenderTarget(player2.mEffectPlayer, (Size)player2, eGLContext);
        Player player3 = player2;
        int n = player3.getWidth();
        player.mEffectPlayer.surfaceCreated(n, player3.getHeight());
    }

    public void setRenderMode(RenderMode renderMode) {
        if (this.mRenderMode == renderMode) {
            return;
        }
        Player player = this;
        player.runOnRenderThreadSync(() -> {
            this.mRenderMode = renderMode;
            if (renderMode == RenderMode.MANUAL) {
                this.mDrawer.unregister();
            } else if (renderMode == RenderMode.LOOP && this.mEffectPlayer.getPlaybackState() != EffectPlayerPlaybackState.PAUSED) {
                this.mDrawer.register();
            }
        });
    }

    public void setRenderStatusCallback(IRenderStatusCallback iRenderStatusCallback) {
        this.mRenderCallback = iRenderStatusCallback;
    }

    public void play() {
        Player player = this;
        player.runOnRenderThreadSync(() -> {
            Player player = this;
            player.mEffectPlayer.playbackPlay();
            if (player.mRenderMode == RenderMode.LOOP) {
                this.mDrawer.register();
            }
        });
    }

    public void pause() {
        Player player = this;
        player.runOnRenderThreadSync(() -> {
            Player player = this;
            player.mDrawer.unregister();
            player.mEffectPlayer.playbackPause();
        });
    }

    @Override
    public synchronized void close() {
        IInput iInput = this.mInput;
        if (iInput != null) {
            iInput.detach();
            this.mInput = null;
        }
        Player player = this;
        player.runOnRenderThreadSync(() -> {
            Player player = this;
            player.mDrawer.unregister();
            player.mOutputs.clear();
            player.mEffectPlayer.playbackStop();
            player.mEffectPlayer.surfaceDestroyed();
            player.mRenderTarget.destroy();
            player.mEffectPlayer = (EffectPlayer)Recycler.recycle((Object)player.mEffectPlayer);
            ((RenderHandler)((Object)((Object)player.mRenderThread.getHandler()))).sendShutdown();
            super.close();
        });
    }

    @NonNull
    public EffectPlayer getEffectPlayer() {
        return this.mEffectPlayer;
    }

    public void setEffectVolume(float f) {
        this.mEffectPlayer.effectManager().setEffectVolume(f);
    }

    public synchronized void use(@Nullable IInput iInput) {
        IInput iInput2 = this.mInput;
        if (iInput2 != null) {
            iInput2.detach();
            this.mInput = null;
        }
        if (iInput != null) {
            this.mInput = iInput;
            iInput.attach();
            this.mEffectPlayer.setFrameProcessor(Objects.requireNonNull(this.mInput.frameProcessor()));
        } else {
            this.mEffectPlayer.setFrameProcessor(null);
        }
    }

    public void use(@Nullable IOutput iOutput) {
        IOutput[] iOutputArray = iOutputArray3;
        IOutput[] iOutputArray2 = new IOutput[1];
        IOutput[] iOutputArray3 = iOutputArray2;
        iOutputArray2[0] = iOutput;
        iOutputArray.use(iOutputArray3);
    }

    public synchronized void use(@Nullable IOutput[] iOutputArray) {
        this.mOutputs.clear();
        if (iOutputArray != null) {
            for (IOutput iOutput : iOutputArray) {
                if (iOutput == null || this.mOutputs.contains(iOutput)) continue;
                this.mOutputs.add(iOutput);
            }
        }
    }

    public void use(@Nullable IInput iInput, @Nullable IOutput iOutput) {
        Player player = this;
        player.use(iInput);
        player.use(iOutput);
    }

    public void use(@Nullable IInput iInput, @Nullable IOutput[] iOutputArray) {
        Player player = this;
        player.use(iInput);
        player.use(iOutputArray);
    }

    public synchronized void addOutput(@NonNull IOutput iOutput) {
        if (!this.mOutputs.contains(iOutput)) {
            this.mOutputs.add(iOutput);
        }
    }

    public synchronized void removeOutput(@NonNull IOutput iOutput) {
        this.mOutputs.remove(iOutput);
    }

    @Nullable
    public Effect loadAsync(String string, IEffectActivatedCallback iEffectActivatedCallback) {
        if (iEffectActivatedCallback != null) {
            this.mCurrentEffect = new EffectActivatedListenerImpl(this.mEffectPlayer, string, iEffectActivatedCallback).getEffect();
            return this.mCurrentEffect;
        }
        this.mCurrentEffect = this.mEffectPlayer.effectManager().loadAsync(string);
        return this.mCurrentEffect;
    }

    @Nullable
    public Effect loadAsync(String string) {
        return this.loadAsync(string, null);
    }

    @Nullable
    public Effect load(String string) {
        Player player = this;
        this.mCurrentEffect = player.runOnRenderThreadAndGetResult(() -> this.mEffectPlayer.effectManager().load(string));
        return this.mCurrentEffect;
    }

    public void evalJs(@NonNull String string, @Nullable JsCallback jsCallback) {
        Player player = player.mCurrentEffect;
        if (player != null) {
            player.evalJs(string, jsCallback);
        } else {
            Logger.e("Can't call evalJs(..) method because the effect hasn't loaded yet.", new Object[0]);
        }
    }

    public boolean render() {
        if (this.mRenderMode == RenderMode.MANUAL) {
            Player player = this;
            return Boolean.TRUE.equals(player.runOnRenderThreadAndGetResult(player::draw));
        }
        throw new RuntimeException("Cannot render manually in not `MANUAL` render mode.");
    }

    public static enum RenderMode {
        LOOP,
        MANUAL;

    }

    @FunctionalInterface
    public static interface IRenderStatusCallback {
        public void onFrameRendered(boolean var1, long var2);
    }

    private static class Drawer
    implements Choreographer.FrameCallback {
        private long mLastDoFrameNanos;
        private final long doFrameInterval;
        private final RenderThread mRenderThread;
        private final Runnable mDrawTask;

        public Drawer(int n, RenderThread renderThread, Runnable runnable) {
            long l = n;
            this.doFrameInterval = 1000000000L / l;
            this.mRenderThread = renderThread;
            this.mDrawTask = runnable;
        }

        public void doFrame(long l) {
            if (l - this.mLastDoFrameNanos >= this.doFrameInterval) {
                this.mLastDoFrameNanos = l;
                ((RenderHandler)((Object)this.mRenderThread.getHandler())).sendDraw(this.mDrawTask);
            }
            this.register();
        }

        public void register() {
            Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
        }

        public void unregister() {
            Choreographer.getInstance().removeFrameCallback((Choreographer.FrameCallback)this);
        }
    }

    private static class EffectActivatedListenerImpl
    implements EffectActivatedListener {
        private final Effect mEffect;
        private final EffectPlayer mEffectPlayer;
        private final IEffectActivatedCallback mCallback;

        public EffectActivatedListenerImpl(EffectPlayer effectPlayer, String string, @NonNull IEffectActivatedCallback iEffectActivatedCallback) {
            EffectPlayer effectPlayer2 = effectPlayer;
            this.mEffectPlayer = effectPlayer;
            this.mCallback = iEffectActivatedCallback;
            effectPlayer2.effectManager().addEffectActivatedListener((EffectActivatedListener)this);
            this.mEffect = effectPlayer2.effectManager().loadAsync(string);
        }

        public Effect getEffect() {
            return this.mEffect;
        }

        public void onEffectActivated(@NonNull String string) {
            Effect effect = this.mEffect;
            if (effect == null) {
                effect = this.mEffectPlayer.effectManager().current();
            }
            IEffectActivatedCallback iEffectActivatedCallback = this.mCallback;
            if (effect == null || !effect.url().equals(string)) {
                effect = null;
            }
            iEffectActivatedCallback.onEffectActivated(effect);
            this.mEffectPlayer.effectManager().removeEffectActivatedListener((EffectActivatedListener)this);
        }
    }

    @FunctionalInterface
    public static interface IEffectActivatedCallback {
        public void onEffectActivated(Effect var1);
    }
}

