/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.render_target;

import android.graphics.Rect;
import android.opengl.EGLContext;
import android.opengl.GLES30;
import android.os.Process;
import android.util.Size;
import com.banuba.sdk.effect_player.EffectPlayer;
import com.banuba.sdk.internal.gl.EglCore;
import com.banuba.sdk.internal.gl.GLFullRectTexture;
import com.banuba.sdk.internal.gl.OffscreenSurface;
import com.banuba.sdk.internal.gl.RenderBuffer;
import com.banuba.sdk.internal.gl.WindowSurface;
import com.banuba.sdk.internal.utils.Logger;
import com.banuba.sdk.render_target.IRenderTarget;
import com.banuba.sdk.types.PixelBuffer;

public class OpenGLRenderTarget
implements IRenderTarget {
    private static final String TAG = "OpenGLRenderTarget";
    private static final int EGL_FLAGS = 3;
    private EglCore mEglCore;
    private OffscreenSurface mOffscreenSurface;
    private RenderBuffer mRenderBuffer;
    private GLFullRectTexture mTextureDrawer;
    private EffectPlayer mEffectPlayer;
    private Size mRenderSize;
    private long mFrameTimeNanos;

    public OpenGLRenderTarget(EffectPlayer object, Size size, EGLContext eGLContext) {
        EglCore eglCore;
        OpenGLRenderTarget openGLRenderTarget = this;
        this.mFrameTimeNanos = 0L;
        this.mEffectPlayer = object;
        openGLRenderTarget.mRenderSize = size;
        Process.setThreadPriority((int)-8);
        object = eglCore;
        openGLRenderTarget.mEglCore = new EglCore(eGLContext, 3);
        this.mOffscreenSurface = new OffscreenSurface((EglCore)object, 1, 1);
        this.mOffscreenSurface.makeCurrent();
        openGLRenderTarget.mTextureDrawer = new GLFullRectTexture(false);
        this.mRenderBuffer = RenderBuffer.prepareFrameBuffer(size.getWidth(), size.getHeight());
    }

    public EglCore getContext() {
        return this.mEglCore;
    }

    @Override
    public void destroy() {
        OpenGLRenderTarget openGLRenderTarget = this;
        openGLRenderTarget.mEffectPlayer = null;
        openGLRenderTarget.mRenderBuffer.clear();
        openGLRenderTarget.mRenderBuffer = null;
        try {
            openGLRenderTarget.mTextureDrawer.close();
            openGLRenderTarget.mTextureDrawer = null;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = exception;
            Logger.wtf(TAG, objectArray2);
        }
        OpenGLRenderTarget openGLRenderTarget2 = this;
        openGLRenderTarget2.mOffscreenSurface.release();
        openGLRenderTarget2.mOffscreenSurface = null;
        openGLRenderTarget2.mEglCore.release();
        openGLRenderTarget2.mEglCore = null;
    }

    @Override
    public void activate() {
        OpenGLRenderTarget openGLRenderTarget = this;
        openGLRenderTarget.mOffscreenSurface.makeCurrent();
        GLES30.glBindFramebuffer((int)36160, (int)openGLRenderTarget.mRenderBuffer.getFrameBufferId());
        GLES30.glDisable((int)2884);
        GLES30.glDisable((int)2929);
    }

    @Override
    public Size getRenderingSize() {
        return this.mRenderSize;
    }

    @Override
    public void present(WindowSurface windowSurface, Rect rect) {
        windowSurface.makeCurrent();
        GLES30.glBindFramebuffer((int)36160, (int)0);
        GLES30.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GLES30.glEnable((int)3042);
        GLES30.glBlendEquation((int)32774);
        GLES30.glBlendFunc((int)770, (int)771);
        Rect rect2 = rect;
        int n = Math.abs(rect2.width());
        GLES30.glViewport((int)rect.left, (int)rect.bottom, (int)n, (int)Math.abs(rect2.height()));
        GLES30.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GLES30.glClear((int)16384);
        this.mTextureDrawer.draw(this.mRenderBuffer.getTextureId());
    }

    @Override
    public void present() {
        this.mOffscreenSurface.swapBuffers();
    }

    public int getGlTexture() {
        return this.mRenderBuffer.getTextureId();
    }

    @Override
    public void resize() {
        OpenGLRenderTarget openGLRenderTarget = this;
        int n = openGLRenderTarget.mEffectPlayer.effectManager().surfaceSize().getWidth();
        int n2 = openGLRenderTarget.mEffectPlayer.effectManager().surfaceSize().getHeight();
        if (openGLRenderTarget.mRenderBuffer.getWidth() != n || this.mRenderBuffer.getHeight() != n2) {
            this.mRenderBuffer.resize(n, n2);
            this.mRenderSize = new Size(n, n2);
        }
        OpenGLRenderTarget openGLRenderTarget2 = this;
        int n3 = openGLRenderTarget2.mRenderSize.getWidth();
        n = openGLRenderTarget2.mRenderSize.getHeight();
        GLES30.glViewport((int)0, (int)0, (int)n3, (int)n);
    }

    @Override
    public PixelBuffer readPixels() {
        return this.mEffectPlayer.readPixels();
    }

    @Override
    public void setFrameTimeNanos(long l) {
        this.mFrameTimeNanos = l;
    }

    @Override
    public long getFrameTimeNanos() {
        return this.mFrameTimeNanos;
    }
}

