/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.video;

import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.os.Build;
import android.util.Pair;
import androidx.annotation.NonNull;
import com.banuba.sdk.video.BaseExtractor;
import java.nio.ByteBuffer;
import java.util.LinkedList;

public class AudioExtractor
extends BaseExtractor {
    public AudioExtractor(String string) {
        super(string, "audio/");
    }

    private static boolean isKeyFrame(@NonNull MediaExtractor mediaExtractor) {
        return (mediaExtractor.getSampleFlags() & 1) > 0;
    }

    private static boolean isPartialFrame(@NonNull MediaExtractor mediaExtractor) {
        boolean bl = false;
        if (Build.VERSION.SDK_INT >= 26) {
            boolean bl2;
            boolean bl3;
            bl = (mediaExtractor.getSampleFlags() & 4) > 0 ? (bl3 = true) : (bl2 = false);
        }
        return bl;
    }

    private static int makeFlags(boolean bl, boolean bl2, boolean bl3) {
        if (!bl) {
            bl2 |= 4;
        }
        if (Build.VERSION.SDK_INT >= 26 && bl3) {
            bl2 |= 8;
        }
        return bl2 ? 1 : 0;
    }

    public LinkedList<Pair<MediaCodec.BufferInfo, ByteBuffer>> extractAudioStream() {
        LinkedList<Pair<MediaCodec.BufferInfo, ByteBuffer>> linkedList;
        LinkedList<Pair<MediaCodec.BufferInfo, ByteBuffer>> linkedList2 = linkedList;
        linkedList = new LinkedList<Pair<MediaCodec.BufferInfo, ByteBuffer>>();
        boolean bl = true;
        while (bl) {
            AudioExtractor audioExtractor = this;
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(32768);
            byteBuffer.limit(byteBuffer.capacity());
            long l = audioExtractor.mExtractor.getSampleTime();
            int n = audioExtractor.mExtractor.readSampleData(byteBuffer, 0);
            AudioExtractor audioExtractor2 = this;
            int n2 = AudioExtractor.isKeyFrame(audioExtractor2.mExtractor);
            boolean bl2 = AudioExtractor.isPartialFrame(audioExtractor2.mExtractor);
            boolean bl3 = audioExtractor2.mExtractor.advance();
            if (n > 0) {
                Pair pair;
                MediaCodec.BufferInfo bufferInfo;
                n2 = AudioExtractor.makeFlags(bl3, n2 != 0, bl2);
                MediaCodec.BufferInfo bufferInfo2 = bufferInfo;
                new MediaCodec.BufferInfo().set(0, n, l, n2);
                byteBuffer.limit(n);
                ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n);
                byteBuffer2.put(byteBuffer);
                byteBuffer = pair;
                pair = new Pair((Object)bufferInfo2, (Object)byteBuffer2);
                linkedList2.add((Pair<MediaCodec.BufferInfo, ByteBuffer>)byteBuffer);
            }
            bl = bl3;
        }
        return linkedList2;
    }
}

