/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.video;

import android.media.MediaExtractor;
import android.media.MediaFormat;
import androidx.annotation.CallSuper;
import java.io.Closeable;

public abstract class BaseExtractor
implements Closeable {
    protected final int mTrackIndex;
    protected final String mFilename;
    protected final MediaFormat mMediaFormat;
    protected MediaExtractor mExtractor;

    protected BaseExtractor(String string, String string2) {
        int n;
        MediaExtractor mediaExtractor;
        MediaExtractor mediaExtractor2;
        BaseExtractor baseExtractor = this;
        baseExtractor.mFilename = string;
        MediaExtractor mediaExtractor3 = mediaExtractor2 = mediaExtractor;
        mediaExtractor3();
        this.mExtractor = mediaExtractor3;
        mediaExtractor.setDataSource(string);
        this.mTrackIndex = n = baseExtractor.findTrackByMime(baseExtractor.mExtractor, string2);
        if (n != -1) {
            BaseExtractor baseExtractor2 = this;
            baseExtractor2.mExtractor.selectTrack(n);
            baseExtractor2.mMediaFormat = baseExtractor2.mExtractor.getTrackFormat(n);
            return;
        }
        throw new RuntimeException("Track for " + string2 + " not found");
    }

    private int findTrackByMime(MediaExtractor mediaExtractor, String string) {
        int n = mediaExtractor.getTrackCount();
        for (int i = 0; i < n; ++i) {
            String string2 = mediaExtractor.getTrackFormat(i).getString("mime");
            if (string2 == null || !string2.startsWith(string)) continue;
            return i;
        }
        return -1;
    }

    public MediaFormat getMediaFormat() {
        return this.mMediaFormat;
    }

    @Override
    @CallSuper
    public void close() {
        MediaExtractor mediaExtractor = this.mExtractor;
        if (mediaExtractor != null) {
            mediaExtractor.release();
            this.mExtractor = null;
        }
    }
}

