/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.video;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.util.Size;
import androidx.annotation.NonNull;
import com.banuba.sdk.effect_player.CameraOrientation;
import com.banuba.sdk.internal.utils.CameraUtils;
import com.banuba.sdk.types.FullImageData;
import com.banuba.sdk.video.BaseExtractor;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Objects;

public class VideoExtractor
extends BaseExtractor {
    private final IVideoFrameCallback mCallback;
    private boolean mOutputDone = false;
    private boolean mInputDone = false;
    private MediaCodec mDecoder;
    private int mWidth;
    private int mHeight;
    private int mStride;
    private int mSliceHeight;
    private int mColorFormat;
    private int mRotation = 0;

    public VideoExtractor(String string, IVideoFrameCallback iVideoFrameCallback) {
        super(string, "video/");
        this.mCallback = iVideoFrameCallback;
    }

    private void createDecoder() {
        MediaCodec mediaCodec;
        VideoExtractor videoExtractor = string;
        MediaFormat mediaFormat = videoExtractor.getMediaFormat();
        VideoExtractor videoExtractor2 = string;
        VideoExtractor videoExtractor3 = string;
        String string = Objects.requireNonNull(mediaFormat.getString("mime"));
        videoExtractor3.mDecoder = mediaCodec = Objects.requireNonNull(MediaCodec.createDecoderByType((String)string));
        mediaFormat.setInteger("color-format", videoExtractor3.detectColorFormat(mediaCodec, string));
        videoExtractor2.mDecoder.configure(mediaFormat, null, null, 0);
        videoExtractor.updateOutputFrameInfo(mediaFormat);
    }

    private void updateOutputFrameInfo(MediaFormat mediaFormat) {
        this.mWidth = mediaFormat.getInteger("width");
        this.mHeight = mediaFormat.getInteger("height");
        int n = mediaFormat.containsKey("stride") ? mediaFormat.getInteger("stride") : this.mWidth;
        this.mStride = n;
        n = mediaFormat.containsKey("slice-height") ? mediaFormat.getInteger("slice-height") : this.mHeight;
        this.mSliceHeight = n;
        this.mColorFormat = mediaFormat.getInteger("color-format");
        int n2 = mediaFormat.containsKey("rotation-degrees") ? mediaFormat.getInteger("rotation-degrees") : this.mRotation;
        this.mRotation = n2;
    }

    private int detectColorFormat(@NonNull MediaCodec mediaCodec, @NonNull String object) {
        block1: {
            Object object2;
            VideoExtractor videoExtractor = mediaCodec.getCodecInfo().getCapabilitiesForType((String)object);
            int n = 0;
            while (true) {
                object = ((MediaCodecInfo.CodecCapabilities)videoExtractor).colorFormats;
                if (n >= ((MediaCodecInfo.CodecCapabilities)videoExtractor).colorFormats.length) break block1;
                object2 = object[n];
                boolean bl = object2 == 19;
                boolean bl2 = object2 == 21;
                if (bl || bl2) break;
                ++n;
            }
            return (int)object2;
        }
        return 2135033992;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doExtract() {
        MediaCodec.BufferInfo bufferInfo;
        MediaCodec.BufferInfo bufferInfo2 = bufferInfo;
        bufferInfo = new MediaCodec.BufferInfo();
        int n = 1;
        while (n != 0 && !this.mOutputDone) {
            Exception exception;
            int n2;
            block13: {
                FullImageData.Orientation orientation;
                CameraOrientation cameraOrientation;
                int n4;
                ByteBuffer byteBuffer2;
                boolean bl;
                ByteBuffer byteBuffer;
                if (!this.mInputDone && (n2 = this.mDecoder.dequeueInputBuffer(10000L)) >= 0 && (byteBuffer = this.mDecoder.getInputBuffer(n2)) != null) {
                    int n3 = this.mExtractor.readSampleData(byteBuffer, 0);
                    if (n3 < 0) {
                        this.mDecoder.queueInputBuffer(n2, 0, 0, 0L, 4);
                        this.mInputDone = true;
                    } else {
                        long l = this.mExtractor.getSampleTime();
                        this.mDecoder.queueInputBuffer(n2, 0, n3, l, 0);
                        this.mExtractor.advance();
                    }
                }
                if ((n2 = this.mDecoder.dequeueOutputBuffer(bufferInfo2, 10000L)) == -1 || n2 == -3) continue;
                if (n2 == -2) {
                    this.updateOutputFrameInfo(this.mDecoder.getOutputFormat());
                    continue;
                }
                if (n2 < 0) {
                    throw new RuntimeException("Unexpected result from dequeueOutputBuffer: " + n2);
                }
                if ((bufferInfo2.flags & 4) != 0) {
                    this.mOutputDone = true;
                    this.mDecoder.stop();
                }
                try {
                    bl = bufferInfo2.size != 0;
                    if (!bl) continue;
                    byteBuffer2 = this.mDecoder.getOutputBuffer(n2);
                    n4 = 0;
                }
                catch (Exception exception3) {
                    n2 = n;
                    exception = exception3;
                    break block13;
                }
                try {
                    cameraOrientation = CameraUtils.degreesToCameraOrientation(this.mRotation);
                }
                catch (Exception exception2) {
                    n2 = n4;
                    break block13;
                }
                FullImageData.Orientation orientation2 = orientation;
                {
                    orientation = new FullImageData.Orientation(cameraOrientation, false, 0);
                    int n6 = this.mWidth;
                    int n7 = this.mHeight;
                    int n8 = this.mStride;
                    int n9 = this.mSliceHeight;
                    this.mCallback.onFrame(this.createFullImageData(this.mColorFormat, byteBuffer2, n6, n7, n8, n9, orientation2), bufferInfo2.presentationTimeUs);
                    this.mDecoder.releaseOutputBuffer(n2, bl);
                    n = n4;
                    continue;
                }
            }
            this.mCallback.onError(exception);
            n = n2;
        }
        if (this.mOutputDone) {
            this.mCallback.onFinish();
        }
    }

    private FullImageData createFullImageData(int n, ByteBuffer byteBuffer, int n2, int n3, int n4, int n5, FullImageData.Orientation orientation) {
        Size size;
        boolean bl = n == 21;
        int n6 = n == 19 ? 1 : 0;
        if (!bl && n6 == 0) {
            throw new RuntimeException("Unknown color format = " + n + " (0x" + Integer.toHexString(n) + ")");
        }
        n = bl ? n4 : n4 / 2;
        n6 = bl ? 2 : 1;
        ByteBuffer byteBuffer2 = byteBuffer;
        ByteBuffer byteBuffer3 = byteBuffer;
        Size size2 = size;
        size = new Size(n2, n3);
        byteBuffer3.position(0);
        ByteBuffer byteBuffer4 = byteBuffer3.slice();
        n3 = n4 * n5;
        byteBuffer2.position(n3);
        ByteBuffer byteBuffer5 = byteBuffer2.slice();
        n3 = bl ? ++n3 : n4 * 5 * n5 / 4;
        ByteBuffer byteBuffer6 = byteBuffer;
        byteBuffer6.position(n3);
        byteBuffer = byteBuffer6.slice();
        int n7 = n;
        int n8 = n6;
        return new FullImageData(size2, (Buffer)byteBuffer4, (Buffer)byteBuffer5, (Buffer)byteBuffer, n4, n7, n7, 1, n8, n8, orientation);
    }

    public boolean hasNextFrame() {
        return this.mOutputDone ^ true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void extractNextFrame() {
        try {
            if (this.mDecoder == null) {
                VideoExtractor videoExtractor = this;
                videoExtractor.createDecoder();
                videoExtractor.mDecoder.start();
            }
            this.doExtract();
            return;
        }
        catch (Exception exception) {
            this.mCallback.onError(exception);
        }
    }

    @Override
    public void close() {
        MediaCodec mediaCodec = this.mDecoder;
        if (mediaCodec != null) {
            mediaCodec.stop();
            this.mDecoder = null;
        }
        super.close();
    }

    public static interface IVideoFrameCallback {
        public void onFrame(@NonNull FullImageData var1, long var2);

        public void onError(@NonNull Throwable var1);

        public void onFinish();
    }
}

