/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.video;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.util.Log;
import android.util.Pair;
import android.util.Size;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import com.banuba.sdk.encoding.MediaMuxerWrapperExternalAudio;
import com.banuba.sdk.encoding.sync.EncoderSync;
import com.banuba.sdk.encoding.sync.IEncoderSync;
import com.banuba.sdk.internal.encoding.MediaMuxerWrapper;
import com.banuba.sdk.internal.encoding.RecordingParams;
import com.banuba.sdk.internal.gl.EglCore;
import com.banuba.sdk.internal.gl.WindowSurface;
import com.banuba.sdk.internal.renderer.RenderHandler;
import com.banuba.sdk.player.VerifyCloseable;
import com.banuba.sdk.video.IAudioDataProvider;
import com.banuba.sdk.video.IVideoRecorder;
import com.banuba.sdk.video.RecordingState;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;

public class VideoFileRecorder
extends VerifyCloseable
implements IVideoRecorder {
    private MediaMuxerWrapper mMuxer;
    private RecordingState mRecordingState = RecordingState.STOPPED;
    private long mRecordPauseTimeStamp;
    private long mRecordSkipTime;
    private IRecordingStateChangedListener mRecordingStateChangedListener;
    private WindowSurface mFrameRenderingSurface;
    private File mOutputFile;
    private IAudioDataProvider mAudioDataProvider;
    private LinkedList<Pair<MediaCodec.BufferInfo, ByteBuffer>> mAudioData;
    private EncoderSync mEncoderSync = null;
    private boolean mNeedToStartRecording = false;
    private boolean mRecordAudio = false;

    public VideoFileRecorder() {
        this("VideoFileRecorder");
    }

    protected VideoFileRecorder(String string) {
        super(string);
    }

    private void onRecordingStateChanged() {
        VideoFileRecorder videoFileRecorder = object;
        Object object = videoFileRecorder.mRecordingState;
        IRecordingStateChangedListener iRecordingStateChangedListener = videoFileRecorder.mRecordingStateChangedListener;
        if (iRecordingStateChangedListener != null) {
            iRecordingStateChangedListener.onStateChanged((RecordingState)((Object)object));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void prepareVideoRecorder(Size var1_1) {
        block18: {
            block17: {
                v0 = this;
                v1 = this;
                v1.mRecordSkipTime = 0L;
                v1.mRecordPauseTimeStamp = 0L;
                var2_3 = RecordingParams.getVideoFormat(var1_1.getWidth(), var1_1.getHeight());
                var3_4 = v0.mAudioDataProvider;
                if (var3_4 == null) break block17;
                if (var3_4.getAudioFormat() == null) break block17;
                if (this.mAudioDataProvider.getAudioData() == null) break block17;
                v2 = true;
                break block18;
            }
            v2 = false;
        }
        if (!v2) ** GOTO lbl47
        v3 = this;
        v4 = v3;
        v5 = v3;
        v3.mEncoderSync = new EncoderSync();
        var3_4 = v6;
        v7 = var1_1;
        v8 = this;
        var1_1 = null;
        var4_5 = null;
        var5_7 = v8.mOutputFile.getPath();
        var6_9 = v8.mEncoderSync;
        var7_11 = 0L;
        var9_13 = 1.0f;
        var10_14 = v7.getWidth();
        var11_16 = v7.getHeight();
        v9 = var1_1;
        var1_1 = this.mAudioDataProvider.getAudioFormat();
        v6 = new MediaMuxerWrapperExternalAudio((RenderHandler)v9, var4_5, var5_7, var6_9, var7_11, var9_13, var10_14, var11_16, var2_3, (MediaFormat)var1_1);
        v4.mAudioData = v5.mAudioDataProvider.getAudioData();
        ** GOTO lbl68
lbl47:
        // 1 sources

        v10 = this;
        v11 = v10;
        v12 = v10;
        v10.mEncoderSync = null;
        var4_6 = null;
        var5_8 = null;
        var6_10 = v12.mOutputFile.getPath();
        var7_12 = v11.mRecordAudio != false ? 1 : 0;
        v13 = var1_1;
        var1_1 = null;
        var8_18 = 0L;
        var10_15 = 1.0f;
        var11_17 = v13.getWidth();
        var12_19 = v13.getHeight();
        try {
            var3_4 = new MediaMuxerWrapper(var4_6, var5_8, var6_10, var7_12, (IEncoderSync)var1_1, var8_18, var10_15, var11_17, var12_19, var2_3, null);
            this.mAudioData = null;
lbl68:
            // 2 sources

            var3_4.prepare();
            this.mMuxer = var3_4;
        }
        catch (IOException var1_2) {
            Log.e((String)this.mTag, (String)var1_2.getMessage());
        }
    }

    public void recordAudioFromMicrophone(boolean bl) {
        this.mRecordAudio = bl;
    }

    protected void setRecordingStateChangedListener(IRecordingStateChangedListener iRecordingStateChangedListener) {
        this.mRecordingStateChangedListener = iRecordingStateChangedListener;
    }

    @Override
    @CallSuper
    public void startRecording(File file) {
        this.startRecording(file, null);
    }

    @Override
    @CallSuper
    public synchronized void startRecording(File file, IAudioDataProvider iAudioDataProvider) {
        if (this.mRecordingState == RecordingState.STOPPED) {
            VideoFileRecorder videoFileRecorder = this;
            this.mNeedToStartRecording = true;
            videoFileRecorder.mOutputFile = file;
            videoFileRecorder.mRecordingState = RecordingState.IN_PROGRESS;
            this.mAudioDataProvider = iAudioDataProvider;
            this.onRecordingStateChanged();
        } else {
            Log.w((String)this.mTag, (String)"Recording is already in progress");
        }
    }

    @Override
    @CallSuper
    public synchronized void pauseRecording() {
        RecordingState recordingState = this.getRecordingState();
        if (recordingState == RecordingState.STOPPED) {
            Log.w((String)this.mTag, (String)"Recording is not started");
        } else if (recordingState == RecordingState.IN_PROGRESS) {
            VideoFileRecorder videoFileRecorder = this;
            videoFileRecorder.mMuxer.setPause(true);
            videoFileRecorder.mRecordingState = RecordingState.PAUSED;
            videoFileRecorder.onRecordingStateChanged();
            videoFileRecorder.mRecordPauseTimeStamp = System.nanoTime();
        } else {
            Log.w((String)this.mTag, (String)"Recording is already paused");
        }
    }

    @Override
    @CallSuper
    public synchronized void resumeRecording() {
        RecordingState recordingState = this.getRecordingState();
        if (recordingState == RecordingState.STOPPED) {
            Log.w((String)this.mTag, (String)"Recording is not started");
        } else if (recordingState == RecordingState.PAUSED) {
            VideoFileRecorder videoFileRecorder = this;
            videoFileRecorder.mMuxer.setPause(false);
            videoFileRecorder.mRecordingState = RecordingState.IN_PROGRESS;
            videoFileRecorder.onRecordingStateChanged();
            videoFileRecorder.mRecordSkipTime += System.nanoTime() - this.mRecordPauseTimeStamp;
        } else {
            Log.w((String)this.mTag, (String)"Recording is not paused");
        }
    }

    @Override
    @CallSuper
    public synchronized void stopRecording() {
        this.mNeedToStartRecording = false;
        Object object = RecordingState.STOPPED;
        if (this.getRecordingState() != object) {
            this.mRecordingState = object;
            object = this.mMuxer;
            if (object != null) {
                ((MediaMuxerWrapper)object).stopRecording();
                this.mMuxer = null;
            }
            this.onRecordingStateChanged();
            this.mFrameRenderingSurface = null;
        } else {
            Log.w((String)this.mTag, (String)"Recording is not started");
        }
    }

    @Override
    @CallSuper
    public synchronized void stopRecordingAndWaitForFinish() {
        VideoFileRecorder videoFileRecorder = this;
        MediaMuxerWrapper mediaMuxerWrapper = videoFileRecorder.mMuxer;
        if (videoFileRecorder.getRecordingState() != RecordingState.STOPPED) {
            this.stopRecording();
        }
        if (mediaMuxerWrapper != null) {
            mediaMuxerWrapper.waitForFinish();
        }
    }

    @Override
    public RecordingState getRecordingState() {
        return this.mRecordingState;
    }

    @Override
    public void close() {
        VideoFileRecorder videoFileRecorder = this;
        videoFileRecorder.stopRecordingAndWaitForFinish();
        super.close();
    }

    protected synchronized void initializeMuxerAndSurface(@NonNull EglCore eglCore, Size object) {
        WindowSurface windowSurface;
        if (((VideoFileRecorder)((Object)encoderSync)).mRecordingState == RecordingState.STOPPED) {
            return;
        }
        VideoFileRecorder videoFileRecorder = encoderSync;
        videoFileRecorder.prepareVideoRecorder((Size)object);
        object = videoFileRecorder.mMuxer;
        if (object == null) {
            Log.e((String)((VerifyCloseable)((Object)encoderSync)).mTag, (String)"Muxer is not created");
            return;
        }
        WindowSurface windowSurface2 = windowSurface;
        windowSurface2(eglCore, ((MediaMuxerWrapper)object).getInputSurface(), true);
        ((VideoFileRecorder)((Object)encoderSync)).mFrameRenderingSurface = windowSurface2;
        windowSurface.makeCurrent();
        EncoderSync encoderSync = ((VideoFileRecorder)((Object)encoderSync)).mEncoderSync;
        if (encoderSync != null) {
            encoderSync.setEncoderReady();
        }
    }

    protected WindowSurface getRenderingSurface() {
        return this.mFrameRenderingSurface;
    }

    protected void frameAvailable(long l) {
        Object object;
        if (this.mNeedToStartRecording && (object = this.mMuxer) != null) {
            ((MediaMuxerWrapper)object).startRecording();
            this.mNeedToStartRecording = false;
        }
        if (this.mMuxer != null && this.mRecordingState == RecordingState.IN_PROGRESS) {
            object = this.mEncoderSync;
            if (object != null) {
                ((EncoderSync)object).setEncodingStarted();
            }
            VideoFileRecorder videoFileRecorder = this;
            videoFileRecorder.mFrameRenderingSurface.setPresentationTime(l - this.mRecordSkipTime);
            videoFileRecorder.mFrameRenderingSurface.makeCurrent();
            object = videoFileRecorder.mMuxer;
            if (object != null) {
                ((MediaMuxerWrapper)object).frameAvailableSoon();
                if (this.mEncoderSync != null) {
                    Object object2;
                    l = TimeUnit.NANOSECONDS.toMicros(l - this.mRecordSkipTime);
                    while ((object2 = this.mAudioData.peekFirst()) != null) {
                        MediaCodec.BufferInfo bufferInfo = (MediaCodec.BufferInfo)object2.first;
                        object2 = (ByteBuffer)object2.second;
                        long l2 = bufferInfo.presentationTimeUs;
                        if (!((MediaMuxerWrapperExternalAudio)object).writeAudioSampleData((ByteBuffer)object2, bufferInfo)) break;
                        this.mAudioData.removeFirst();
                        if (l2 < l) continue;
                    }
                    VideoFileRecorder videoFileRecorder2 = this;
                    videoFileRecorder2.mEncoderSync.setAudioEncoded();
                    videoFileRecorder2.mEncoderSync.waitForEncodingReady();
                }
            }
        }
    }

    public static interface IRecordingStateChangedListener {
        public void onStateChanged(RecordingState var1);
    }
}

