/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.renderer;

import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.Surface;
import androidx.annotation.Keep;
import java.util.ArrayList;

@Keep
public class VideoTextureProvider
implements SurfaceTexture.OnFrameAvailableListener {
    private static final ArrayList<VideoTextureProvider> allTextures = new ArrayList();
    private Surface surface = null;
    private SurfaceTexture surfaceTexture = null;
    private boolean isValid = false;
    private boolean isAvailable = false;
    private HandlerThread mHandlerThread;
    private Handler mHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkValidAll() {
        ArrayList<VideoTextureProvider> arrayList = allTextures;
        synchronized (arrayList) {
            boolean bl = true;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                bl &= VideoTextureProvider.allTextures.get((int)i).isValid;
                continue;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Surface createSurfaceTexture(int n) {
        Handler handler;
        VideoTextureProvider videoTextureProvider = this;
        videoTextureProvider.surfaceTexture = new SurfaceTexture(n);
        videoTextureProvider.surface = new Surface(this.surfaceTexture);
        this.mHandlerThread = new HandlerThread("VideoTextureProviderThread");
        this.mHandlerThread.start();
        Object object = handler;
        videoTextureProvider.mHandler = new Handler(this.mHandlerThread.getLooper());
        videoTextureProvider.surfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this, object);
        object = allTextures;
        synchronized (object) {
            object.add((VideoTextureProvider)this);
            return videoTextureProvider.surface;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void removeSurfaceTexture() {
        block5: {
            VideoTextureProvider videoTextureProvider;
            ArrayList<VideoTextureProvider> arrayList = allTextures;
            synchronized (arrayList) {
                arrayList.remove(this);
                {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : arrayList
                    if (this.surfaceTexture == null) break block5;
                    videoTextureProvider = this;
                }
            }
            videoTextureProvider.surface.release();
            videoTextureProvider.surfaceTexture.release();
        }
        if ((this = this.mHandlerThread) != null) {
            this.quitSafely();
        }
    }

    public synchronized void update() {
        if (this.isAvailable) {
            this.surfaceTexture.updateTexImage();
            this.isAvailable = false;
            this.isValid = true;
        }
    }

    public synchronized boolean isReadyOnGPU() {
        return this.isValid || this.isAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        VideoTextureProvider videoTextureProvider = this;
        synchronized (videoTextureProvider) {
            videoTextureProvider.isAvailable = true;
            return;
        }
    }
}

