/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk;

import androidx.annotation.Keep;
import androidx.annotation.Nullable;

@Keep
public final class Recycler {
    public static <T> T recycle(@Nullable T t) {
        if (t == null) {
            return null;
        }
        try {
            t.getClass().getMethod("_djinni_private_destroy", new Class[0]).invoke(t, new Object[0]);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(t.getClass().getName() + " isn't releasable Banuba SDK class", exception);
        }
        return null;
    }

    private Recycler() {
    }

    public static class RecycleGuard<T>
    implements AutoCloseable {
        private T mObj;

        public RecycleGuard(T t) {
            this.mObj = t;
        }

        @Override
        public void close() {
            Recycler.recycle(this.mObj);
        }
    }
}

