/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.effect_player;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.effect_player.EffectStatus;
import com.banuba.sdk.effect_player.JsCallback;
import com.banuba.sdk.scene.Scene;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface Effect {
    @NonNull
    public String url();

    public void callJsMethod(@NonNull String var1, @NonNull String var2);

    public void evalJs(@NonNull String var1, @Nullable JsCallback var2);

    @NonNull
    public String evalJsSync(@NonNull String var1);

    public void reset();

    public void update();

    @Nullable
    public Scene scene();

    public void deserialize(@NonNull String var1, @NonNull String var2);

    public void activate(int var1, int var2, int var3, int var4);

    public void dumpFs(@NonNull String var1);

    public void dump();

    @NonNull
    public String dumpJson();

    @NonNull
    public EffectStatus status();

    @Keep
    public static final class CppProxy
    implements Effect {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native String native_url(long var1);

        private native void native_callJsMethod(long var1, String var3, String var4);

        private native void native_evalJs(long var1, String var3, JsCallback var4);

        private native String native_evalJsSync(long var1, String var3);

        private native void native_reset(long var1);

        private native void native_update(long var1);

        private native Scene native_scene(long var1);

        private native void native_deserialize(long var1, String var3, String var4);

        private native void native_activate(long var1, int var3, int var4, int var5, int var6);

        private native void native_dumpFs(long var1, String var3);

        private native void native_dump(long var1);

        private native String native_dumpJson(long var1);

        private native EffectStatus native_status(long var1);

        static {
            $assertionsDisabled = Effect.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public String url() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_url(cppProxy.nativeRef);
        }

        @Override
        public void callJsMethod(String string, String string2) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_callJsMethod(cppProxy.nativeRef, string, string2);
        }

        @Override
        public void evalJs(String string, JsCallback jsCallback) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_evalJs(cppProxy.nativeRef, string, jsCallback);
        }

        @Override
        public String evalJsSync(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_evalJsSync(cppProxy.nativeRef, string);
        }

        @Override
        public void reset() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_reset(cppProxy.nativeRef);
        }

        @Override
        public void update() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_update(cppProxy.nativeRef);
        }

        @Override
        public Scene scene() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_scene(cppProxy.nativeRef);
        }

        @Override
        public void deserialize(String string, String string2) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_deserialize(cppProxy.nativeRef, string, string2);
        }

        @Override
        public void activate(int n, int n2, int n3, int n4) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_activate(cppProxy.nativeRef, n, n2, n3, n4);
        }

        @Override
        public void dumpFs(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_dumpFs(cppProxy.nativeRef, string);
        }

        @Override
        public void dump() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_dump(cppProxy.nativeRef);
        }

        @Override
        public String dumpJson() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_dumpJson(cppProxy.nativeRef);
        }

        @Override
        public EffectStatus status() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_status(cppProxy.nativeRef);
        }
    }
}

