/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.effect_player;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.effect_player.Effect;
import com.banuba.sdk.effect_player.EffectActivatedListener;
import com.banuba.sdk.effect_player.EffectEventListener;
import com.banuba.sdk.effect_player.EffectInfo;
import com.banuba.sdk.effect_player.ErrorListener;
import com.banuba.sdk.effect_player.HintListener;
import com.banuba.sdk.effect_player.ReloadResult;
import com.banuba.sdk.effect_player.SurfaceData;
import com.banuba.sdk.types.Size;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface EffectManager {
    @NonNull
    public static EffectInfo getEffectInfo(@NonNull String string) {
        return CppProxy.getEffectInfo(string);
    }

    public void addErrorListener(@Nullable ErrorListener var1);

    public void removeErrorListener(@Nullable ErrorListener var1);

    public void addHintListener(@Nullable HintListener var1);

    public void removeHintListener(@Nullable HintListener var1);

    public void addEffectEventListener(@Nullable EffectEventListener var1);

    public void removeEffectEventListener(@Nullable EffectEventListener var1);

    public void addEffectActivatedListener(@Nullable EffectActivatedListener var1);

    public void removeEffectActivatedListener(@Nullable EffectActivatedListener var1);

    @Nullable
    public Effect createEffect(@NonNull String var1);

    public void setCurrentEffect(@Nullable Effect var1);

    @Nullable
    public Effect load(@NonNull String var1);

    @Nullable
    public Effect loadAsync(@NonNull String var1);

    @Nullable
    public ReloadResult reloadConfig(@NonNull String var1);

    public void unload(@Nullable Effect var1);

    @Nullable
    public Effect current();

    public void update(boolean var1);

    @NonNull
    public Size effectSize();

    @NonNull
    public Size surfaceSize();

    public float effectVolume();

    public void setEffectVolume(float var1);

    public void setEffectSize(int var1, int var2);

    public void setRenderSurface(@NonNull SurfaceData var1);

    public void disableSurfacePresentation();

    @Keep
    public static final class CppProxy
    implements EffectManager {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native void native_addErrorListener(long var1, ErrorListener var3);

        private native void native_removeErrorListener(long var1, ErrorListener var3);

        private native void native_addHintListener(long var1, HintListener var3);

        private native void native_removeHintListener(long var1, HintListener var3);

        private native void native_addEffectEventListener(long var1, EffectEventListener var3);

        private native void native_removeEffectEventListener(long var1, EffectEventListener var3);

        private native void native_addEffectActivatedListener(long var1, EffectActivatedListener var3);

        private native void native_removeEffectActivatedListener(long var1, EffectActivatedListener var3);

        private native Effect native_createEffect(long var1, String var3);

        private native void native_setCurrentEffect(long var1, Effect var3);

        private native Effect native_load(long var1, String var3);

        private native Effect native_loadAsync(long var1, String var3);

        private native ReloadResult native_reloadConfig(long var1, String var3);

        private native void native_unload(long var1, Effect var3);

        private native Effect native_current(long var1);

        private native void native_update(long var1, boolean var3);

        private native Size native_effectSize(long var1);

        private native Size native_surfaceSize(long var1);

        private native float native_effectVolume(long var1);

        private native void native_setEffectVolume(long var1, float var3);

        private native void native_setEffectSize(long var1, int var3, int var4);

        private native void native_setRenderSurface(long var1, SurfaceData var3);

        private native void native_disableSurfacePresentation(long var1);

        @NonNull
        public static native EffectInfo getEffectInfo(@NonNull String var0);

        static {
            $assertionsDisabled = EffectManager.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public void addErrorListener(ErrorListener errorListener) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_addErrorListener(cppProxy.nativeRef, errorListener);
        }

        @Override
        public void removeErrorListener(ErrorListener errorListener) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_removeErrorListener(cppProxy.nativeRef, errorListener);
        }

        @Override
        public void addHintListener(HintListener hintListener) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_addHintListener(cppProxy.nativeRef, hintListener);
        }

        @Override
        public void removeHintListener(HintListener hintListener) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_removeHintListener(cppProxy.nativeRef, hintListener);
        }

        @Override
        public void addEffectEventListener(EffectEventListener effectEventListener) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_addEffectEventListener(cppProxy.nativeRef, effectEventListener);
        }

        @Override
        public void removeEffectEventListener(EffectEventListener effectEventListener) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_removeEffectEventListener(cppProxy.nativeRef, effectEventListener);
        }

        @Override
        public void addEffectActivatedListener(EffectActivatedListener effectActivatedListener) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_addEffectActivatedListener(cppProxy.nativeRef, effectActivatedListener);
        }

        @Override
        public void removeEffectActivatedListener(EffectActivatedListener effectActivatedListener) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_removeEffectActivatedListener(cppProxy.nativeRef, effectActivatedListener);
        }

        @Override
        public Effect createEffect(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_createEffect(cppProxy.nativeRef, string);
        }

        @Override
        public void setCurrentEffect(Effect effect) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setCurrentEffect(cppProxy.nativeRef, effect);
        }

        @Override
        public Effect load(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_load(cppProxy.nativeRef, string);
        }

        @Override
        public Effect loadAsync(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_loadAsync(cppProxy.nativeRef, string);
        }

        @Override
        public ReloadResult reloadConfig(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_reloadConfig(cppProxy.nativeRef, string);
        }

        @Override
        public void unload(Effect effect) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_unload(cppProxy.nativeRef, effect);
        }

        @Override
        public Effect current() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_current(cppProxy.nativeRef);
        }

        @Override
        public void update(boolean bl) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_update(cppProxy.nativeRef, bl);
        }

        @Override
        public Size effectSize() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_effectSize(cppProxy.nativeRef);
        }

        @Override
        public Size surfaceSize() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_surfaceSize(cppProxy.nativeRef);
        }

        @Override
        public float effectVolume() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_effectVolume(cppProxy.nativeRef);
        }

        @Override
        public void setEffectVolume(float f) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setEffectVolume(cppProxy.nativeRef, f);
        }

        @Override
        public void setEffectSize(int n, int n2) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setEffectSize(cppProxy.nativeRef, n, n2);
        }

        @Override
        public void setRenderSurface(SurfaceData surfaceData) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setRenderSurface(cppProxy.nativeRef, surfaceData);
        }

        @Override
        public void disableSurfacePresentation() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_disableSurfacePresentation(cppProxy.nativeRef);
        }
    }
}

