/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.effect_player;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.effect_player.CameraOrientation;
import com.banuba.sdk.effect_player.CameraPoiListener;
import com.banuba.sdk.effect_player.ConsistencyMode;
import com.banuba.sdk.effect_player.EffectActivationCompletionListener;
import com.banuba.sdk.effect_player.EffectInfoListener;
import com.banuba.sdk.effect_player.EffectManager;
import com.banuba.sdk.effect_player.EffectPlayerConfiguration;
import com.banuba.sdk.effect_player.EffectPlayerPlaybackState;
import com.banuba.sdk.effect_player.FaceNumberListener;
import com.banuba.sdk.effect_player.FrameDataListener;
import com.banuba.sdk.effect_player.FrameDurationListener;
import com.banuba.sdk.effect_player.FrameProcessor;
import com.banuba.sdk.effect_player.InputManager;
import com.banuba.sdk.scene.RenderBackendType;
import com.banuba.sdk.types.Data;
import com.banuba.sdk.types.FrameData;
import com.banuba.sdk.types.FullImageData;
import com.banuba.sdk.types.PixelBuffer;
import com.banuba.sdk.types.PixelFormat;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface EffectPlayer {
    @Nullable
    public static EffectPlayer create(@Nullable EffectPlayerConfiguration effectPlayerConfiguration) {
        return CppProxy.create(effectPlayerConfiguration);
    }

    public static void setRenderBackend(@NonNull RenderBackendType renderBackendType) {
        CppProxy.setRenderBackend(renderBackendType);
    }

    @NonNull
    public static RenderBackendType getCurrentRenderBackendType() {
        return CppProxy.getCurrentRenderBackendType();
    }

    public void addFrameDurationListener(@Nullable FrameDurationListener var1);

    public void removeFrameDurationListener(@Nullable FrameDurationListener var1);

    public void addFaceNumberListener(@Nullable FaceNumberListener var1);

    public void removeFaceNumberListener(@Nullable FaceNumberListener var1);

    public void addFrameDataListener(@Nullable FrameDataListener var1);

    public void removeFrameDataListener(@Nullable FrameDataListener var1);

    public void addCameraPoiListener(@Nullable CameraPoiListener var1);

    public void removeCameraPoiListener(@Nullable CameraPoiListener var1);

    public void addEffectInfoListener(@Nullable EffectInfoListener var1);

    public void removeEffectInfoListener(@Nullable EffectInfoListener var1);

    public void addEffectActivationCompletionListener(@Nullable EffectActivationCompletionListener var1);

    public void removeEffectActivationCompletionListener(@Nullable EffectActivationCompletionListener var1);

    public void setMaxFaces(int var1);

    public void setExternalCameraTexture(int var1, int var2, int var3);

    public void setUseExtCamTex(boolean var1);

    public void surfaceCreated(int var1, int var2);

    public void surfaceChanged(int var1, int var2);

    public void surfaceDestroyed();

    public long draw();

    public long drawWithExternalFrameData(@Nullable FrameData var1);

    public void captureBlit(int var1, int var2);

    @NonNull
    public PixelBuffer readPixels();

    public void setRenderConsistencyMode(@NonNull ConsistencyMode var1);

    @NonNull
    public Data processImage(@NonNull FullImageData var1, @NonNull PixelFormat var2);

    @NonNull
    public Data processImageFrameData(@Nullable FrameData var1, @NonNull PixelFormat var2);

    @NonNull
    public byte[] processImageData(@NonNull byte[] var1, int var2, int var3, @NonNull CameraOrientation var4, boolean var5, @NonNull PixelFormat var6, @NonNull PixelFormat var7);

    public void pushFrame(@NonNull FullImageData var1);

    public void pushFrameWithNumber(@NonNull FullImageData var1, long var2);

    public void pushFrameData(@Nullable FrameData var1);

    public void pushFrameDataWithNumber(@Nullable FrameData var1, long var2);

    public void playbackPlay();

    public void playbackPause();

    public void playbackStop();

    @NonNull
    public EffectPlayerPlaybackState getPlaybackState();

    @Nullable
    public InputManager getInputManager();

    public void startVideoProcessing(long var1, long var3, @NonNull CameraOrientation var5, boolean var6, boolean var7);

    public void stopVideoProcessing(boolean var1);

    @Nullable
    public FrameData processVideoFrameData(@Nullable FrameData var1, @Nullable Integer var2);

    @Nullable
    public FrameData processVideoFrame(@NonNull FullImageData var1, @Nullable Integer var2);

    @NonNull
    public Data drawVideoFrame(@Nullable FrameData var1, long var2, @NonNull PixelFormat var4);

    @NonNull
    public Data drawVideoFrameAllocated(@Nullable FrameData var1, long var2, @NonNull PixelFormat var4, @NonNull Data var5);

    public void writeRecordedAudio(@NonNull String var1, long var2);

    public void onVideoRecordStart(boolean var1);

    public void onVideoRecordEnd();

    @Nullable
    public EffectManager effectManager();

    public void setRecognizerOfflineMode(boolean var1);

    public void setRecognizerUseFutureFilter(boolean var1);

    public void setRecognizerUseFutureInterpolate(boolean var1);

    public void setFrameProcessor(@Nullable FrameProcessor var1);

    @Nullable
    public FrameProcessor frameProcessor();

    @Keep
    public static final class CppProxy
    implements EffectPlayer {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native void native_addFrameDurationListener(long var1, FrameDurationListener var3);

        private native void native_removeFrameDurationListener(long var1, FrameDurationListener var3);

        private native void native_addFaceNumberListener(long var1, FaceNumberListener var3);

        private native void native_removeFaceNumberListener(long var1, FaceNumberListener var3);

        private native void native_addFrameDataListener(long var1, FrameDataListener var3);

        private native void native_removeFrameDataListener(long var1, FrameDataListener var3);

        private native void native_addCameraPoiListener(long var1, CameraPoiListener var3);

        private native void native_removeCameraPoiListener(long var1, CameraPoiListener var3);

        private native void native_addEffectInfoListener(long var1, EffectInfoListener var3);

        private native void native_removeEffectInfoListener(long var1, EffectInfoListener var3);

        private native void native_addEffectActivationCompletionListener(long var1, EffectActivationCompletionListener var3);

        private native void native_removeEffectActivationCompletionListener(long var1, EffectActivationCompletionListener var3);

        private native void native_setMaxFaces(long var1, int var3);

        private native void native_setExternalCameraTexture(long var1, int var3, int var4, int var5);

        private native void native_setUseExtCamTex(long var1, boolean var3);

        private native void native_surfaceCreated(long var1, int var3, int var4);

        private native void native_surfaceChanged(long var1, int var3, int var4);

        private native void native_surfaceDestroyed(long var1);

        private native long native_draw(long var1);

        private native long native_drawWithExternalFrameData(long var1, FrameData var3);

        private native void native_captureBlit(long var1, int var3, int var4);

        private native PixelBuffer native_readPixels(long var1);

        private native void native_setRenderConsistencyMode(long var1, ConsistencyMode var3);

        private native Data native_processImage(long var1, FullImageData var3, PixelFormat var4);

        private native Data native_processImageFrameData(long var1, FrameData var3, PixelFormat var4);

        private native byte[] native_processImageData(long var1, byte[] var3, int var4, int var5, CameraOrientation var6, boolean var7, PixelFormat var8, PixelFormat var9);

        private native void native_pushFrame(long var1, FullImageData var3);

        private native void native_pushFrameWithNumber(long var1, FullImageData var3, long var4);

        private native void native_pushFrameData(long var1, FrameData var3);

        private native void native_pushFrameDataWithNumber(long var1, FrameData var3, long var4);

        private native void native_playbackPlay(long var1);

        private native void native_playbackPause(long var1);

        private native void native_playbackStop(long var1);

        private native EffectPlayerPlaybackState native_getPlaybackState(long var1);

        private native InputManager native_getInputManager(long var1);

        private native void native_startVideoProcessing(long var1, long var3, long var5, CameraOrientation var7, boolean var8, boolean var9);

        private native void native_stopVideoProcessing(long var1, boolean var3);

        private native FrameData native_processVideoFrameData(long var1, FrameData var3, Integer var4);

        private native FrameData native_processVideoFrame(long var1, FullImageData var3, Integer var4);

        private native Data native_drawVideoFrame(long var1, FrameData var3, long var4, PixelFormat var6);

        private native Data native_drawVideoFrameAllocated(long var1, FrameData var3, long var4, PixelFormat var6, Data var7);

        private native void native_writeRecordedAudio(long var1, String var3, long var4);

        private native void native_onVideoRecordStart(long var1, boolean var3);

        private native void native_onVideoRecordEnd(long var1);

        private native EffectManager native_effectManager(long var1);

        private native void native_setRecognizerOfflineMode(long var1, boolean var3);

        private native void native_setRecognizerUseFutureFilter(long var1, boolean var3);

        private native void native_setRecognizerUseFutureInterpolate(long var1, boolean var3);

        private native void native_setFrameProcessor(long var1, FrameProcessor var3);

        private native FrameProcessor native_frameProcessor(long var1);

        @Nullable
        public static native EffectPlayer create(@Nullable EffectPlayerConfiguration var0);

        public static native void setRenderBackend(@NonNull RenderBackendType var0);

        @NonNull
        public static native RenderBackendType getCurrentRenderBackendType();

        static {
            $assertionsDisabled = EffectPlayer.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public void addFrameDurationListener(FrameDurationListener frameDurationListener) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_addFrameDurationListener(cppProxy.nativeRef, frameDurationListener);
        }

        @Override
        public void removeFrameDurationListener(FrameDurationListener frameDurationListener) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_removeFrameDurationListener(cppProxy.nativeRef, frameDurationListener);
        }

        @Override
        public void addFaceNumberListener(FaceNumberListener faceNumberListener) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_addFaceNumberListener(cppProxy.nativeRef, faceNumberListener);
        }

        @Override
        public void removeFaceNumberListener(FaceNumberListener faceNumberListener) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_removeFaceNumberListener(cppProxy.nativeRef, faceNumberListener);
        }

        @Override
        public void addFrameDataListener(FrameDataListener frameDataListener) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_addFrameDataListener(cppProxy.nativeRef, frameDataListener);
        }

        @Override
        public void removeFrameDataListener(FrameDataListener frameDataListener) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_removeFrameDataListener(cppProxy.nativeRef, frameDataListener);
        }

        @Override
        public void addCameraPoiListener(CameraPoiListener cameraPoiListener) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_addCameraPoiListener(cppProxy.nativeRef, cameraPoiListener);
        }

        @Override
        public void removeCameraPoiListener(CameraPoiListener cameraPoiListener) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_removeCameraPoiListener(cppProxy.nativeRef, cameraPoiListener);
        }

        @Override
        public void addEffectInfoListener(EffectInfoListener effectInfoListener) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_addEffectInfoListener(cppProxy.nativeRef, effectInfoListener);
        }

        @Override
        public void removeEffectInfoListener(EffectInfoListener effectInfoListener) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_removeEffectInfoListener(cppProxy.nativeRef, effectInfoListener);
        }

        @Override
        public void addEffectActivationCompletionListener(EffectActivationCompletionListener effectActivationCompletionListener) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_addEffectActivationCompletionListener(cppProxy.nativeRef, effectActivationCompletionListener);
        }

        @Override
        public void removeEffectActivationCompletionListener(EffectActivationCompletionListener effectActivationCompletionListener) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_removeEffectActivationCompletionListener(cppProxy.nativeRef, effectActivationCompletionListener);
        }

        @Override
        public void setMaxFaces(int n) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setMaxFaces(cppProxy.nativeRef, n);
        }

        @Override
        public void setExternalCameraTexture(int n, int n2, int n3) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setExternalCameraTexture(cppProxy.nativeRef, n, n2, n3);
        }

        @Override
        public void setUseExtCamTex(boolean bl) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setUseExtCamTex(cppProxy.nativeRef, bl);
        }

        @Override
        public void surfaceCreated(int n, int n2) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_surfaceCreated(cppProxy.nativeRef, n, n2);
        }

        @Override
        public void surfaceChanged(int n, int n2) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_surfaceChanged(cppProxy.nativeRef, n, n2);
        }

        @Override
        public void surfaceDestroyed() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_surfaceDestroyed(cppProxy.nativeRef);
        }

        @Override
        public long draw() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_draw(cppProxy.nativeRef);
        }

        @Override
        public long drawWithExternalFrameData(FrameData frameData) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_drawWithExternalFrameData(cppProxy.nativeRef, frameData);
        }

        @Override
        public void captureBlit(int n, int n2) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_captureBlit(cppProxy.nativeRef, n, n2);
        }

        @Override
        public PixelBuffer readPixels() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_readPixels(cppProxy.nativeRef);
        }

        @Override
        public void setRenderConsistencyMode(ConsistencyMode consistencyMode) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setRenderConsistencyMode(cppProxy.nativeRef, consistencyMode);
        }

        @Override
        public Data processImage(FullImageData fullImageData, PixelFormat pixelFormat) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_processImage(cppProxy.nativeRef, fullImageData, pixelFormat);
        }

        @Override
        public Data processImageFrameData(FrameData frameData, PixelFormat pixelFormat) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_processImageFrameData(cppProxy.nativeRef, frameData, pixelFormat);
        }

        @Override
        public byte[] processImageData(byte[] byArray, int n, int n2, CameraOrientation cameraOrientation, boolean bl, PixelFormat pixelFormat, PixelFormat pixelFormat2) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_processImageData(cppProxy.nativeRef, byArray, n, n2, cameraOrientation, bl, pixelFormat, pixelFormat2);
        }

        @Override
        public void pushFrame(FullImageData fullImageData) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_pushFrame(cppProxy.nativeRef, fullImageData);
        }

        @Override
        public void pushFrameWithNumber(FullImageData fullImageData, long l) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_pushFrameWithNumber(cppProxy.nativeRef, fullImageData, l);
        }

        @Override
        public void pushFrameData(FrameData frameData) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_pushFrameData(cppProxy.nativeRef, frameData);
        }

        @Override
        public void pushFrameDataWithNumber(FrameData frameData, long l) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_pushFrameDataWithNumber(cppProxy.nativeRef, frameData, l);
        }

        @Override
        public void playbackPlay() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_playbackPlay(cppProxy.nativeRef);
        }

        @Override
        public void playbackPause() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_playbackPause(cppProxy.nativeRef);
        }

        @Override
        public void playbackStop() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_playbackStop(cppProxy.nativeRef);
        }

        @Override
        public EffectPlayerPlaybackState getPlaybackState() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getPlaybackState(cppProxy.nativeRef);
        }

        @Override
        public InputManager getInputManager() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getInputManager(cppProxy.nativeRef);
        }

        @Override
        public void startVideoProcessing(long l, long l2, CameraOrientation cameraOrientation, boolean bl, boolean bl2) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_startVideoProcessing(cppProxy.nativeRef, l, l2, cameraOrientation, bl, bl2);
        }

        @Override
        public void stopVideoProcessing(boolean bl) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_stopVideoProcessing(cppProxy.nativeRef, bl);
        }

        @Override
        public FrameData processVideoFrameData(FrameData frameData, Integer n) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_processVideoFrameData(cppProxy.nativeRef, frameData, n);
        }

        @Override
        public FrameData processVideoFrame(FullImageData fullImageData, Integer n) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_processVideoFrame(cppProxy.nativeRef, fullImageData, n);
        }

        @Override
        public Data drawVideoFrame(FrameData frameData, long l, PixelFormat pixelFormat) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_drawVideoFrame(cppProxy.nativeRef, frameData, l, pixelFormat);
        }

        @Override
        public Data drawVideoFrameAllocated(FrameData frameData, long l, PixelFormat pixelFormat, Data data) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_drawVideoFrameAllocated(cppProxy.nativeRef, frameData, l, pixelFormat, data);
        }

        @Override
        public void writeRecordedAudio(String string, long l) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_writeRecordedAudio(cppProxy.nativeRef, string, l);
        }

        @Override
        public void onVideoRecordStart(boolean bl) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_onVideoRecordStart(cppProxy.nativeRef, bl);
        }

        @Override
        public void onVideoRecordEnd() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_onVideoRecordEnd(cppProxy.nativeRef);
        }

        @Override
        public EffectManager effectManager() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_effectManager(cppProxy.nativeRef);
        }

        @Override
        public void setRecognizerOfflineMode(boolean bl) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setRecognizerOfflineMode(cppProxy.nativeRef, bl);
        }

        @Override
        public void setRecognizerUseFutureFilter(boolean bl) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setRecognizerUseFutureFilter(cppProxy.nativeRef, bl);
        }

        @Override
        public void setRecognizerUseFutureInterpolate(boolean bl) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setRecognizerUseFutureInterpolate(cppProxy.nativeRef, bl);
        }

        @Override
        public void setFrameProcessor(FrameProcessor frameProcessor) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setFrameProcessor(cppProxy.nativeRef, frameProcessor);
        }

        @Override
        public FrameProcessor frameProcessor() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_frameProcessor(cppProxy.nativeRef);
        }
    }
}

