/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.effect_player;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.effect_player.ProcessorConfiguration;
import com.banuba.sdk.effect_player.ProcessorResult;
import com.banuba.sdk.effect_player.ProcessorType;
import com.banuba.sdk.effect_player.RealtimeProcessorMode;
import com.banuba.sdk.types.FrameData;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface FrameProcessor {
    @Nullable
    public static FrameProcessor createRealtimeProcessor(@NonNull RealtimeProcessorMode realtimeProcessorMode, @Nullable ProcessorConfiguration processorConfiguration) {
        return CppProxy.createRealtimeProcessor(realtimeProcessorMode, processorConfiguration);
    }

    @Nullable
    public static FrameProcessor createPhotoProcessor(@Nullable ProcessorConfiguration processorConfiguration) {
        return CppProxy.createPhotoProcessor(processorConfiguration);
    }

    @Nullable
    public static FrameProcessor createVideoProcessor(@Nullable ProcessorConfiguration processorConfiguration) {
        return CppProxy.createVideoProcessor(processorConfiguration);
    }

    @NonNull
    public ProcessorType getType();

    public void push(@Nullable FrameData var1);

    @NonNull
    public ProcessorResult pop();

    @Keep
    public static final class CppProxy
    implements FrameProcessor {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native ProcessorType native_getType(long var1);

        private native void native_push(long var1, FrameData var3);

        private native ProcessorResult native_pop(long var1);

        @Nullable
        public static native FrameProcessor createRealtimeProcessor(@NonNull RealtimeProcessorMode var0, @Nullable ProcessorConfiguration var1);

        @Nullable
        public static native FrameProcessor createPhotoProcessor(@Nullable ProcessorConfiguration var0);

        @Nullable
        public static native FrameProcessor createVideoProcessor(@Nullable ProcessorConfiguration var0);

        static {
            $assertionsDisabled = FrameProcessor.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public ProcessorType getType() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getType(cppProxy.nativeRef);
        }

        @Override
        public void push(FrameData frameData) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_push(cppProxy.nativeRef, frameData);
        }

        @Override
        public ProcessorResult pop() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_pop(cppProxy.nativeRef);
        }
    }
}

