/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.effect_player;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import com.banuba.sdk.types.Touch;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface InputManager {
    public void onTouchesBegan(@NonNull HashMap<Long, Touch> var1);

    public void onTouchesMoved(@NonNull HashMap<Long, Touch> var1);

    public void onTouchesEnded(@NonNull HashMap<Long, Touch> var1);

    public void onTouchesCancelled(@NonNull HashMap<Long, Touch> var1);

    public void onRotationGesture(float var1);

    public void onScaleGesture(float var1);

    public void onSwipeGesture(float var1, float var2);

    public void onDoubleTapGesture(@NonNull Touch var1);

    public void onLongTapGesture(@NonNull Touch var1);

    public void onGestureEnded(@NonNull String var1);

    @Keep
    public static final class CppProxy
    implements InputManager {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native void native_onTouchesBegan(long var1, HashMap<Long, Touch> var3);

        private native void native_onTouchesMoved(long var1, HashMap<Long, Touch> var3);

        private native void native_onTouchesEnded(long var1, HashMap<Long, Touch> var3);

        private native void native_onTouchesCancelled(long var1, HashMap<Long, Touch> var3);

        private native void native_onRotationGesture(long var1, float var3);

        private native void native_onScaleGesture(long var1, float var3);

        private native void native_onSwipeGesture(long var1, float var3, float var4);

        private native void native_onDoubleTapGesture(long var1, Touch var3);

        private native void native_onLongTapGesture(long var1, Touch var3);

        private native void native_onGestureEnded(long var1, String var3);

        static {
            $assertionsDisabled = InputManager.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public void onTouchesBegan(HashMap<Long, Touch> hashMap) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_onTouchesBegan(cppProxy.nativeRef, hashMap);
        }

        @Override
        public void onTouchesMoved(HashMap<Long, Touch> hashMap) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_onTouchesMoved(cppProxy.nativeRef, hashMap);
        }

        @Override
        public void onTouchesEnded(HashMap<Long, Touch> hashMap) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_onTouchesEnded(cppProxy.nativeRef, hashMap);
        }

        @Override
        public void onTouchesCancelled(HashMap<Long, Touch> hashMap) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_onTouchesCancelled(cppProxy.nativeRef, hashMap);
        }

        @Override
        public void onRotationGesture(float f) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_onRotationGesture(cppProxy.nativeRef, f);
        }

        @Override
        public void onScaleGesture(float f) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_onScaleGesture(cppProxy.nativeRef, f);
        }

        @Override
        public void onSwipeGesture(float f, float f2) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_onSwipeGesture(cppProxy.nativeRef, f, f2);
        }

        @Override
        public void onDoubleTapGesture(Touch touch) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_onDoubleTapGesture(cppProxy.nativeRef, touch);
        }

        @Override
        public void onLongTapGesture(Touch touch) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_onLongTapGesture(cppProxy.nativeRef, touch);
        }

        @Override
        public void onGestureEnded(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_onGestureEnded(cppProxy.nativeRef, string);
        }
    }
}

