/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.license_utils;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.license_utils.LicenseStatus;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface LicenseManager {
    @Nullable
    public static LicenseManager create(@NonNull String string) {
        return CppProxy.create(string);
    }

    @Nullable
    public static LicenseManager instance() {
        return CppProxy.instance();
    }

    @NonNull
    public LicenseStatus isExpired();

    @NonNull
    public String getJson();

    @NonNull
    public String getChecksum();

    @Keep
    public static final class CppProxy
    implements LicenseManager {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native LicenseStatus native_isExpired(long var1);

        private native String native_getJson(long var1);

        private native String native_getChecksum(long var1);

        @Nullable
        public static native LicenseManager create(@NonNull String var0);

        @Nullable
        public static native LicenseManager instance();

        static {
            $assertionsDisabled = LicenseManager.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public LicenseStatus isExpired() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_isExpired(cppProxy.nativeRef);
        }

        @Override
        public String getJson() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getJson(cppProxy.nativeRef);
        }

        @Override
        public String getChecksum() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getChecksum(cppProxy.nativeRef);
        }
    }
}

