/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.recognizer;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.types.FrameData;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface Feature {
    public long id();

    @NonNull
    public String name();

    public boolean requiresMainThread();

    public void clean();

    public void process(@Nullable FrameData var1);

    public void postprocess(@Nullable FrameData var1, @Nullable FrameData var2);

    @Keep
    public static final class CppProxy
    implements Feature {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native long native_id(long var1);

        private native String native_name(long var1);

        private native boolean native_requiresMainThread(long var1);

        private native void native_clean(long var1);

        private native void native_process(long var1, FrameData var3);

        private native void native_postprocess(long var1, FrameData var3, FrameData var4);

        static {
            $assertionsDisabled = Feature.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public long id() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_id(cppProxy.nativeRef);
        }

        @Override
        public String name() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_name(cppProxy.nativeRef);
        }

        @Override
        public boolean requiresMainThread() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_requiresMainThread(cppProxy.nativeRef);
        }

        @Override
        public void clean() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_clean(cppProxy.nativeRef);
        }

        @Override
        public void process(FrameData frameData) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_process(cppProxy.nativeRef, frameData);
        }

        @Override
        public void postprocess(FrameData frameData, FrameData frameData2) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_postprocess(cppProxy.nativeRef, frameData, frameData2);
        }
    }
}

