/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.recognizer;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.recognizer.Feature;
import com.banuba.sdk.recognizer.RecognizerMode;
import com.banuba.sdk.types.FeatureId;
import com.banuba.sdk.types.FrameData;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface Recognizer {
    @Nullable
    public static Recognizer create(@NonNull RecognizerMode recognizerMode) {
        return CppProxy.create(recognizerMode);
    }

    public static long getFeatureId(@NonNull FeatureId featureId) {
        return CppProxy.getFeatureId(featureId);
    }

    @Nullable
    public Feature getFeature(@NonNull FeatureId var1);

    public void setFeatures(@NonNull HashSet<FeatureId> var1);

    public void addFeature(@Nullable Feature var1, @NonNull HashSet<FeatureId> var2);

    public void removeFeature(@Nullable Feature var1);

    public void setMaxFaces(int var1);

    public void setOfflineMode(boolean var1);

    public void setUseFutureFilter(boolean var1);

    public void setUseFutureInterpolate(boolean var1);

    public void process(@Nullable FrameData var1);

    public void pushCameraFrame(@Nullable FrameData var1);

    public boolean popFrameData(@Nullable FrameData var1);

    public void start();

    public void pause();

    public void stop();

    public void clear();

    @Keep
    public static final class CppProxy
    implements Recognizer {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native Feature native_getFeature(long var1, FeatureId var3);

        private native void native_setFeatures(long var1, HashSet<FeatureId> var3);

        private native void native_addFeature(long var1, Feature var3, HashSet<FeatureId> var4);

        private native void native_removeFeature(long var1, Feature var3);

        private native void native_setMaxFaces(long var1, int var3);

        private native void native_setOfflineMode(long var1, boolean var3);

        private native void native_setUseFutureFilter(long var1, boolean var3);

        private native void native_setUseFutureInterpolate(long var1, boolean var3);

        private native void native_process(long var1, FrameData var3);

        private native void native_pushCameraFrame(long var1, FrameData var3);

        private native boolean native_popFrameData(long var1, FrameData var3);

        private native void native_start(long var1);

        private native void native_pause(long var1);

        private native void native_stop(long var1);

        private native void native_clear(long var1);

        @Nullable
        public static native Recognizer create(@NonNull RecognizerMode var0);

        public static native long getFeatureId(@NonNull FeatureId var0);

        static {
            $assertionsDisabled = Recognizer.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public Feature getFeature(FeatureId featureId) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getFeature(cppProxy.nativeRef, featureId);
        }

        @Override
        public void setFeatures(HashSet<FeatureId> hashSet) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setFeatures(cppProxy.nativeRef, hashSet);
        }

        @Override
        public void addFeature(Feature feature, HashSet<FeatureId> hashSet) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_addFeature(cppProxy.nativeRef, feature, hashSet);
        }

        @Override
        public void removeFeature(Feature feature) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_removeFeature(cppProxy.nativeRef, feature);
        }

        @Override
        public void setMaxFaces(int n) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setMaxFaces(cppProxy.nativeRef, n);
        }

        @Override
        public void setOfflineMode(boolean bl) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setOfflineMode(cppProxy.nativeRef, bl);
        }

        @Override
        public void setUseFutureFilter(boolean bl) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setUseFutureFilter(cppProxy.nativeRef, bl);
        }

        @Override
        public void setUseFutureInterpolate(boolean bl) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setUseFutureInterpolate(cppProxy.nativeRef, bl);
        }

        @Override
        public void process(FrameData frameData) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_process(cppProxy.nativeRef, frameData);
        }

        @Override
        public void pushCameraFrame(FrameData frameData) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_pushCameraFrame(cppProxy.nativeRef, frameData);
        }

        @Override
        public boolean popFrameData(FrameData frameData) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_popFrameData(cppProxy.nativeRef, frameData);
        }

        @Override
        public void start() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_start(cppProxy.nativeRef);
        }

        @Override
        public void pause() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_pause(cppProxy.nativeRef);
        }

        @Override
        public void stop() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_stop(cppProxy.nativeRef);
        }

        @Override
        public void clear() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_clear(cppProxy.nativeRef);
        }
    }
}

