/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.recognizer;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.utils.HardwareClass;
import com.banuba.sdk.utils.LogRecordCallback;
import com.banuba.sdk.utils.SeverityLevel;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface UtilityManager {
    public static void initialize(@NonNull ArrayList<String> arrayList, @NonNull String string) {
        CppProxy.initialize(arrayList, string);
    }

    public static void release() {
        CppProxy.release();
    }

    public static void addResourcePath(@NonNull String string) {
        CppProxy.addResourcePath(string);
    }

    public static void removeResourcePath(@NonNull String string) {
        CppProxy.removeResourcePath(string);
    }

    public static void diagnosticCrash() {
        CppProxy.diagnosticCrash();
    }

    @NonNull
    public static String cpuEnv() {
        return CppProxy.cpuEnv();
    }

    @NonNull
    public static HardwareClass getHardwareClass() {
        return CppProxy.getHardwareClass();
    }

    public static void setLogLevel(@NonNull SeverityLevel severityLevel) {
        CppProxy.setLogLevel(severityLevel);
    }

    public static void enableDiagnostics(@NonNull String string) {
        CppProxy.enableDiagnostics(string);
    }

    public static void enableTelemetry() {
        CppProxy.enableTelemetry();
    }

    public static void setLogRecordCallback(@Nullable LogRecordCallback logRecordCallback, @NonNull SeverityLevel severityLevel) {
        CppProxy.setLogRecordCallback(logRecordCallback, severityLevel);
    }

    @NonNull
    public static String getBanubaSdkVersionString() {
        return CppProxy.getBanubaSdkVersionString();
    }

    public static int getBanubaSdkVersion() {
        return CppProxy.getBanubaSdkVersion();
    }

    @NonNull
    public static String getBanubaSdkResourcesVersionString() {
        return CppProxy.getBanubaSdkResourcesVersionString();
    }

    public static int getBanubaSdkResourcesVersion() {
        return CppProxy.getBanubaSdkResourcesVersion();
    }

    @NonNull
    public static String getBanubaSdkResourcesVersionArchiveString() {
        return CppProxy.getBanubaSdkResourcesVersionArchiveString();
    }

    public static boolean checkBanubaSdkResourcesVersion() {
        return CppProxy.checkBanubaSdkResourcesVersion();
    }

    public static boolean checkBanubaSdkResourcesVersionIgnorePatch() {
        return CppProxy.checkBanubaSdkResourcesVersionIgnorePatch();
    }

    public static void loadGlFunctions() {
        CppProxy.loadGlFunctions();
    }

    @Keep
    public static final class CppProxy
    implements UtilityManager {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        public static native void initialize(@NonNull ArrayList<String> var0, @NonNull String var1);

        public static native void release();

        public static native void addResourcePath(@NonNull String var0);

        public static native void removeResourcePath(@NonNull String var0);

        public static native void diagnosticCrash();

        @NonNull
        public static native String cpuEnv();

        @NonNull
        public static native HardwareClass getHardwareClass();

        public static native void setLogLevel(@NonNull SeverityLevel var0);

        public static native void enableDiagnostics(@NonNull String var0);

        public static native void enableTelemetry();

        public static native void setLogRecordCallback(@Nullable LogRecordCallback var0, @NonNull SeverityLevel var1);

        @NonNull
        public static native String getBanubaSdkVersionString();

        public static native int getBanubaSdkVersion();

        @NonNull
        public static native String getBanubaSdkResourcesVersionString();

        public static native int getBanubaSdkResourcesVersion();

        @NonNull
        public static native String getBanubaSdkResourcesVersionArchiveString();

        public static native boolean checkBanubaSdkResourcesVersion();

        public static native boolean checkBanubaSdkResourcesVersionIgnorePatch();

        public static native void loadGlFunctions();

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }
    }
}

