/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.scene;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.scene.AudioTrack;
import com.banuba.sdk.scene.Face;
import com.banuba.sdk.scene.Hand;
import com.banuba.sdk.scene.Image;
import com.banuba.sdk.scene.ImageType;
import com.banuba.sdk.scene.Material;
import com.banuba.sdk.scene.Mesh;
import com.banuba.sdk.scene.Morphing;
import com.banuba.sdk.scene.MorphingType;
import com.banuba.sdk.scene.ProceduralAlgorithmType;
import com.banuba.sdk.scene.RenderTarget;
import com.banuba.sdk.scene.Resource;
import com.banuba.sdk.scene.SegmentationMaskType;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface AssetManager {
    @Nullable
    public Image createImage(@NonNull String var1, @NonNull ImageType var2);

    @Nullable
    public Resource createResource(@NonNull String var1);

    @Nullable
    public Image createSegmentationMask(@NonNull String var1, @NonNull SegmentationMaskType var2);

    @Nullable
    public Image createProceduralTexture(@NonNull String var1, @NonNull ProceduralAlgorithmType var2);

    @Nullable
    public RenderTarget createRenderTarget(@NonNull String var1);

    @Nullable
    public AudioTrack createAudioTrack(@NonNull String var1);

    @Nullable
    public Face createFace(@NonNull String var1);

    @Nullable
    public Morphing createMorph(@NonNull String var1, @NonNull MorphingType var2);

    @Nullable
    public Mesh createStaticMesh(@NonNull String var1);

    @Nullable
    public Mesh createDynamicMesh(@NonNull String var1, @NonNull String var2);

    @Nullable
    public Hand createHand(@NonNull String var1);

    public void uploadMeshData(@Nullable Mesh var1, @NonNull String var2);

    @Nullable
    public Material createMaterial(@NonNull String var1, @NonNull String var2);

    @Nullable
    public Material createMaterialExt(@NonNull String var1, @NonNull String var2, @NonNull String var3, int var4, @NonNull ArrayList<String> var5);

    @Nullable
    public Image findImage(@NonNull String var1);

    @Nullable
    public RenderTarget findRenderTarget(@NonNull String var1);

    @Nullable
    public AudioTrack findAudioTrack(@NonNull String var1);

    @Nullable
    public Face findFace(@NonNull String var1);

    @Nullable
    public Hand findHand(@NonNull String var1);

    @Nullable
    public Morphing findMorph(@NonNull String var1);

    @Nullable
    public Mesh findMesh(@NonNull String var1);

    @Nullable
    public Material findMaterial(@NonNull String var1);

    @Keep
    public static final class CppProxy
    implements AssetManager {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native Image native_createImage(long var1, String var3, ImageType var4);

        private native Resource native_createResource(long var1, String var3);

        private native Image native_createSegmentationMask(long var1, String var3, SegmentationMaskType var4);

        private native Image native_createProceduralTexture(long var1, String var3, ProceduralAlgorithmType var4);

        private native RenderTarget native_createRenderTarget(long var1, String var3);

        private native AudioTrack native_createAudioTrack(long var1, String var3);

        private native Face native_createFace(long var1, String var3);

        private native Morphing native_createMorph(long var1, String var3, MorphingType var4);

        private native Mesh native_createStaticMesh(long var1, String var3);

        private native Mesh native_createDynamicMesh(long var1, String var3, String var4);

        private native Hand native_createHand(long var1, String var3);

        private native void native_uploadMeshData(long var1, Mesh var3, String var4);

        private native Material native_createMaterial(long var1, String var3, String var4);

        private native Material native_createMaterialExt(long var1, String var3, String var4, String var5, int var6, ArrayList<String> var7);

        private native Image native_findImage(long var1, String var3);

        private native RenderTarget native_findRenderTarget(long var1, String var3);

        private native AudioTrack native_findAudioTrack(long var1, String var3);

        private native Face native_findFace(long var1, String var3);

        private native Hand native_findHand(long var1, String var3);

        private native Morphing native_findMorph(long var1, String var3);

        private native Mesh native_findMesh(long var1, String var3);

        private native Material native_findMaterial(long var1, String var3);

        static {
            $assertionsDisabled = AssetManager.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public Image createImage(String string, ImageType imageType) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_createImage(cppProxy.nativeRef, string, imageType);
        }

        @Override
        public Resource createResource(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_createResource(cppProxy.nativeRef, string);
        }

        @Override
        public Image createSegmentationMask(String string, SegmentationMaskType segmentationMaskType) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_createSegmentationMask(cppProxy.nativeRef, string, segmentationMaskType);
        }

        @Override
        public Image createProceduralTexture(String string, ProceduralAlgorithmType proceduralAlgorithmType) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_createProceduralTexture(cppProxy.nativeRef, string, proceduralAlgorithmType);
        }

        @Override
        public RenderTarget createRenderTarget(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_createRenderTarget(cppProxy.nativeRef, string);
        }

        @Override
        public AudioTrack createAudioTrack(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_createAudioTrack(cppProxy.nativeRef, string);
        }

        @Override
        public Face createFace(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_createFace(cppProxy.nativeRef, string);
        }

        @Override
        public Morphing createMorph(String string, MorphingType morphingType) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_createMorph(cppProxy.nativeRef, string, morphingType);
        }

        @Override
        public Mesh createStaticMesh(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_createStaticMesh(cppProxy.nativeRef, string);
        }

        @Override
        public Mesh createDynamicMesh(String string, String string2) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_createDynamicMesh(cppProxy.nativeRef, string, string2);
        }

        @Override
        public Hand createHand(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_createHand(cppProxy.nativeRef, string);
        }

        @Override
        public void uploadMeshData(Mesh mesh, String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_uploadMeshData(cppProxy.nativeRef, mesh, string);
        }

        @Override
        public Material createMaterial(String string, String string2) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_createMaterial(cppProxy.nativeRef, string, string2);
        }

        @Override
        public Material createMaterialExt(String string, String string2, String string3, int n, ArrayList<String> arrayList) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_createMaterialExt(cppProxy.nativeRef, string, string2, string3, n, arrayList);
        }

        @Override
        public Image findImage(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_findImage(cppProxy.nativeRef, string);
        }

        @Override
        public RenderTarget findRenderTarget(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_findRenderTarget(cppProxy.nativeRef, string);
        }

        @Override
        public AudioTrack findAudioTrack(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_findAudioTrack(cppProxy.nativeRef, string);
        }

        @Override
        public Face findFace(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_findFace(cppProxy.nativeRef, string);
        }

        @Override
        public Hand findHand(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_findHand(cppProxy.nativeRef, string);
        }

        @Override
        public Morphing findMorph(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_findMorph(cppProxy.nativeRef, string);
        }

        @Override
        public Mesh findMesh(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_findMesh(cppProxy.nativeRef, string);
        }

        @Override
        public Material findMaterial(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_findMaterial(cppProxy.nativeRef, string);
        }
    }
}

