/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.scene;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.scene.AttachmentInfo;
import com.banuba.sdk.scene.AttachmentType;
import com.banuba.sdk.scene.Image;
import com.banuba.sdk.scene.PixelFormatType;
import com.banuba.sdk.scene.TextureFilteringMode;
import com.banuba.sdk.scene.Vec4;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface Attachment {
    @NonNull
    public AttachmentType getAttachmentType();

    public void setType(@NonNull AttachmentType var1);

    public void setClearColor(@NonNull Vec4 var1);

    @NonNull
    public Vec4 getClearColor();

    public void setWidth(int var1);

    public void setHeight(int var1);

    public int getWidth();

    public int getHeight();

    public void setInfo(@NonNull AttachmentInfo var1);

    @NonNull
    public AttachmentInfo getInfo();

    public void setFormat(@NonNull PixelFormatType var1);

    @NonNull
    public PixelFormatType getFormat();

    public void setFilteringMode(@NonNull TextureFilteringMode var1);

    @NonNull
    public TextureFilteringMode getFilteringMode();

    @Nullable
    public Image asImage();

    @Keep
    public static final class CppProxy
    implements Attachment {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native AttachmentType native_getAttachmentType(long var1);

        private native void native_setType(long var1, AttachmentType var3);

        private native void native_setClearColor(long var1, Vec4 var3);

        private native Vec4 native_getClearColor(long var1);

        private native void native_setWidth(long var1, int var3);

        private native void native_setHeight(long var1, int var3);

        private native int native_getWidth(long var1);

        private native int native_getHeight(long var1);

        private native void native_setInfo(long var1, AttachmentInfo var3);

        private native AttachmentInfo native_getInfo(long var1);

        private native void native_setFormat(long var1, PixelFormatType var3);

        private native PixelFormatType native_getFormat(long var1);

        private native void native_setFilteringMode(long var1, TextureFilteringMode var3);

        private native TextureFilteringMode native_getFilteringMode(long var1);

        private native Image native_asImage(long var1);

        static {
            $assertionsDisabled = Attachment.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public AttachmentType getAttachmentType() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getAttachmentType(cppProxy.nativeRef);
        }

        @Override
        public void setType(AttachmentType attachmentType) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setType(cppProxy.nativeRef, attachmentType);
        }

        @Override
        public void setClearColor(Vec4 vec4) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setClearColor(cppProxy.nativeRef, vec4);
        }

        @Override
        public Vec4 getClearColor() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getClearColor(cppProxy.nativeRef);
        }

        @Override
        public void setWidth(int n) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setWidth(cppProxy.nativeRef, n);
        }

        @Override
        public void setHeight(int n) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setHeight(cppProxy.nativeRef, n);
        }

        @Override
        public int getWidth() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getWidth(cppProxy.nativeRef);
        }

        @Override
        public int getHeight() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getHeight(cppProxy.nativeRef);
        }

        @Override
        public void setInfo(AttachmentInfo attachmentInfo) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setInfo(cppProxy.nativeRef, attachmentInfo);
        }

        @Override
        public AttachmentInfo getInfo() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getInfo(cppProxy.nativeRef);
        }

        @Override
        public void setFormat(PixelFormatType pixelFormatType) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setFormat(cppProxy.nativeRef, pixelFormatType);
        }

        @Override
        public PixelFormatType getFormat() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getFormat(cppProxy.nativeRef);
        }

        @Override
        public void setFilteringMode(TextureFilteringMode textureFilteringMode) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setFilteringMode(cppProxy.nativeRef, textureFilteringMode);
        }

        @Override
        public TextureFilteringMode getFilteringMode() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getFilteringMode(cppProxy.nativeRef);
        }

        @Override
        public Image asImage() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_asImage(cppProxy.nativeRef);
        }
    }
}

