/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.scene;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.scene.Media;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface AudioTrack {
    public void setVolume(float var1);

    public float getVolume();

    public void load(@NonNull String var1);

    @NonNull
    public String getCurrentTrack();

    @Nullable
    public Media asMedia();

    @Keep
    public static final class CppProxy
    implements AudioTrack {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native void native_setVolume(long var1, float var3);

        private native float native_getVolume(long var1);

        private native void native_load(long var1, String var3);

        private native String native_getCurrentTrack(long var1);

        private native Media native_asMedia(long var1);

        static {
            $assertionsDisabled = AudioTrack.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public void setVolume(float f) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setVolume(cppProxy.nativeRef, f);
        }

        @Override
        public float getVolume() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getVolume(cppProxy.nativeRef);
        }

        @Override
        public void load(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_load(cppProxy.nativeRef, string);
        }

        @Override
        public String getCurrentTrack() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getCurrentTrack(cppProxy.nativeRef);
        }

        @Override
        public Media asMedia() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_asMedia(cppProxy.nativeRef);
        }
    }
}

