/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.scene;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.scene.BodyTrackerType;
import com.banuba.sdk.scene.Component;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface BodyTracker {
    @Nullable
    public static BodyTracker create() {
        return CppProxy.create();
    }

    @NonNull
    public BodyTrackerType getType();

    public void setType(@NonNull BodyTrackerType var1);

    public void setBodyIndex(int var1);

    public int getBodyIndex();

    @Nullable
    public Component asComponent();

    @Keep
    public static final class CppProxy
    implements BodyTracker {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native BodyTrackerType native_getType(long var1);

        private native void native_setType(long var1, BodyTrackerType var3);

        private native void native_setBodyIndex(long var1, int var3);

        private native int native_getBodyIndex(long var1);

        private native Component native_asComponent(long var1);

        @Nullable
        public static native BodyTracker create();

        static {
            $assertionsDisabled = BodyTracker.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public BodyTrackerType getType() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getType(cppProxy.nativeRef);
        }

        @Override
        public void setType(BodyTrackerType bodyTrackerType) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setType(cppProxy.nativeRef, bodyTrackerType);
        }

        @Override
        public void setBodyIndex(int n) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setBodyIndex(cppProxy.nativeRef, n);
        }

        @Override
        public int getBodyIndex() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getBodyIndex(cppProxy.nativeRef);
        }

        @Override
        public Component asComponent() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_asComponent(cppProxy.nativeRef);
        }
    }
}

