/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.scene;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.scene.Image;
import com.banuba.sdk.scene.Video;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface CameraComposer {
    public void setBackgroundImage(@NonNull String var1, boolean var2, boolean var3);

    public void setBackgroundImageByFd(int var1);

    public void setBackgroundVideoByFd(int var1, boolean var2, boolean var3);

    @Nullable
    public Image getBackgroundImage();

    @Nullable
    public Video getBackgroundVideo();

    public void enableBlur(boolean var1);

    public void setBlurRadius(int var1);

    public void setBgTransparencyFactor(float var1);

    public void setRotation(float var1);

    public void setScale(float var1, float var2);

    public void setContentMode(int var1);

    public void setBackgroundColor(float var1, float var2, float var3, float var4);

    public void setClearColor(float var1, float var2, float var3, float var4);

    @Keep
    public static final class CppProxy
    implements CameraComposer {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native void native_setBackgroundImage(long var1, String var3, boolean var4, boolean var5);

        private native void native_setBackgroundImageByFd(long var1, int var3);

        private native void native_setBackgroundVideoByFd(long var1, int var3, boolean var4, boolean var5);

        private native Image native_getBackgroundImage(long var1);

        private native Video native_getBackgroundVideo(long var1);

        private native void native_enableBlur(long var1, boolean var3);

        private native void native_setBlurRadius(long var1, int var3);

        private native void native_setBgTransparencyFactor(long var1, float var3);

        private native void native_setRotation(long var1, float var3);

        private native void native_setScale(long var1, float var3, float var4);

        private native void native_setContentMode(long var1, int var3);

        private native void native_setBackgroundColor(long var1, float var3, float var4, float var5, float var6);

        private native void native_setClearColor(long var1, float var3, float var4, float var5, float var6);

        static {
            $assertionsDisabled = CameraComposer.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public void setBackgroundImage(String string, boolean bl, boolean bl2) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setBackgroundImage(cppProxy.nativeRef, string, bl, bl2);
        }

        @Override
        public void setBackgroundImageByFd(int n) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setBackgroundImageByFd(cppProxy.nativeRef, n);
        }

        @Override
        public void setBackgroundVideoByFd(int n, boolean bl, boolean bl2) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setBackgroundVideoByFd(cppProxy.nativeRef, n, bl, bl2);
        }

        @Override
        public Image getBackgroundImage() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getBackgroundImage(cppProxy.nativeRef);
        }

        @Override
        public Video getBackgroundVideo() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getBackgroundVideo(cppProxy.nativeRef);
        }

        @Override
        public void enableBlur(boolean bl) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_enableBlur(cppProxy.nativeRef, bl);
        }

        @Override
        public void setBlurRadius(int n) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setBlurRadius(cppProxy.nativeRef, n);
        }

        @Override
        public void setBgTransparencyFactor(float f) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setBgTransparencyFactor(cppProxy.nativeRef, f);
        }

        @Override
        public void setRotation(float f) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setRotation(cppProxy.nativeRef, f);
        }

        @Override
        public void setScale(float f, float f2) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setScale(cppProxy.nativeRef, f, f2);
        }

        @Override
        public void setContentMode(int n) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setContentMode(cppProxy.nativeRef, n);
        }

        @Override
        public void setBackgroundColor(float f, float f2, float f3, float f4) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setBackgroundColor(cppProxy.nativeRef, f, f2, f3, f4);
        }

        @Override
        public void setClearColor(float f, float f2, float f3, float f4) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setClearColor(cppProxy.nativeRef, f, f2, f3, f4);
        }
    }
}

