/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.scene;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.scene.CameraTextureFormat;
import com.banuba.sdk.scene.Image;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface CameraTexture {
    @NonNull
    public CameraTextureFormat getFormat();

    public void setFormat(@NonNull CameraTextureFormat var1);

    @Nullable
    public Image asImage();

    @Keep
    public static final class CppProxy
    implements CameraTexture {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native CameraTextureFormat native_getFormat(long var1);

        private native void native_setFormat(long var1, CameraTextureFormat var3);

        private native Image native_asImage(long var1);

        static {
            $assertionsDisabled = CameraTexture.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public CameraTextureFormat getFormat() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getFormat(cppProxy.nativeRef);
        }

        @Override
        public void setFormat(CameraTextureFormat cameraTextureFormat) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setFormat(cppProxy.nativeRef, cameraTextureFormat);
        }

        @Override
        public Image asImage() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_asImage(cppProxy.nativeRef);
        }
    }
}

