/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.scene;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.scene.BodyTracker;
import com.banuba.sdk.scene.ComponentType;
import com.banuba.sdk.scene.FaceMorphing;
import com.banuba.sdk.scene.FaceTracker;
import com.banuba.sdk.scene.HandTracker;
import com.banuba.sdk.scene.MeshInstance;
import com.banuba.sdk.scene.Transformation3d;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface Component {
    @NonNull
    public ComponentType getComponentType();

    @Nullable
    public FaceTracker asFaceTracker();

    @Nullable
    public MeshInstance asMeshInstance();

    @Nullable
    public FaceMorphing asFaceMorphing();

    @Nullable
    public Transformation3d asTransformation();

    @Nullable
    public HandTracker asHandTracker();

    @Nullable
    public BodyTracker asBodyTracker();

    @Keep
    public static final class CppProxy
    implements Component {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native ComponentType native_getComponentType(long var1);

        private native FaceTracker native_asFaceTracker(long var1);

        private native MeshInstance native_asMeshInstance(long var1);

        private native FaceMorphing native_asFaceMorphing(long var1);

        private native Transformation3d native_asTransformation(long var1);

        private native HandTracker native_asHandTracker(long var1);

        private native BodyTracker native_asBodyTracker(long var1);

        static {
            $assertionsDisabled = Component.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public ComponentType getComponentType() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getComponentType(cppProxy.nativeRef);
        }

        @Override
        public FaceTracker asFaceTracker() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_asFaceTracker(cppProxy.nativeRef);
        }

        @Override
        public MeshInstance asMeshInstance() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_asMeshInstance(cppProxy.nativeRef);
        }

        @Override
        public FaceMorphing asFaceMorphing() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_asFaceMorphing(cppProxy.nativeRef);
        }

        @Override
        public Transformation3d asTransformation() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_asTransformation(cppProxy.nativeRef);
        }

        @Override
        public HandTracker asHandTracker() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_asHandTracker(cppProxy.nativeRef);
        }

        @Override
        public BodyTracker asBodyTracker() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_asBodyTracker(cppProxy.nativeRef);
        }
    }
}

